/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/*
 * RMSRecordSet.java
 *
 * Created on April 5, 2007, 3:25 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.microedition.testme.rms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

/**
 *
 * @author PavelBenes
 */
final class RMSEntry {
    private static final int          MAX_BLOCK_SIZE = 32000;

    private final RMSRecordSetManager mgr;
    private final String              name;
        
    public class RMSOutputStream extends OutputStream {
        private int                   streamIndex = 0; 
        private ByteArrayOutputStream buffer;

        public RMSOutputStream() {
            buffer = new ByteArrayOutputStream(1024);
        }

        public synchronized void write(int i) throws IOException {
            checkState();
            buffer.write(i);
            // call auto flush for large blocks
            if (buffer.size() >= MAX_BLOCK_SIZE) {
                flush();
            }
        }

        public synchronized void flush() throws IOException {
            checkState();
            
            RecordStore rs          = null;
            byte []     data        = buffer.toByteArray();
            boolean     writeFailed = false;
            
            while(true) {
                try {
                    rs = RecordStore.openRecordStore( name + "_" + streamIndex, true, RecordStore.AUTHMODE_ANY, true);
                    rs.addRecord( data, 0, data.length);
                    buffer.reset();
                    return;
                } catch(Exception e) {
                    if (!writeFailed) {
                        // try again with new RecordStore
                        streamIndex++;
                        writeFailed = true;
                    } else {
                        throw new IOException("Could not write to RMS, possibly full.");
                    }
    //                error = e;
                } finally {
                    if (rs != null) {
                        try {
                            rs.closeRecordStore();
                        } catch (RecordStoreException e) {
    //                        Logger.logError("RecordStore close failed after write operation.", e);
                        }
                    }
                }
            }
        }
        
        public synchronized void close() throws IOException {
            checkState();
            flush();
            buffer = null;
        }
        
        private void checkState() throws IOException {
            if (buffer == null) {
                throw new IOException("RMS stream is closed.");
            }
        }
    }

    public class RMSInputStream extends InputStream {
        private int     streamIndex = 0; 
        private byte [] buffer;
        private int     buffIndex = 0;
        private int     recordNum   = -1;
        private int     recordIndex = 0;

        public int read() throws IOException {
            RecordStore rs = null;

            if (buffer == null || buffIndex >= buffer.length) {
                try {
                    if (recordNum != -1 && recordIndex > recordNum) {
                        streamIndex++;
                        recordNum = -1;
                    }
                    rs = RecordStore.openRecordStore( name + "_" + streamIndex, false, RecordStore.AUTHMODE_ANY, false);
                    if (recordNum == -1) {
                        //RecordEnumeration recEnum = rs.enumerateRecords(null, null, false);
                        recordIndex = 1; //recEnum.nextRecordId();
                        recordNum   = rs.getNumRecords();
                        //recEnum.destroy();
                    }
                    buffer    = rs.getRecord(recordIndex++);
                    buffIndex = 0;
                } catch(RecordStoreNotFoundException e) {
                    return -1;
                } catch(Exception e) {
                    throw new IOException("Read failed.");
                } finally {
                    if (rs != null) {
                        try {
                            rs.closeRecordStore();
                        } catch (RecordStoreException e) {
    //                        Logger.logError("RecordStore close failed after write operation.", e);
                        }
                    }
                }
            }
            return buffer[buffIndex++];
        }        
    }
    
    /** Creates a new instance of RMSRecordSet */
    public RMSEntry( RMSRecordSetManager mgr, ByteArrayInputStream in) throws IOException {
        this.mgr  = mgr;
        this.name = Utils.readString(in);
    }

    public RMSEntry( RMSRecordSetManager mgr, String name) throws IOException {
        this.mgr  = mgr;
        this.name = name;
    }
    
    public String getName() {
        return this.name;
    }
    
    public OutputStream openWriter() throws IOException {
        return new RMSOutputStream();
    }
	
    public InputStream openReader() throws IOException {
        return new RMSInputStream();
    }
}
