/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.modules.masterfs.providers;

import java.io.IOException;
import org.openide.filesystems.FileSystem;

/**
 * Enables to mount and unmount filesystems.
 * The only way, how to get instance of MountSupport is to implement
 * org.netbeans.modules.masterfs.providers.FileSystemProvider#initialize
 * and keep passed instance of MountSupport. So, there is important to know, that
 * only filesystems, that have registered implementation of FileSystemProvider can
 * be mounted. There is obvious, that only already mounted filesystems can be unmounted.
 *
 * @see org.netbeans.modules.masterfs.providers.FileSystemProvider#initialize
 * @author  rm111737
 */
final public class MountSupport {
    /**
     * Mounts a file system on mount point defined by parameter mountPoint.
     * Once mounted filesystem must be first unmounted, before other filesystem can
     * be mounted on the same mountPoint.
     *
     * @param mountPoint corresponds to java.io.File.getAbstractPath.
     * But be aware, that this doesn't mean, that such file must really exist.
     * MountPoint may also address virtual location.
     * @param fs filesystem that should be mounted. FileObject hierarchy within a delegate FileSystem
     *  must precisely match the File hierarchy and must not hide any files which exist on disk.
     * @throws java.io.IOException when mount fails e.g.: there already exists mounted filesystem
     * assigned to passed mount point.
     */
    public void mount(String mountPoint, FileSystem fs) throws IOException {
        delegate.mount (mountPoint, fs);
    }

    /**
     * Unmounts already mounted filesystem.
     * @param fs filesystem, taht should be unmounted
     * @throws java.io.IOException  when unmount fails e.g.: passed fs hasn't
     * been mounted yet.
     */
    public void  unmount(FileSystem fs) throws IOException {
        delegate.unmount (fs);
    }

    /**
     * Private constructor.
     * @see org.netbeans.modules.masterfs.providers.FileSystemProvider#initialize
     */
    private MountSupport (org.netbeans.modules.masterfs.InternalMountSupport delegate) {
        this.delegate = delegate;
    }
    

    private static final class APIAccessImpl extends org.netbeans.modules.masterfs.APIAccess {
        public MountSupport createMountSupport(org.netbeans.modules.masterfs.InternalMountSupport sup) {
            return new MountSupport (sup);
        }
    }

    static {
        org.netbeans.modules.masterfs.APIAccess.DEFAULT = new APIAccessImpl ();
    }

    private org.netbeans.modules.masterfs.InternalMountSupport delegate;

}
