/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.scripting.php.dbginterface;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.scripting.php.dbginterface.api.VariableNode;


public class ToolTipAnnotation extends Annotation implements Runnable {

    private Line.Part lp;
    private EditorCookie ec;
    private DbgDebuggerImpl debugger;

    public String getShortDescription() {
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        
        if (currentEngine != null) {
            DbgDebuggerImpl debugger = (DbgDebuggerImpl)currentEngine.lookupFirst(null, DbgDebuggerImpl.class);
            
            if (debugger != null) {
                Line.Part lp = (Line.Part)getAttachedAnnotatable();
                
                if (lp != null) {
                    
                    Line line = lp.getLine();
                    
                    if (line != null) {
                        DataObject dob = DataEditorSupport.findDataObject(line);
                        
                        if (dob != null) {
                            EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
                            
                            if (ec != null) {
                                this.lp = lp;
                                this.ec = ec;
                                this.debugger = debugger;
                                RequestProcessor.getDefault().post(this);
                            }
                        }
                    }
                }
            }
        }

        return null;
    }

    public void run() {
        try {
            StyledDocument doc = ec.openDocument();

            JEditorPane ep = Utils.findJEditorPane(ec);
            
            if (ep == null) {
                return;
            }

            String expression = getIdentifier(doc, ep,
                    NbDocument.findLineOffset(doc, lp.getLine().getLineNumber()) + lp.getColumn());

            System.err.println("mw ToolTipAnnotation.run() expression= " + expression);
            if (expression == null) {
                return;
            }

            String value = null;
            VariableNode node = debugger.evaluateExpr(debugger.getVariablesModel().getCurrentFrame(),
                    expression);

            if (node != null) {
                value = node.getTooltipValue();
            }

            System.err.println("mw Evaluated: value = " + value + ", node = " + node);
            if (value == null || value.equals(expression)) {
                return;
            }

            String toolTipText =  expression + " = " + value ;
            firePropertyChange(PROP_SHORT_DESCRIPTION, null, toolTipText);
        } catch(IOException ex) {
            // Ignore this one.
        } catch(Exception ex) {
            // Log exceptions occuring during evaluation.
            ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex);
        }
    }

    public String getAnnotationType() {
        return null; // Currently return null annotation type
    }

    private static String getIdentifier(StyledDocument doc, JEditorPane ep, int offset) {
        String t = null;
        
        if ((ep.getSelectionStart() <= offset) && (offset <= ep.getSelectionEnd())) {
            t = ep.getSelectedText();
        }

        if (t != null) {
            return t;
        }

        int line = NbDocument.findLineNumber(doc, offset);
        int col = NbDocument.findLineColumn(doc, offset);

        try {
            Element lineElem = NbDocument.findLineRootElement(doc).getElement(line);

            if (lineElem == null) {
                return null;
            }

            int lineStartOffset = lineElem.getStartOffset();
            int lineLen = lineElem.getEndOffset() - lineStartOffset;
            t = doc.getText(lineStartOffset, lineLen);
            lineLen = t.length();

            int identStart = col;
            while (identStart > 0) {
                if (isIdentifierPrefixChar(t.charAt(identStart - 1))) {
                    identStart--;
                }
                else if (identStart > 3 && t.charAt(identStart - 1) == '>' &&
                        t.charAt(identStart - 2) == '-') {
                    identStart -= 2;
                }
                else {
                    break;
                }
            }

            if (t.charAt(identStart) != '$') {
                // That's not a variable!
                return null;
            }
            
            int identEnd = Math.max(col, 1);
            while (identEnd < lineLen && isIdentifierTrailingChar(t.charAt(identEnd - 1))) {
                identEnd++;
            }

            if (identStart > 0 && identEnd < lineLen &&
                    t.charAt(identStart - 1) == '"' && t.charAt(identEnd - 1) == '"') {
                identStart--;
                identEnd++;
            }

            if (identStart == identEnd) {
                return null;
            }

            return t.substring(identStart, identEnd - 1);
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private static boolean isIdentifierPrefixChar(char c) {
        return (c == '$') || (c == '_') || (c >= '0' && c <= '9') ||
                (c >= 'A' && c <= 'Z') || (c >= 'a' && c <= 'z') ||
                (c >= 0x7f && c <= 0xff);
    }

    private static boolean isIdentifierTrailingChar(char c) {
        return (c == '_') || (c >= '0' && c <= '9') ||
                (c >= 'A' && c <= 'Z') || (c >= 'a' && c <= 'z') ||
                (c >= 0x7f && c <= 0xff);
     }
}