/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.scripting.php.dbginterface;

import java.lang.reflect.InvocationTargetException;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.windows.TopComponent;

/**
 *
 * @author marcow (taken from Ant Debugger Utils)
 */
public class Utils {

    private static final boolean DEBUG = false;

    /*static void markCurrent (final Object line) {
        unmarkCurrent ();

        Annotatable[] annotatables = (Annotatable[]) line;
        int i = 0, k = annotatables.length;

        // first line with icon in gutter
        DebuggerAnnotation[] annotations = new DebuggerAnnotation [k];
        if (annotatables [i] instanceof Line.Part)
            annotations [i] = new DebuggerAnnotation (
                DebuggerAnnotation.CURRENT_LINE_PART_ANNOTATION_TYPE,
                annotatables [i]
            );
        else
            annotations [i] = new DebuggerAnnotation (
                DebuggerAnnotation.CURRENT_LINE_ANNOTATION_TYPE,
                annotatables [i]
            );

        // other lines
        for (i = 1; i < k; i++)
            if (annotatables [i] instanceof Line.Part)
                annotations [i] = new DebuggerAnnotation (
                    DebuggerAnnotation.CURRENT_LINE_PART_ANNOTATION_TYPE2,
                    annotatables [i]
                );
            else
                annotations [i] = new DebuggerAnnotation (
                    DebuggerAnnotation.CURRENT_LINE_ANNOTATION_TYPE2,
                    annotatables [i]
                );
        currentLine = annotations;

        showLine (line);
    }*/

    public static Line getLine(DataObject dataObject, int linenum) {
        Line result = null;
        
        try {
            EditorCookie editorCookie = (EditorCookie)
                dataObject.getCookie(EditorCookie.class);
            LineCookie lineCookie = (LineCookie)
                dataObject.getCookie(LineCookie.class);
            result = lineCookie.getLineSet().getOriginal(linenum - 1);
        } catch(Exception e) {
        }
        
        return result;
    }

    public static Line getCurrentLine() {
        Node[] nodes = TopComponent.getRegistry().getCurrentNodes();
        
        if(nodes == null || nodes.length != 1) {
            return null;
        }
        
        Node n = nodes[0];
        LineCookie lineCookie = (LineCookie) n.getCookie(LineCookie.class);

        if (lineCookie == null) {
            return null;
        }
        
        EditorCookie editorCookie = (EditorCookie)n.getCookie(EditorCookie.class);
        
        if (editorCookie == null) {
            return null;
        }

        JEditorPane jEditorPane = findJEditorPane(editorCookie);
        
        if (jEditorPane == null) {
            return null;
        }
        
        StyledDocument document = editorCookie.getDocument();
        
        if (document == null) {
            return null;
        }
        
        Caret caret = jEditorPane .getCaret();
        
        if (caret == null) {
            return null;
        }
        
        int lineNumber = NbDocument.findLineNumber(document, caret.getDot());
        
        try {
            return lineCookie.getLineSet().getCurrent(lineNumber);
        } catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public static boolean isPHPFile(FileObject fo) {
        if (fo == null) {
            return false;
        } else {
            return fo.getMIMEType().equals("application/x-php");
        }
    }

    //need to be in the Swing thread...
    public static JEditorPane findJEditorPane(final EditorCookie editor) {
        if (SwingUtilities.isEventDispatchThread()) {
            JEditorPane p[] =  editor.getOpenedPanes();
            if((p == null) || (p.length < 1)){
                return null;
            } else{
                return editor.getOpenedPanes()[0];

            }

        } else {//get the wing thread
            final JEditorPane ek[] = new JEditorPane[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable() {
                    public void run() {

                        JEditorPane p[] =  editor.getOpenedPanes();
                        if((p == null) || (p.length < 1)){
                            ek[0] = null;
                        } else{
                            ek[0]=editor.getOpenedPanes()[0];

                        }
                    }
                });
            } catch (InvocationTargetException ex) {
                ErrorManager.getDefault().notify(ex.getTargetException());
            } catch (InterruptedException ex) {
                ErrorManager.getDefault().notify(ex);
            }
            return ek[0];
        }
    }
}
