/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.scripting.php.dbginterface.models;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.scripting.php.dbginterface.ModelSupport;
import org.netbeans.modules.scripting.php.dbginterface.api.VariableNode;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class VariablesModel extends ModelSupport
        implements TreeModel, TableModel, NodeModel {

    private final ContextProvider contextProvider;

    private DebugFrame currentFrame; // Stack frame used to generate current model
    private VariableNode theModel;

    public VariablesModel(final ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.theModel = null;
    }

    public DebugFrame getCurrentFrame() {
        return currentFrame;
    }

    // ------------------------------------------------------------------------
    // Model management
    // ------------------------------------------------------------------------
    public void setStackFrame(DebugFrame newFrame) {
        if (currentFrame != newFrame) {
            currentFrame = newFrame;
        }

        // if model is undefined
        if (theModel == null) {
            theModel = currentFrame.getScopeVariables();
            fireTreeChanged();
        }
        else {
            Collection<ModelEvent> events = new ArrayList<ModelEvent>();
            
            theModel.collectUpdates(this, events, currentFrame.getScopeVariables());
            fireTableUpdate(events);
        }
    }

    public void clearModel() {
        theModel = null;
        fireTreeChanged();
    }


    // ------------------------------------------------------------------------
    // TreeModel implementation
    // ------------------------------------------------------------------------
    public Object getRoot() {
        return ROOT; // ROOT is defined by TreeModel
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        // Should be only two cases -- ROOT or a node from our tree
        if (parent == ROOT) {
            if (theModel == null) {
                return new Object[0];
            }
            
            return theModel.getChildren(0, theModel.getChildrenCount());
        }
        else if (parent instanceof VariableNode) {
            return ((VariableNode) parent).getChildren(from, to);
        }

        throw new UnknownTypeException(parent + " " + parent.getClass().getName());
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == null) {
            return true;
        }
        else if (node == ROOT) {
            return theModel == null;
        }
        else if (node instanceof VariableNode) {
            return ((VariableNode)node).isLeaf();
        }

        throw new UnknownTypeException(node);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == ROOT) {
            if (theModel == null) {
                return 0;
            }
            
            return theModel.getChildrenCount();
        }
        else if (node instanceof VariableNode) {
            return ((VariableNode)node).getChildrenCount();
        }
        
        throw new UnknownTypeException(node);
    }

    // ------------------------------------------------------------------------
    // TableModel implementation
    // ------------------------------------------------------------------------
    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        String result = ""; // default is blank

        if (Constants.LOCALS_TYPE_COLUMN_ID.equals(columnID)) {
            if (node instanceof VariableNode) {
                String className = ((VariableNode) node).getTypeName();
                result = (className == null) ? "" : className;
            }
            else {
                result = (node != null) ? node.getClass().getName() : "";
            }
        }
        else if (Constants.LOCALS_VALUE_COLUMN_ID.equals(columnID)) {
            if (node instanceof VariableNode) {
                VariableNode vn = (VariableNode) node;
                
                if (vn.isLeaf()) {
                    return vn.getTooltipValue();
                }
                else {
                    return "";
                }
            }
            else if (node == null) {
                result = "";
            }
        }

        return result;
    }

    public boolean isReadOnly(Object node, String string) throws UnknownTypeException {
        if (node instanceof VariableNode && Constants.LOCALS_VALUE_COLUMN_ID.equals(string)) {
            return ((VariableNode)node).isReadOnly();
        }
        
        return true;
    }

    public void setValueAt(Object node, String string, Object value) throws UnknownTypeException {
        if (!Constants.LOCALS_VALUE_COLUMN_ID.equals(string)) {
            throw new UnknownTypeException(node);
        }
        
        if (!(node instanceof VariableNode)) {
            throw new UnknownTypeException(node);
        }
        
        VariableNode v = (VariableNode)node;
        
        if (v.isReadOnly()) {
            throw new UnknownTypeException(node);
        }
        
        currentFrame.setVariableValue(v, value);
    }

    // ------------------------------------------------------------------------
    // NodeModel implementation
    // ------------------------------------------------------------------------
    public String getDisplayName(Object node) throws UnknownTypeException {
        if(node == null) {
            return "null";
        } else if(node == ROOT) {
            return ROOT;
        } else if(node instanceof VariableNode) {
            return ((VariableNode) node).getDisplayName();
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if(node == null || node == ROOT) {
            return VariableNode.LOCAL_VARIABLE_ICON;
        } else if(node instanceof VariableNode) {
            return ((VariableNode) node).getIconBase();
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if(node == null || node == ROOT) {
            return null;
        } else if(node instanceof VariableNode) {
            return ((VariableNode) node).getShortDescription();
        }
        throw new UnknownTypeException(node);
    }


    // ------------------------------------------------------------------------
    // Event support
    // ------------------------------------------------------------------------

    public void fireTreeChanged() {
        refresh(true);
    }

    private void fireTableUpdate(Collection<ModelEvent> events) {
        fireChangeEvents(events);
    }
}
