package org.netbeans.modules.j2ee.sun.ide.avk.report.view;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.sun.ide.avk.actions.AdminTasks;
import org.netbeans.modules.j2ee.sun.ide.avk.report.model.EnterpriseBean;
import org.netbeans.modules.j2ee.sun.ide.avk.report.model.ReportModel;
import org.netbeans.modules.j2ee.sun.ide.avk.report.model.WebComponent;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.awt.HtmlBrowser.URLDisplayer;
import org.openide.text.PositionBounds;
import org.openide.windows.InputOutput;

/**
 * Top component which displays something.
 * @author bshankar@sun.com
 */
final class ReportTopComponent extends TopComponent {
    
    private static final long serialVersionUID = 1L;
    
    private static ReportTopComponent instance;
    /** path to the icon used by the component and its open action */
//    static final String ICON_PATH = "SET/PATH/TO/ICON/HERE";
    
    private static final String PREFERRED_ID = "ReportTopComponent";
    
    private ReportTopComponent() {
        initComponents();
        setName(NbBundle.getMessage(ReportTopComponent.class, "CTL_ReportTopComponent"));
        setToolTipText(NbBundle.getMessage(ReportTopComponent.class, "HINT_ReportTopComponent"));
//        setIcon(Utilities.loadImage(ICON_PATH, true));
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jScrollPane1 = new javax.swing.JScrollPane();
        jPanel1 = new javax.swing.JPanel();
        summaryPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        appName = new javax.swing.JLabel();
        webCompPercentage = new javax.swing.JLabel();
        ejbCompPercentage = new javax.swing.JLabel();
        compsTabbedPane = new javax.swing.JTabbedPane();
        jScrollPane2 = new javax.swing.JScrollPane();
        webCompsPanel = new javax.swing.JPanel();
        webCompsUnSuccessfullyCalledPanel = new javax.swing.JPanel();
        webCompsUnSuccessfullyCalledTable = new javax.swing.JTable();
        webCompsNotCalledPanel = new javax.swing.JPanel();
        webCompsNotCalledTable = new javax.swing.JTable();
        webCompsSuccessfullyCalledPanel = new javax.swing.JPanel();
        webCompsSuccessfullyCalledTable = new javax.swing.JTable();
        jScrollPane3 = new javax.swing.JScrollPane();
        ejbCompsPanel = new javax.swing.JPanel();
        ejbMethodsUnSuccessfullyCalledPanel = new javax.swing.JPanel();
        ejbMethodsUnSuccessfullyCalledTable = new javax.swing.JTable();
        ejbMethodsNotCalledPanel = new javax.swing.JPanel();
        ejbMethodsNotCalledTable = new javax.swing.JTable();
        ejbMethodsSuccessfullyCalledPanel = new javax.swing.JPanel();
        ejbMethodsSuccessfullyCalledTable = new javax.swing.JTable();
        jButton1 = new javax.swing.JButton();

        jTabbedPane1.setTabPlacement(javax.swing.JTabbedPane.BOTTOM);
        jPanel1.setBackground(new java.awt.Color(255, 255, 255));
        summaryPanel.setBackground(new java.awt.Color(255, 255, 255));
        summaryPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("Summary"), javax.swing.border.TitledBorder.LEFT, javax.swing.border.TitledBorder.TOP, new java.awt.Font("Dialog", 1, 14)));
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("AppName"));

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("WebCompCoverage"));

        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("EjbCompCoverage"));

        org.openide.awt.Mnemonics.setLocalizedText(appName, getApplicationName());

        org.openide.awt.Mnemonics.setLocalizedText(webCompPercentage, getWebCompCoverage());

        org.openide.awt.Mnemonics.setLocalizedText(ejbCompPercentage, getEJBCompCoverage());

        org.jdesktop.layout.GroupLayout summaryPanelLayout = new org.jdesktop.layout.GroupLayout(summaryPanel);
        summaryPanel.setLayout(summaryPanelLayout);
        summaryPanelLayout.setHorizontalGroup(
            summaryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(summaryPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(summaryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 314, Short.MAX_VALUE)
                    .add(jLabel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 314, Short.MAX_VALUE)
                    .add(jLabel3))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(summaryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(webCompPercentage, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 453, Short.MAX_VALUE)
                    .add(appName, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 453, Short.MAX_VALUE)
                    .add(ejbCompPercentage, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 453, Short.MAX_VALUE))
                .addContainerGap())
        );
        summaryPanelLayout.setVerticalGroup(
            summaryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(summaryPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(summaryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(appName)
                    .add(jLabel1))
                .add(16, 16, 16)
                .add(summaryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(webCompPercentage)
                    .add(jLabel2))
                .add(15, 15, 15)
                .add(summaryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(ejbCompPercentage)
                    .add(jLabel3))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        webCompsPanel.setBackground(new java.awt.Color(255, 255, 255));
        webCompsUnSuccessfullyCalledPanel.setBackground(new java.awt.Color(255, 255, 255));
        webCompsUnSuccessfullyCalledPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("WebCompsUnsuccessfullyCalled"), javax.swing.border.TitledBorder.CENTER, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 11)));
        webCompsUnSuccessfullyCalledTable.setModel(new WebCompsUnSuccessfullyCalledTable(webCompsUnSuccessfullyCalledTable));
        webCompsUnSuccessfullyCalledTable.getColumnModel().getColumn(0).setPreferredWidth(500);
        webCompsUnSuccessfullyCalledTable.setShowHorizontalLines(false);
        webCompsUnSuccessfullyCalledTable.setShowVerticalLines(false);
        webCompsUnSuccessfullyCalledTable.setTableHeader(webCompsUnSuccessfullyCalledTable.getTableHeader());
        webCompsUnSuccessfullyCalledTable.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                webCompsUnSuccessfullyCalledTableMouseClicked(evt);
            }
        });

        webCompsUnSuccessfullyCalledTable.getAccessibleContext().setAccessibleParent(webCompsUnSuccessfullyCalledPanel);

        org.jdesktop.layout.GroupLayout webCompsUnSuccessfullyCalledPanelLayout = new org.jdesktop.layout.GroupLayout(webCompsUnSuccessfullyCalledPanel);
        webCompsUnSuccessfullyCalledPanel.setLayout(webCompsUnSuccessfullyCalledPanelLayout);
        webCompsUnSuccessfullyCalledPanelLayout.setHorizontalGroup(
            webCompsUnSuccessfullyCalledPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(webCompsUnSuccessfullyCalledTable, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 774, Short.MAX_VALUE)
        );
        webCompsUnSuccessfullyCalledPanelLayout.setVerticalGroup(
            webCompsUnSuccessfullyCalledPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(webCompsUnSuccessfullyCalledTable, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 92, Short.MAX_VALUE)
        );

        webCompsNotCalledPanel.setBackground(new java.awt.Color(255, 255, 255));
        webCompsNotCalledPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("WebCompsNotCalled"), javax.swing.border.TitledBorder.CENTER, javax.swing.border.TitledBorder.TOP, new java.awt.Font("Dialog", 1, 11)));
        webCompsNotCalledTable.setModel(new WebCompsNotCalledTable(webCompsNotCalledTable));
        webCompsNotCalledTable.getColumnModel().getColumn(0).setPreferredWidth(500);
        webCompsNotCalledTable.setMaximumSize(new java.awt.Dimension(10000000, 10000000));
        webCompsNotCalledTable.setShowHorizontalLines(false);
        webCompsNotCalledTable.setShowVerticalLines(false);
        webCompsNotCalledTable.setTableHeader(webCompsNotCalledTable.getTableHeader());
        webCompsNotCalledTable.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                webCompsNotCalledTableMouseClicked(evt);
            }
        });

        webCompsNotCalledTable.getAccessibleContext().setAccessibleParent(webCompsNotCalledPanel);

        org.jdesktop.layout.GroupLayout webCompsNotCalledPanelLayout = new org.jdesktop.layout.GroupLayout(webCompsNotCalledPanel);
        webCompsNotCalledPanel.setLayout(webCompsNotCalledPanelLayout);
        webCompsNotCalledPanelLayout.setHorizontalGroup(
            webCompsNotCalledPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, webCompsNotCalledTable, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 774, Short.MAX_VALUE)
        );
        webCompsNotCalledPanelLayout.setVerticalGroup(
            webCompsNotCalledPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(webCompsNotCalledPanelLayout.createSequentialGroup()
                .add(webCompsNotCalledTable, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 80, Short.MAX_VALUE)
                .addContainerGap())
        );

        webCompsSuccessfullyCalledPanel.setBackground(new java.awt.Color(255, 255, 255));
        webCompsSuccessfullyCalledPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("WebCompsSuccessfullyCalled"), javax.swing.border.TitledBorder.CENTER, javax.swing.border.TitledBorder.TOP, new java.awt.Font("Dialog", 1, 11)));
        webCompsSuccessfullyCalledTable.setModel(new WebCompsSuccessfullyCalledTable(webCompsSuccessfullyCalledTable));
        webCompsSuccessfullyCalledTable.getColumnModel().getColumn(0).setPreferredWidth(500);
        webCompsSuccessfullyCalledTable.setShowHorizontalLines(false);
        webCompsSuccessfullyCalledTable.setShowVerticalLines(false);
        webCompsSuccessfullyCalledTable.setTableHeader(webCompsSuccessfullyCalledTable.getTableHeader());
        webCompsSuccessfullyCalledTable.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                webCompsSuccessfullyCalledTableMouseClicked(evt);
            }
        });

        webCompsSuccessfullyCalledTable.getAccessibleContext().setAccessibleParent(webCompsSuccessfullyCalledPanel);

        org.jdesktop.layout.GroupLayout webCompsSuccessfullyCalledPanelLayout = new org.jdesktop.layout.GroupLayout(webCompsSuccessfullyCalledPanel);
        webCompsSuccessfullyCalledPanel.setLayout(webCompsSuccessfullyCalledPanelLayout);
        webCompsSuccessfullyCalledPanelLayout.setHorizontalGroup(
            webCompsSuccessfullyCalledPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(webCompsSuccessfullyCalledTable, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 774, Short.MAX_VALUE)
        );
        webCompsSuccessfullyCalledPanelLayout.setVerticalGroup(
            webCompsSuccessfullyCalledPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(webCompsSuccessfullyCalledTable, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 117, Short.MAX_VALUE)
        );

        org.jdesktop.layout.GroupLayout webCompsPanelLayout = new org.jdesktop.layout.GroupLayout(webCompsPanel);
        webCompsPanel.setLayout(webCompsPanelLayout);
        webCompsPanelLayout.setHorizontalGroup(
            webCompsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(webCompsUnSuccessfullyCalledPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .add(webCompsSuccessfullyCalledPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .add(webCompsNotCalledPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        webCompsPanelLayout.setVerticalGroup(
            webCompsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(webCompsPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(webCompsUnSuccessfullyCalledPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(17, 17, 17)
                .add(webCompsNotCalledPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(webCompsSuccessfullyCalledPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        jScrollPane2.setViewportView(webCompsPanel);

        compsTabbedPane.addTab("tab1", jScrollPane2);

        ejbCompsPanel.setBackground(new java.awt.Color(255, 255, 255));
        ejbMethodsUnSuccessfullyCalledPanel.setBackground(new java.awt.Color(255, 255, 255));
        ejbMethodsUnSuccessfullyCalledPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("EjbMethodsUnsuccessfullyCalled"), javax.swing.border.TitledBorder.CENTER, javax.swing.border.TitledBorder.TOP, new java.awt.Font("Dialog", 1, 11)));
        ejbMethodsUnSuccessfullyCalledTable.setModel(new EJBCompsUnSuccessfullyCalledTable(ejbMethodsUnSuccessfullyCalledTable));
        ejbMethodsUnSuccessfullyCalledTable.getColumnModel().getColumn(0).setPreferredWidth(500);
        ejbMethodsUnSuccessfullyCalledTable.setShowHorizontalLines(false);
        ejbMethodsUnSuccessfullyCalledTable.setShowVerticalLines(false);
        ejbMethodsUnSuccessfullyCalledTable.setTableHeader(ejbMethodsUnSuccessfullyCalledTable.getTableHeader());
        ejbMethodsUnSuccessfullyCalledTable.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ejbMethodsUnSuccessfullyCalledTableMouseClicked(evt);
            }
        });

        ejbMethodsUnSuccessfullyCalledTable.getAccessibleContext().setAccessibleParent(ejbMethodsUnSuccessfullyCalledPanel);

        org.jdesktop.layout.GroupLayout ejbMethodsUnSuccessfullyCalledPanelLayout = new org.jdesktop.layout.GroupLayout(ejbMethodsUnSuccessfullyCalledPanel);
        ejbMethodsUnSuccessfullyCalledPanel.setLayout(ejbMethodsUnSuccessfullyCalledPanelLayout);
        ejbMethodsUnSuccessfullyCalledPanelLayout.setHorizontalGroup(
            ejbMethodsUnSuccessfullyCalledPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(ejbMethodsUnSuccessfullyCalledTable, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 774, Short.MAX_VALUE)
        );
        ejbMethodsUnSuccessfullyCalledPanelLayout.setVerticalGroup(
            ejbMethodsUnSuccessfullyCalledPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(ejbMethodsUnSuccessfullyCalledTable, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 82, Short.MAX_VALUE)
        );

        ejbMethodsNotCalledPanel.setBackground(new java.awt.Color(255, 255, 255));
        ejbMethodsNotCalledPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("EjbMethodsNotCalled"), javax.swing.border.TitledBorder.CENTER, javax.swing.border.TitledBorder.TOP, new java.awt.Font("Dialog", 1, 11)));
        ejbMethodsNotCalledTable.setModel(new EJBCompsNotCalledTable(ejbMethodsNotCalledTable));
        ejbMethodsNotCalledTable.getColumnModel().getColumn(0).setPreferredWidth(500);
        ejbMethodsNotCalledTable.setShowHorizontalLines(false);
        ejbMethodsNotCalledTable.setShowVerticalLines(false);
        ejbMethodsNotCalledTable.setTableHeader(ejbMethodsNotCalledTable.getTableHeader());
        ejbMethodsNotCalledTable.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ejbMethodsNotCalledTableMouseClicked(evt);
            }
        });

        ejbMethodsNotCalledTable.getAccessibleContext().setAccessibleParent(ejbMethodsNotCalledPanel);

        org.jdesktop.layout.GroupLayout ejbMethodsNotCalledPanelLayout = new org.jdesktop.layout.GroupLayout(ejbMethodsNotCalledPanel);
        ejbMethodsNotCalledPanel.setLayout(ejbMethodsNotCalledPanelLayout);
        ejbMethodsNotCalledPanelLayout.setHorizontalGroup(
            ejbMethodsNotCalledPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(ejbMethodsNotCalledTable, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 774, Short.MAX_VALUE)
        );
        ejbMethodsNotCalledPanelLayout.setVerticalGroup(
            ejbMethodsNotCalledPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(ejbMethodsNotCalledPanelLayout.createSequentialGroup()
                .add(ejbMethodsNotCalledTable, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 67, Short.MAX_VALUE)
                .addContainerGap())
        );

        ejbMethodsSuccessfullyCalledPanel.setBackground(new java.awt.Color(255, 255, 255));
        ejbMethodsSuccessfullyCalledPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("EjbMethodsSuccessfullyCalled"), javax.swing.border.TitledBorder.CENTER, javax.swing.border.TitledBorder.TOP, new java.awt.Font("Dialog", 1, 11)));
        ejbMethodsSuccessfullyCalledTable.setModel(new EJBCompsSuccessfullyCalledTable(ejbMethodsSuccessfullyCalledTable));
        ejbMethodsSuccessfullyCalledTable.getColumnModel().getColumn(0).setPreferredWidth(500);
        ejbMethodsSuccessfullyCalledTable.setShowHorizontalLines(false);
        ejbMethodsSuccessfullyCalledTable.setShowVerticalLines(false);
        ejbMethodsSuccessfullyCalledTable.setTableHeader(ejbMethodsSuccessfullyCalledTable.getTableHeader());
        ejbMethodsSuccessfullyCalledTable.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ejbMethodsSuccessfullyCalledTableMouseClicked(evt);
            }
        });

        ejbMethodsSuccessfullyCalledTable.getAccessibleContext().setAccessibleParent(ejbMethodsSuccessfullyCalledPanel);

        org.jdesktop.layout.GroupLayout ejbMethodsSuccessfullyCalledPanelLayout = new org.jdesktop.layout.GroupLayout(ejbMethodsSuccessfullyCalledPanel);
        ejbMethodsSuccessfullyCalledPanel.setLayout(ejbMethodsSuccessfullyCalledPanelLayout);
        ejbMethodsSuccessfullyCalledPanelLayout.setHorizontalGroup(
            ejbMethodsSuccessfullyCalledPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(ejbMethodsSuccessfullyCalledTable, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 762, Short.MAX_VALUE)
        );
        ejbMethodsSuccessfullyCalledPanelLayout.setVerticalGroup(
            ejbMethodsSuccessfullyCalledPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(ejbMethodsSuccessfullyCalledTable, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 73, Short.MAX_VALUE)
        );

        org.jdesktop.layout.GroupLayout ejbCompsPanelLayout = new org.jdesktop.layout.GroupLayout(ejbCompsPanel);
        ejbCompsPanel.setLayout(ejbCompsPanelLayout);
        ejbCompsPanelLayout.setHorizontalGroup(
            ejbCompsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(ejbMethodsUnSuccessfullyCalledPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, ejbMethodsNotCalledPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .add(ejbCompsPanelLayout.createSequentialGroup()
                .add(ejbMethodsSuccessfullyCalledPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        ejbCompsPanelLayout.setVerticalGroup(
            ejbCompsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(ejbCompsPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(ejbMethodsUnSuccessfullyCalledPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(14, 14, 14)
                .add(ejbMethodsNotCalledPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(15, 15, 15)
                .add(ejbMethodsSuccessfullyCalledPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(46, Short.MAX_VALUE))
        );
        jScrollPane3.setViewportView(ejbCompsPanel);

        compsTabbedPane.addTab("tab2", jScrollPane3);

        org.openide.awt.Mnemonics.setLocalizedText(jButton1, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("ViewHTMLReportsButton"));
        jButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jButton1MouseClicked(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(summaryPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(compsTabbedPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 807, Short.MAX_VALUE)
                    .add(jButton1))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(summaryPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(14, 14, 14)
                .add(compsTabbedPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 391, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(29, 29, 29)
                .add(jButton1)
                .addContainerGap(24, Short.MAX_VALUE))
        );
        jScrollPane1.setViewportView(jPanel1);

        jTabbedPane1.addTab("tab1", jScrollPane1);

        jTabbedPane1.getAccessibleContext().setAccessibleName("AVK Report");
        jTabbedPane1.getAccessibleContext().setAccessibleDescription("AVK Report");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jTabbedPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 535, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jTabbedPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 464, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    
    private void jButton1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton1MouseClicked
// TODO add your handling code here:
        try {
            File report  = new File(avkReport.getResultsDir() + File.separator + "suiteSummary.html");
            URLDisplayer.getDefault().showURL(report.toURI().toURL());
        } catch(Exception ex) {
            ex.printStackTrace();
        }
    }//GEN-LAST:event_jButton1MouseClicked
    
    private void ejbMethodsSuccessfullyCalledTableMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_ejbMethodsSuccessfullyCalledTableMouseClicked
// TODO add your handling code here:
        EJBCompsSuccessfullyCalledTable tableModel = (EJBCompsSuccessfullyCalledTable)ejbMethodsSuccessfullyCalledTable.getModel();
        tableModel.handleMouseClicked(evt);
    }//GEN-LAST:event_ejbMethodsSuccessfullyCalledTableMouseClicked
    
    private void ejbMethodsNotCalledTableMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_ejbMethodsNotCalledTableMouseClicked
// TODO add your handling code here:
        EJBCompsNotCalledTable tableModel = (EJBCompsNotCalledTable)ejbMethodsNotCalledTable.getModel();
        tableModel.handleMouseClicked(evt);
    }//GEN-LAST:event_ejbMethodsNotCalledTableMouseClicked
    
    private void ejbMethodsUnSuccessfullyCalledTableMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_ejbMethodsUnSuccessfullyCalledTableMouseClicked
// TODO add your handling code here:
        EJBCompsUnSuccessfullyCalledTable tableModel = (EJBCompsUnSuccessfullyCalledTable)ejbMethodsUnSuccessfullyCalledTable.getModel();
        tableModel.handleMouseClicked(evt);
    }//GEN-LAST:event_ejbMethodsUnSuccessfullyCalledTableMouseClicked
    
    private void webCompsSuccessfullyCalledTableMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webCompsSuccessfullyCalledTableMouseClicked
// TODO add your handling code here:
        WebCompsSuccessfullyCalledTable tableModel = (WebCompsSuccessfullyCalledTable)webCompsSuccessfullyCalledTable.getModel();
        tableModel.handleMouseClicked(evt);
    }//GEN-LAST:event_webCompsSuccessfullyCalledTableMouseClicked
    
    private void webCompsNotCalledTableMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webCompsNotCalledTableMouseClicked
// TODO add your handling code here:
        WebCompsNotCalledTable tableModel = (WebCompsNotCalledTable)webCompsNotCalledTable.getModel();
        tableModel.handleMouseClicked(evt);
    }//GEN-LAST:event_webCompsNotCalledTableMouseClicked
    
    private void webCompsUnSuccessfullyCalledTableMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_webCompsUnSuccessfullyCalledTableMouseClicked
// TODO add your handling code here:
        WebCompsUnSuccessfullyCalledTable tableModel = (WebCompsUnSuccessfullyCalledTable) webCompsUnSuccessfullyCalledTable.getModel();
        tableModel.handleMouseClicked(evt);
    }//GEN-LAST:event_webCompsUnSuccessfullyCalledTableMouseClicked
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel appName;
    private javax.swing.JTabbedPane compsTabbedPane;
    private javax.swing.JLabel ejbCompPercentage;
    private javax.swing.JPanel ejbCompsPanel;
    private javax.swing.JPanel ejbMethodsNotCalledPanel;
    private javax.swing.JTable ejbMethodsNotCalledTable;
    private javax.swing.JPanel ejbMethodsSuccessfullyCalledPanel;
    private javax.swing.JTable ejbMethodsSuccessfullyCalledTable;
    private javax.swing.JPanel ejbMethodsUnSuccessfullyCalledPanel;
    private javax.swing.JTable ejbMethodsUnSuccessfullyCalledTable;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JPanel summaryPanel;
    private javax.swing.JLabel webCompPercentage;
    private javax.swing.JPanel webCompsNotCalledPanel;
    private javax.swing.JTable webCompsNotCalledTable;
    private javax.swing.JPanel webCompsPanel;
    private javax.swing.JPanel webCompsSuccessfullyCalledPanel;
    private javax.swing.JTable webCompsSuccessfullyCalledTable;
    private javax.swing.JPanel webCompsUnSuccessfullyCalledPanel;
    private javax.swing.JTable webCompsUnSuccessfullyCalledTable;
    // End of variables declaration//GEN-END:variables
    
    /**
     * Gets default instance. Do not use directly: reserved for *.settings files only,
     * i.e. deserialization routines; otherwise you could get a non-deserialized instance.
     * To obtain the singleton instance, use {@link findInstance}.
     */
    public static synchronized ReportTopComponent getDefault() {
        if (instance == null) {
            instance = new ReportTopComponent();
        }
        return instance;
    }
    
    /**
     * Obtain the ReportTopComponent instance. Never call {@link #getDefault} directly!
     */
    public static synchronized ReportTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(ErrorManager.WARNING, "Cannot find Report component. It will not be located properly in the window system.");
            return getDefault();
        }
        if (win instanceof ReportTopComponent) {
            return (ReportTopComponent)win;
        }
        ErrorManager.getDefault().log(ErrorManager.WARNING, "There seem to be multiple components with the '" + PREFERRED_ID + "' ID. That is a potential source of errors and unexpected behavior.");
        return getDefault();
    }
    
    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_ALWAYS;
    }
    
    public void componentOpened() {
        // TODO add custom code on component opening
    }
    
    public void componentClosed() {
        // TODO add custom code on component closing
    }
    
    /** replaces this in object stream */
    public Object writeReplace() {
        return new ResolvableHelper();
    }
    
    protected String preferredID() {
        return PREFERRED_ID;
    }
    
    final static class ResolvableHelper implements Serializable {
        private static final long serialVersionUID = 1L;
        public Object readResolve() {
            return ReportTopComponent.getDefault();
        }
    }
    
    
    /**
     * CUSTOM CODE - STARTS HERE.
     */
    private ReportModel avkReport;
    
    public void repaint() {
        /**
         * Set the visibility of the panels accordingly.
         */
        updateVisibility();
        
        try {
            jTabbedPane1.setTitleAt(0, "AVK Reports");
        } catch(Exception ex) {
            ex.printStackTrace();
        }
        super.repaint();
    }
    
    private void updateVisibility(JTabbedPane tabbedPane, int index, JScrollPane child, int... sizeOfChild) {
        tabbedPane.setTitleAt(0, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("WebCompsTabTitle"));
        tabbedPane.setTitleAt(1, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("EjbCompsTabTitle"));
        
        /*
        String titles[] = {"Web Components", "EJB Components"};
        int sizeOfChildren = 0;
        for(int i=0; i<sizeOfChild.length; i++) {
            sizeOfChildren += sizeOfChild[i];
        }
        System.out.println("Size of children = " + sizeOfChildren + ", index = " + index);
        if(sizeOfChildren == 0) {
            try {
                tabbedPane.remove(index);
            } catch(Exception ex) {
                ex.printStackTrace();
            }
        } else {
            try {
                tabbedPane.add(child, titles[index], index);
            } catch(Exception ex) {
                ex.printStackTrace();
            }
        }
         */
    }
    
    private void updateVisibility(JPanel panel, int... sizeOfChild) {
        int sizeOfChildren = 0;
        for(int i=0; i<sizeOfChild.length; i++) {
            sizeOfChildren += sizeOfChild[i];
        }
        boolean visible = sizeOfChildren == 0 ? false : true;
        panel.setVisible(visible);
    }
    
    private void updateVisibility() {
        
        int webCompsUnSuccessfullyCalled = webCompsUnSuccessfullyCalledTable.getRowCount();
        int webCompsSuccessfullyCalled = webCompsSuccessfullyCalledTable.getRowCount();
        int webCompsNotCalled = webCompsNotCalledTable.getRowCount();
        int ejbCompsUnSuccessfullyCalled = ejbMethodsUnSuccessfullyCalledTable.getRowCount();
        int ejbCompsSuccessfullyCalled = ejbMethodsSuccessfullyCalledTable.getRowCount();
        int ejbCompsNotCalled = ejbMethodsNotCalledTable.getRowCount();
        
        //updateVisibility(webCompsPanel, webCompsUnSuccessfullyCalled, webCompsSuccessfullyCalled, webCompsNotCalled);
        updateVisibility(webCompsUnSuccessfullyCalledPanel,webCompsUnSuccessfullyCalled);
        updateVisibility(webCompsSuccessfullyCalledPanel, webCompsSuccessfullyCalled);
        updateVisibility(webCompsNotCalledPanel, webCompsNotCalled);
        
        updateVisibility(compsTabbedPane, 0, jScrollPane2, webCompsUnSuccessfullyCalled, webCompsSuccessfullyCalled, webCompsNotCalled);
        updateVisibility(compsTabbedPane, 1, jScrollPane3, ejbCompsUnSuccessfullyCalled, ejbCompsSuccessfullyCalled, ejbCompsNotCalled);
        
        //updateVisibility(ejbCompsPanel, ejbCompsUnSuccessfullyCalled, ejbCompsSuccessfullyCalled, ejbCompsNotCalled);
        updateVisibility(ejbMethodsUnSuccessfullyCalledPanel, ejbCompsUnSuccessfullyCalled);
        updateVisibility(ejbMethodsSuccessfullyCalledPanel, ejbCompsSuccessfullyCalled);
        
        updateVisibility(ejbMethodsNotCalledPanel, ejbCompsNotCalled);
        
        /**
         * Update the table sizes.
         */
        updateSize(webCompsNotCalledTable, webCompsNotCalledPanel);
        updateSize(webCompsSuccessfullyCalledTable, webCompsSuccessfullyCalledPanel);
        updateSize(webCompsUnSuccessfullyCalledTable, webCompsUnSuccessfullyCalledPanel);
        
        updateSize(ejbMethodsNotCalledTable, ejbMethodsNotCalledPanel);
        updateSize(ejbMethodsSuccessfullyCalledTable, ejbMethodsSuccessfullyCalledPanel);
        updateSize(ejbMethodsUnSuccessfullyCalledTable, ejbMethodsUnSuccessfullyCalledPanel);
        
        /**
         * Update the summary panel.
         */
        appName.setText(getApplicationName());
        webCompPercentage.setText(getWebCompCoverage());
        ejbCompPercentage.setText(getEJBCompCoverage());
        
        //webCompsNotCalledTable.setBorder(BorderFactory.createEmptyBorder());
        
    }
    
    private void updateSize(javax.swing.JTable table, javax.swing.JPanel parent) {
        if(!table.isVisible() || !parent.isVisible()) return;
        double HEIGHT_PADDING = 25.0;
        
        javax.swing.table.JTableHeader header = table.getTableHeader();
        if (header != null) {
            
            // Make left aligned bold font for table header.
            DefaultTableCellRenderer headerRenderer = (DefaultTableCellRenderer)header.getDefaultRenderer();
            Font originalFont = headerRenderer.getFont();
            Font boldFont = new java.awt.Font(originalFont.getName(), Font.BOLD, originalFont.getSize());
            header.setFont(boldFont);
            headerRenderer.setHorizontalAlignment(SwingConstants.LEFT);
            
            // add the tableheader and table to the parent.
            parent.removeAll();
            parent.setLayout(new BorderLayout());
            parent.add(header, BorderLayout.NORTH);
            parent.add(table, BorderLayout.CENTER);
        }
        
        Dimension size = table.getSize();
        size.setSize(size.getWidth(), (table.getRowCount() * table.getRowHeight()) + HEIGHT_PADDING);
        table.setPreferredSize(size);
        size.setSize(size.getWidth(), size.getHeight() + HEIGHT_PADDING);
        parent.setPreferredSize(size);
    }
    
    class CommonTableModel extends DefaultTableModel {
        
        protected JTable table;
        
        public CommonTableModel(JTable table) {
            this.table = table;
        }
        
        public void handleMouseClicked(final MouseEvent evt) {
            if(evt.getButton() == MouseEvent.BUTTON3 && table.columnAtPoint(evt.getPoint()) == 0) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem popupShowSource = new JMenuItem();
                Font boldfont = popup.getFont().deriveFont(Font.BOLD);
                ActionListener menuListener = new ActionListener() {
                    public void actionPerformed(ActionEvent actionEvent) {
                        int row = table.rowAtPoint(evt.getPoint());
                        int col = table.columnAtPoint(evt.getPoint());
                        String methodSig = (String)getValueAt(row, col);
                        openSource(methodSig);
                    }
                };
                popupShowSource.setFont(boldfont);
                popupShowSource.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("GoToSource"));
                popupShowSource.addActionListener(menuListener);
                popup.add(popupShowSource);
                popup.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
        
        protected void clear(InputOutput io) {
            try {
                io.getOut().reset();
            } catch(Exception ex) {}
        }
        
        @Override public void setValueAt(Object aValue, int row, int column) {
            // do nothing.
        }
        
        /*
        protected void openSource(String className) {
            try {
                Type javaClass = JavaModel.getDefaultExtent().getType().resolve(className);
                FileObject fo = JavaModel.getFileObject(javaClass.getResource());
                DataObject d = DataObject.find(fo);
                OpenCookie oc = (OpenCookie)d.getCookie(OpenCookie.class);
                oc.open();
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
         */
        private String getClassName(String methodSignature) {
            String className = methodSignature;
            try {
                className = methodSignature.substring(0, methodSignature.lastIndexOf("("));
                className = className.substring(className.lastIndexOf(" "), className.lastIndexOf(".")).trim();
            } catch(Exception ex) {
                className = methodSignature; // return the default value in case of parsng failure.
            }
            return className;
        }
        
        private String getMethodName(String methodSignature) {
            String methodName = null;
            try {
                methodName = methodSignature.substring(0, methodSignature.lastIndexOf("("));
                methodName = methodName.substring(methodName.lastIndexOf(".")+1);
            } catch(Exception ex) {
                methodName = null; // return the default value in case of parsng failure.
            }
            return methodName;
        }
        
        private List getMethodParams(String methodSignature) {
            List methodParams = new ArrayList();
            try {
                String params = methodSignature.substring(methodSignature.lastIndexOf("(") + 1, methodSignature.lastIndexOf(")"));
                AdminTasks.debug("params = " + params);
                StringTokenizer st = new StringTokenizer(params, ",");
                while(st.hasMoreTokens()) {
                    String param = st.nextToken();
                    Type type = JavaModel.getDefaultExtent().getType().resolve(param);
                    methodParams.add(type);
                }
            } catch(Exception ex) {
                methodParams = new ArrayList(); // return the default value in case of parsng failure.
            }
            return methodParams;
        }
        
        protected void openSource(String methodSignature) {
            String className = getClassName(methodSignature);
            String methodName = getMethodName(methodSignature);
            List methodParams = getMethodParams(methodSignature);
            openSource(className, methodName, methodParams);
        }
        
        protected void openSource(String className, String methodName, List methodParams) {
            try {
                AdminTasks.debug("\n\nOpenSource : \nclassName = " + className + "\nmethodName = " + methodName + "\nmethodParams = " + methodParams);
                JavaClass javaClass = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(className);
                FileObject fo = JavaModel.getFileObject(javaClass.getResource());
                if(methodName != null) {
                    Resource resource = JavaModel.getResource(fo);
                    JavaMetamodel javaMetamodel = JavaMetamodel.getManager();
                    Method m = javaClass.getMethod(methodName,methodParams,true);
                    Element element = resource.getElementByOffset(m.getStartOffset());
                    PositionBounds position = javaMetamodel.getElementPosition(element);
                    ((JavaEditor) javaMetamodel.getDataObject(element.getResource()).getCookie(JavaEditor.class)).openAt(position.getBegin());
                } else {
                    DataObject dobj = DataObject.find(fo);
                    OpenCookie oc = (OpenCookie)dobj.getCookie(OpenCookie.class);
                    oc.open();
                }
            } catch (Throwable t) {
                StatusDisplayer.getDefault().setStatusText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("GoToSourceFailed") + className);
                t.printStackTrace();
            }
        }
    }
    
    class WebCompsSuccessfullyCalledTable extends CommonTableModel {
        
        List<WebComponent> webCompsSuccessfullyCalled;
        String[] columnNames;
        
        public WebCompsSuccessfullyCalledTable(JTable table) {
            super(table);
        }
        
        private void initTable() {
            webCompsSuccessfullyCalled = ReportModel.getInstance().getWebComponentsSuccessfullyCalled();
            columnNames = new String[] {
                java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("WebCompName"),
                java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("ContextRoot"),
                java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("Invocations")
            };
        }
        
        public int getColumnCount() {
            initTable();
            return columnNames.length;
        }
        
        public int getRowCount() {
            initTable();
            return webCompsSuccessfullyCalled.size();
        }
        
        public String getColumnName(int column) {
            return columnNames[column];
        }
        
        public Object getValueAt(int row, int column) {
            initTable();
            String value = null;
            if(column == 0) { // Method Name
                try {
                    value = webCompsSuccessfullyCalled.get(row).getWebEntity(0).getName();
                } catch(Exception ex) {
                    ex.printStackTrace();
                    value = null;
                }
            } else if(column == 1) { // Context Rooot
                try {
                    value = webCompsSuccessfullyCalled.get(row).getContext();
                } catch(Exception ex) {
                    ex.printStackTrace();
                    value = null;
                }
            } else if(column == 2) { // Invocations
                try {
                    value = webCompsSuccessfullyCalled.get(row).getWebEntity(0).getCounter();
                } catch(Exception ex) {
                    ex.printStackTrace();
                    value = null;
                }
            }
            return value;
        }
        
    }
    
    class WebCompsUnSuccessfullyCalledTable extends CommonTableModel {
        
        List<WebComponent> webCompsUnSuccessfullyCalled;
        String[] columnNames;
        
        public WebCompsUnSuccessfullyCalledTable(JTable table) {
            super(table);
        }
        
        private void initTable() {
            webCompsUnSuccessfullyCalled = ReportModel.getInstance().getWebComponentsUnSuccessfullyCalled();
            columnNames = new String[] {
                java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("WebCompName"),
                java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("ContextRoot"),
                java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("Exceptions")
            };
        }
        
        public int getColumnCount() {
            initTable();
            return columnNames.length;
        }
        
        public int getRowCount() {
            initTable();
            return webCompsUnSuccessfullyCalled.size();
        }
        
        public String getColumnName(int column) {
            return columnNames[column];
        }
        
        public Object getValueAt(int row, int column) {
            initTable();
            String value = null;
            if(column == 0) { // Method Name
                try {
                    value = webCompsUnSuccessfullyCalled.get(row).getWebEntity(0).getName();
                } catch(Exception ex) {
                    ex.printStackTrace();
                    value = null;
                }
            } else if(column == 1) { // Context Rooot
                try {
                    value = webCompsUnSuccessfullyCalled.get(row).getContext();
                } catch(Exception ex) {
                    ex.printStackTrace();
                    value = null;
                }
            } else if(column == 2) { // Exceptions
                try {
                    value = webCompsUnSuccessfullyCalled.get(row).getWebEntity(0).getAppVerificationException(0).getExceptionName();
                } catch(Exception ex) {
                    ex.printStackTrace();
                    value = null;
                }
            }
            return value;
        }
        
        public void handleMouseClicked(final MouseEvent evt) {
            if(evt.getButton() == MouseEvent.BUTTON3 && table.columnAtPoint(evt.getPoint()) == 2) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem popupShowSource = new JMenuItem();
                Font boldfont = popup.getFont().deriveFont(Font.BOLD);
                ActionListener menuListener = new ActionListener() {
                    public void actionPerformed(ActionEvent actionEvent) {
                        int row = table.rowAtPoint(evt.getPoint());
                        int col = table.columnAtPoint(evt.getPoint());
                        String exceptionTrace = webCompsUnSuccessfullyCalled.get(row).getWebEntity(0).getAppVerificationException(0).getExceptionTrace();
                        String exceptionName = (String)getValueAt(row, col);
                        InputOutput io = IOProvider.getDefault().getIO(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("ExceptionPrefix") + exceptionName, false);
                        clear(io);
                        io.getOut().write(exceptionTrace);
                        io.getOut().flush();
                        io.select();
                    }
                };
                popupShowSource.setFont(boldfont);
                popupShowSource.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("ShowException"));
                popupShowSource.addActionListener(menuListener);
                popup.add(popupShowSource);
                popup.show(evt.getComponent(), evt.getX(), evt.getY());
            } else {
                super.handleMouseClicked(evt);
            }
        }
        
    }
    
    class WebCompsNotCalledTable extends CommonTableModel {
        
        List<WebComponent> webCompsNotCalled;
        String[] columnNames;
        
        public WebCompsNotCalledTable(JTable table) {
            super(table);
        }
        
        private void initTable() {
            webCompsNotCalled = ReportModel.getInstance().getWebComponentsNotCalled();
            columnNames = new String[] {
                java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("WebCompName"),
                java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("ContextRoot")
            };
        }
        
        public int getColumnCount() {
            initTable();
            return columnNames.length;
        }
        
        public int getRowCount() {
            initTable();
            return webCompsNotCalled.size();
        }
        
        public String getColumnName(int column) {
            return columnNames[column];
        }
        
        public Object getValueAt(int row, int column) {
            initTable();
            String value = null;
            if(column == 0) { // Method Name
                try {
                    value = webCompsNotCalled.get(row).getWebEntity(0).getName();
                } catch(Exception ex) {
                    ex.printStackTrace();
                    value = null;
                }
            } else if(column == 1) { // Context Rooot
                try {
                    value = webCompsNotCalled.get(row).getContext();
                } catch(Exception ex) {
                    ex.printStackTrace();
                    value = null;
                }
            }
            return value;
        }
        
    }
    
    class EJBCompsSuccessfullyCalledTable extends CommonTableModel {
        
        List<EnterpriseBean> ejbCompsSuccessfullyCalled;
        String[] columnNames;
        
        public EJBCompsSuccessfullyCalledTable(JTable table) {
            super(table);
        }
        
        private void initTable() {
            ejbCompsSuccessfullyCalled = ReportModel.getInstance().getEJBComponentsSuccessfullyCalled();
            columnNames = new String[] {
                java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("MethodName"),
                java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("BeanName"),
                java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("Invocations")
            };
        }
        
        public int getColumnCount() {
            initTable();
            return columnNames.length;
        }
        
        public int getRowCount() {
            initTable();
            return ejbCompsSuccessfullyCalled.size();
        }
        
        public String getColumnName(int column) {
            return columnNames[column];
        }
        
        public Object getValueAt(int row, int column) {
            initTable();
            String value = null;
            if(column == 0) { // Method Name
                try {
                    value = ejbCompsSuccessfullyCalled.get(row).getMethod(0).getMethodSignature();
                } catch(Exception ex) {
                    ex.printStackTrace();
                    value = null;
                }
            } else if(column == 1) { // Bean Name
                try {
                    value = ejbCompsSuccessfullyCalled.get(0).getBeanName();
                } catch(Exception ex) {
                    ex.printStackTrace();
                    value = null;
                }
            } else if(column == 2) { // Invocations
                try {
                    value = ejbCompsSuccessfullyCalled.get(row).getMethod(0).getCounter();
                } catch(Exception ex) {
                    ex.printStackTrace();
                    value = null;
                }
            }
            return value;
        }
        
    }
    
    class EJBCompsUnSuccessfullyCalledTable extends CommonTableModel {
        
        List<EnterpriseBean> ejbCompsUnSuccessfullyCalled;
        String[] columnNames;
        
        public EJBCompsUnSuccessfullyCalledTable(JTable table) {
            super(table);
        }
        
        private void initTable() {
            ejbCompsUnSuccessfullyCalled = ReportModel.getInstance().getEJBComponentsUnSuccessfullyCalled();
            columnNames = new String[] {
                java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("MethodName"),
                java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("BeanName"),
                java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("Exceptions")
            };
        }
        
        public int getColumnCount() {
            initTable();
            return columnNames.length;
        }
        
        public int getRowCount() {
            initTable();
            return ejbCompsUnSuccessfullyCalled.size();
        }
        
        public String getColumnName(int column) {
            return columnNames[column];
        }
        
        public Object getValueAt(int row, int column) {
            initTable();
            String value = null;
            if(column == 0) { // Method Name
                try {
                    value = ejbCompsUnSuccessfullyCalled.get(row).getMethod(0).getMethodSignature();
                } catch(Exception ex) {
                    ex.printStackTrace();
                    value = null;
                }
            } else if(column == 1) { // Bean Name
                try {
                    value = ejbCompsUnSuccessfullyCalled.get(0).getBeanName();
                } catch(Exception ex) {
                    ex.printStackTrace();
                    value = null;
                }
            } else if(column == 2) { // Exceptions
                try {
                    value = ejbCompsUnSuccessfullyCalled.get(row).getMethod(0).getAppVerificationException(0).getExceptionName();
                } catch(Exception ex) {
                    ex.printStackTrace();
                    value = null;
                }
            }
            return value;
        }
        
        public void handleMouseClicked(final MouseEvent evt) {
            if(evt.getButton() == MouseEvent.BUTTON3 && table.columnAtPoint(evt.getPoint()) == 2) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem popupShowSource = new JMenuItem();
                Font boldfont = popup.getFont().deriveFont(Font.BOLD);
                ActionListener menuListener = new ActionListener() {
                    public void actionPerformed(ActionEvent actionEvent) {
                        int row = table.rowAtPoint(evt.getPoint());
                        int col = table.columnAtPoint(evt.getPoint());
                        String exceptionTrace = ejbCompsUnSuccessfullyCalled.get(row).getMethod(0).getAppVerificationException(0).getExceptionTrace();
                        String exceptionName = (String)getValueAt(row, col);
                        InputOutput io = IOProvider.getDefault().getIO(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("ExceptionPrefix") + exceptionName, false);
                        clear(io);
                        io.getOut().write(exceptionTrace);
                        io.getOut().flush();
                        io.select();
                    }
                };
                popupShowSource.setFont(boldfont);
                popupShowSource.setText("Show Exception");
                popupShowSource.addActionListener(menuListener);
                popup.add(popupShowSource);
                popup.show(evt.getComponent(), evt.getX(), evt.getY());
            } else {
                super.handleMouseClicked(evt);
            }
        }
        
    }
    
    class EJBCompsNotCalledTable extends CommonTableModel {
        
        List<EnterpriseBean> ejbCompsNotCalled;
        String[] columnNames;
        
        public EJBCompsNotCalledTable(JTable table) {
            super(table);
        }
        
        private void initTable() {
            ejbCompsNotCalled = ReportModel.getInstance().getEJBComponentsNotCalled();
            columnNames = new String[] {
                java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("MethodName"),
                java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/avk/report/view/Bundle").getString("BeanName")
            };
        }
        
        public int getColumnCount() {
            initTable();
            return columnNames.length;
        }
        
        public int getRowCount() {
            initTable();
            return ejbCompsNotCalled.size();
        }
        
        public String getColumnName(int column) {
            return columnNames[column];
        }
        
        public Object getValueAt(int row, int column) {
            initTable();
            String value = null;
            if(column == 0) { // Method Name
                try {
                    value = ejbCompsNotCalled.get(row).getMethod(0).getMethodSignature();
                } catch(Exception ex) {
                    ex.printStackTrace();
                    value = null;
                }
            } else if(column == 1) { // Bean Name
                try {
                    value = ejbCompsNotCalled.get(0).getBeanName();
                } catch(Exception ex) {
                    ex.printStackTrace();
                    value = null;
                }
            }
            return value;
        }
        
    }
    
    public String getApplicationName() {
        avkReport = ReportModel.getInstance();
        return avkReport.getApplicationName();
    }
    
    public String getWebCompCoverage() {
        avkReport = ReportModel.getInstance();
        return avkReport.getWebCompCoverage();
    }
    
    public String getEJBCompCoverage() {
        avkReport = ReportModel.getInstance();
        return avkReport.getEJBCompCoverage();
    }
    
    /**
     * CUSTOM CODE - ENDS HERE.
     */
    
}
