/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
/*
 * IorSecurityConfigPanel.java        October 20, 2003, 2:34 PM
 *
 */

package org.netbeans.modules.j2ee.sun.share.configbean.customizers.ejbmodule;

import java.util.ResourceBundle;
import javax.swing.JPanel;

import org.netbeans.modules.j2ee.sun.dd.api.ejb.AsContext;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.IorSecurityConfig;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.SasContext;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.TransportConfig;
import org.netbeans.modules.j2ee.sun.share.configbean.BaseEjb;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.ValidationError;


/**
 *
 * @author  Rajeshwar Patil
 * @version %I%, %G%
 */
public class IorSecurityConfigPanel extends JPanel {

    private EjbCustomizer masterPanel;
    
    private final ResourceBundle bundle = ResourceBundle.getBundle(
            "org.netbeans.modules.j2ee.sun.share.configbean.customizers.ejbmodule.Bundle"); // NOI18N

    
    /** Creates new form IorSecurityConfigPanel */
    public IorSecurityConfigPanel(EjbCustomizer src) {
        this.masterPanel = src;

        initComponents();
        initUserComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        transportConfigLabel = new javax.swing.JLabel();
        transportConfigPanel = new javax.swing.JPanel();
        transportConfigPanelPanel1 = new javax.swing.JPanel();
        integrityLabel = new javax.swing.JLabel();
        integrityComboBox = new javax.swing.JComboBox();
        confidentialityLabel = new javax.swing.JLabel();
        confidentialityComboBox = new javax.swing.JComboBox();
        transportConfigPanel2 = new javax.swing.JPanel();
        estbTrstInTrgtLabel = new javax.swing.JLabel();
        estbTrstInTrgtComboBox = new javax.swing.JComboBox();
        estbTrstInClntLabel = new javax.swing.JLabel();
        estbTrstInClntComboBox = new javax.swing.JComboBox();
        asContextLabel = new javax.swing.JLabel();
        asContextPanel = new javax.swing.JPanel();
        requiredLabel = new javax.swing.JLabel();
        requiredComboBox = new javax.swing.JComboBox();
        authMethodLabel = new javax.swing.JLabel();
        authMethodComboBox = new javax.swing.JComboBox();
        realmLabel = new javax.swing.JLabel();
        realmTextField = new javax.swing.JTextField();
        sasContextLabel = new javax.swing.JLabel();
        sasContextPanel = new javax.swing.JPanel();
        callerPropagationLabel = new javax.swing.JLabel();
        callerPropagationComboBox = new javax.swing.JComboBox();
        fillerPanel = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        transportConfigLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_Transport_Config"));
        transportConfigLabel.setToolTipText("");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 5);
        add(transportConfigLabel, gridBagConstraints);

        transportConfigPanel.setLayout(new java.awt.GridBagLayout());

        transportConfigPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        transportConfigPanelPanel1.setLayout(new java.awt.GridBagLayout());

        transportConfigPanelPanel1.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        integrityLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("MNC_Integrity").charAt(0));
        integrityLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_Integrity_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        transportConfigPanelPanel1.add(integrityLabel, gridBagConstraints);
        integrityLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Integrity_Acsbl_Name"));
        integrityLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Integrity_Acsbl_Desc"));

        integrityComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "", "NONE", "SUPPORTED", "REQUIRED" }));
        integrityComboBox.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Integrity_Tool_Tip"));
        integrityComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                integrityComboBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        transportConfigPanelPanel1.add(integrityComboBox, gridBagConstraints);
        integrityComboBox.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Integrity_Acsbl_Name"));
        integrityComboBox.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Integrity_Acsbl_Desc"));

        confidentialityLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("MNC_Confidentiality").charAt(0));
        confidentialityLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_Confidentiality_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        transportConfigPanelPanel1.add(confidentialityLabel, gridBagConstraints);
        confidentialityLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Confidentiality_Acsbl_Name"));
        confidentialityLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Confidentiality_Acsbl_Desc"));

        confidentialityComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "", "NONE", "SUPPORTED", "REQUIRED" }));
        confidentialityComboBox.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Confidentiality_Tool_Tip"));
        confidentialityComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                confidentialityComboBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        transportConfigPanelPanel1.add(confidentialityComboBox, gridBagConstraints);
        confidentialityComboBox.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Confidentiality_Acsbl_Name"));
        confidentialityComboBox.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Confidentiality_Acsbl_Desc"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 0);
        transportConfigPanel.add(transportConfigPanelPanel1, gridBagConstraints);

        transportConfigPanel2.setLayout(new java.awt.GridBagLayout());

        transportConfigPanel2.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        estbTrstInTrgtLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("MNC_Establish_Trust_In_Target").charAt(0));
        estbTrstInTrgtLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_Establish_Trust_In_Target_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        transportConfigPanel2.add(estbTrstInTrgtLabel, gridBagConstraints);
        estbTrstInTrgtLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Establish_Trust_In_Target_Acsbl_Name"));
        estbTrstInTrgtLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Establish_Trust_In_Target_Acsbl_Desc"));

        estbTrstInTrgtComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "", "NONE", "SUPPORTED" }));
        estbTrstInTrgtComboBox.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Establish_Trust_In_Target_Tool_Tip"));
        estbTrstInTrgtComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                estbTrstInTrgtComboBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        transportConfigPanel2.add(estbTrstInTrgtComboBox, gridBagConstraints);
        estbTrstInTrgtComboBox.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Establish_Trust_In_Target_Acsbl_Name"));
        estbTrstInTrgtComboBox.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Establish_Trust_In_Target_Acsbl_Desc"));

        estbTrstInClntLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("MNC_Establish_Trust_In_Client").charAt(0));
        estbTrstInClntLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_Establish_Trust_In_Client_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        transportConfigPanel2.add(estbTrstInClntLabel, gridBagConstraints);
        estbTrstInClntLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Establish_Trust_In_Client_Acsbl_Name"));
        estbTrstInClntLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Establish_Trust_In_Client_Acsbl_Desc"));

        estbTrstInClntComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "", "NONE", "SUPPORTED", "REQUIRED" }));
        estbTrstInClntComboBox.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Establish_Trust_In_Client_Tool_Tip"));
        estbTrstInClntComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                estbTrstInClntComboBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        transportConfigPanel2.add(estbTrstInClntComboBox, gridBagConstraints);
        estbTrstInClntComboBox.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Establish_Trust_In_Client_Acsbl_Name"));
        estbTrstInClntComboBox.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Establish_Trust_In_Client_Acsbl_Desc"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 5);
        transportConfigPanel.add(transportConfigPanel2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 5);
        add(transportConfigPanel, gridBagConstraints);

        asContextLabel.setLabelFor(asContextPanel);
        asContextLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_As_Context"));
        asContextLabel.setToolTipText("");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 5);
        add(asContextLabel, gridBagConstraints);

        asContextPanel.setLayout(new java.awt.GridBagLayout());

        asContextPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        requiredLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("MNC_Required").charAt(0));
        requiredLabel.setLabelFor(requiredComboBox);
        requiredLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_Required_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        asContextPanel.add(requiredLabel, gridBagConstraints);
        requiredLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Required_Acsbl_Name"));
        requiredLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Required_Acsbl_Desc"));

        requiredComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "", "true", "false" }));
        requiredComboBox.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Required_Tool_Tip"));
        requiredComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                requiredComboBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        asContextPanel.add(requiredComboBox, gridBagConstraints);
        requiredComboBox.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Required_Acsbl_Name"));
        requiredComboBox.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Required_Acsbl_Desc"));

        authMethodLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("MNC_Auth_Method").charAt(0));
        authMethodLabel.setLabelFor(authMethodComboBox);
        authMethodLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_Auth_Method_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        asContextPanel.add(authMethodLabel, gridBagConstraints);
        authMethodLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Auth_Method_Acsbl_Name"));
        authMethodLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Auth_Method_Acsbl_Desc"));

        authMethodComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "", "USERNAME_PASSWORD" }));
        authMethodComboBox.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Auth_Method_Tool_Tip"));
        authMethodComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                authMethodComboBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 5);
        asContextPanel.add(authMethodComboBox, gridBagConstraints);
        authMethodComboBox.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Auth_Method_Acsbl_Name"));
        authMethodComboBox.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Auth_Method_Acsbl_Desc"));

        realmLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("MNC_Auth_Method").charAt(0));
        realmLabel.setLabelFor(realmTextField);
        realmLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_Realm_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 0);
        asContextPanel.add(realmLabel, gridBagConstraints);
        realmLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Realm_Acsbl_Name"));
        realmLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Realm_Acsbl_Desc"));

        realmTextField.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Realm_Tool_Tip"));
        realmTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                realmTextFieldKeyReleased(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 56;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 5);
        asContextPanel.add(realmTextField, gridBagConstraints);
        realmTextField.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Realm_Acsbl_Name"));
        realmTextField.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Realm_Acsbl_Desc"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 5);
        add(asContextPanel, gridBagConstraints);

        sasContextLabel.setLabelFor(sasContextPanel);
        sasContextLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_Sas_Context"));
        sasContextLabel.setToolTipText("");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 5);
        add(sasContextLabel, gridBagConstraints);

        sasContextPanel.setLayout(new java.awt.GridBagLayout());

        sasContextPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        callerPropagationLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("MNC_Caller_Propagation").charAt(0));
        callerPropagationLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        callerPropagationLabel.setLabelFor(callerPropagationComboBox);
        callerPropagationLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_Caller_Propagation_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 0);
        sasContextPanel.add(callerPropagationLabel, gridBagConstraints);
        callerPropagationLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Caller_Propagation_Acsbl_Name"));
        callerPropagationLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Caller_Propagation_Acsbl_Desc"));

        callerPropagationComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "", "NONE", "SUPPORTED" }));
        callerPropagationComboBox.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Caller_Propagation_Tool_Tip"));
        callerPropagationComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                callerPropagationComboBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 5);
        sasContextPanel.add(callerPropagationComboBox, gridBagConstraints);
        callerPropagationComboBox.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Caller_Propagation_Acsbl_Name"));
        callerPropagationComboBox.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Caller_Propagation_Acsbl_Desc"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 5, 5);
        add(sasContextPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(fillerPanel, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

    private void realmTextFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_realmTextFieldKeyReleased
        BaseEjb theBean = masterPanel.getBean();
        if(theBean != null) {
            IorSecurityConfig iorSecurityConfig = theBean.getIorSecurityConfig();
            AsContext asContext = iorSecurityConfig.getAsContext();
            String newRealm = (String) realmTextField.getText();
            String oldRealm = (asContext != null) ? asContext.getRealm() : null;
            
            if(!Utils.strEquals(oldRealm, newRealm)) {
                if(Utils.notEmpty(newRealm)) {
                    if(asContext == null) {
                        asContext = iorSecurityConfig.newAsContext();
                        iorSecurityConfig.setAsContext(asContext);
                    }
                    asContext.setRealm(newRealm);
                } else if(asContext != null) {
                    if(Utils.notEmpty(asContext.getRequired()) || Utils.notEmpty(asContext.getAuthMethod())) {
                        asContext.setRealm(null);
                    } else {
                        iorSecurityConfig.setAsContext(null);
                    }
                }

                theBean.firePropertyChange("iorAsContextRealm", oldRealm, newRealm); // NOI18N
                masterPanel.validateField(BaseEjb.FIELD_IOR_ASCONTEXT);
            }
        } 
    }//GEN-LAST:event_realmTextFieldKeyReleased

    private void callerPropagationComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_callerPropagationComboBoxActionPerformed
        BaseEjb theBean = masterPanel.getBean();
        if(theBean != null) {
            IorSecurityConfig iorSecurityConfig = theBean.getIorSecurityConfig();
            SasContext sasContext = iorSecurityConfig.getSasContext();
            String newCallerProp = (String) callerPropagationComboBox.getSelectedItem();
            String oldCallerProp = (sasContext != null) ? sasContext.getCallerPropagation() : null;
            
            if(!Utils.strEquals(oldCallerProp, newCallerProp)) {
                if(Utils.notEmpty(newCallerProp)) {
                    if(sasContext == null) {
                        sasContext = iorSecurityConfig.newSasContext();
                        iorSecurityConfig.setSasContext(sasContext);
                    }
                    sasContext.setCallerPropagation(newCallerProp);
                } else if(sasContext != null) {
                    iorSecurityConfig.setSasContext(null);
                }

                theBean.firePropertyChange("iorSasCallerProp", oldCallerProp, newCallerProp); // NOI18N
                masterPanel.validateField(BaseEjb.FIELD_IOR_SAS);
            }
        }
    }//GEN-LAST:event_callerPropagationComboBoxActionPerformed

    private void authMethodComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_authMethodComboBoxActionPerformed
        BaseEjb theBean = masterPanel.getBean();
        if(theBean != null) {
            IorSecurityConfig iorSecurityConfig = theBean.getIorSecurityConfig();
            AsContext asContext = iorSecurityConfig.getAsContext();
            String newAuthMethod = (String) authMethodComboBox.getSelectedItem();
            String oldAuthMethod = (asContext != null) ? asContext.getAuthMethod() : null;
            
            if(!Utils.strEquals(oldAuthMethod, newAuthMethod)) {
                if(Utils.notEmpty(newAuthMethod)) {
                    if(asContext == null) {
                        asContext = iorSecurityConfig.newAsContext();
                        iorSecurityConfig.setAsContext(asContext);
                    }
                    asContext.setAuthMethod(newAuthMethod);
                } else if(asContext != null) {
                    if(Utils.notEmpty(asContext.getRealm()) || Utils.notEmpty(asContext.getRequired())) {
                        asContext.setAuthMethod(null);
                    } else {
                        iorSecurityConfig.setAsContext(null);
                    }
                }

                theBean.firePropertyChange("iorAsContextAuthMethod", oldAuthMethod, newAuthMethod); // NOI18N
                masterPanel.validateField(BaseEjb.FIELD_IOR_ASCONTEXT);
            }
        } 
    }//GEN-LAST:event_authMethodComboBoxActionPerformed

    private void requiredComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_requiredComboBoxActionPerformed
        BaseEjb theBean = masterPanel.getBean();
        if(theBean != null) {
            IorSecurityConfig iorSecurityConfig = theBean.getIorSecurityConfig();
            AsContext asContext = iorSecurityConfig.getAsContext();
            String newRequired = (String) requiredComboBox.getSelectedItem();
            String oldRequired = (asContext != null) ? asContext.getRequired() : null;
            
            if(!Utils.strEquals(oldRequired, newRequired)) {
                if(Utils.notEmpty(newRequired)) {
                    if(asContext == null) {
                        asContext = iorSecurityConfig.newAsContext();
                        iorSecurityConfig.setAsContext(asContext);
                    }
                    asContext.setRequired(newRequired);
                } else if(asContext != null) {
                    if(Utils.notEmpty(asContext.getRealm()) || Utils.notEmpty(asContext.getAuthMethod())) {
                        asContext.setRequired(null);
                    } else {
                        iorSecurityConfig.setAsContext(null);
                    }
                }

                theBean.firePropertyChange("iorAsContextRequired", oldRequired, newRequired); // NOI18N
                masterPanel.validateField(BaseEjb.FIELD_IOR_ASCONTEXT);
            }
        } 
    }//GEN-LAST:event_requiredComboBoxActionPerformed

    private void estbTrstInClntComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_estbTrstInClntComboBoxActionPerformed
        BaseEjb theBean = masterPanel.getBean();
        if(theBean != null) {
            IorSecurityConfig iorSecurityConfig = theBean.getIorSecurityConfig();
            TransportConfig transportConfig = iorSecurityConfig.getTransportConfig();
            String newClientTrust = (String) estbTrstInClntComboBox.getSelectedItem();
            String oldClientTrust = (transportConfig != null) ? transportConfig.getEstablishTrustInClient() : null;
            
            if(!Utils.strEquals(oldClientTrust, newClientTrust)) {
                if(Utils.notEmpty(newClientTrust)) {
                    if(transportConfig == null) {
                        transportConfig = iorSecurityConfig.newTransportConfig();
                        iorSecurityConfig.setTransportConfig(transportConfig);
                    }
                    transportConfig.setEstablishTrustInClient(newClientTrust);
                } else if(transportConfig != null) {
                    if(Utils.notEmpty(transportConfig.getConfidentiality()) || 
                            Utils.notEmpty(transportConfig.getIntegrity()) ||
                            Utils.notEmpty(transportConfig.getEstablishTrustInTarget())
                            ) {
                        transportConfig.setEstablishTrustInClient(null);
                    } else {
                        iorSecurityConfig.setTransportConfig(null);
                    }
                }

                theBean.firePropertyChange("iorTransportEstTrustClient", oldClientTrust, newClientTrust); // NOI18N
                masterPanel.validateField(BaseEjb.FIELD_IOR_TRANSPORT);
            }
        }       
    }//GEN-LAST:event_estbTrstInClntComboBoxActionPerformed

    private void estbTrstInTrgtComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_estbTrstInTrgtComboBoxActionPerformed
        BaseEjb theBean = masterPanel.getBean();
        if(theBean != null) {
            IorSecurityConfig iorSecurityConfig = theBean.getIorSecurityConfig();
            TransportConfig transportConfig = iorSecurityConfig.getTransportConfig();
            String newTargetTrust = (String) estbTrstInTrgtComboBox.getSelectedItem();
            String oldTargetTrust = (transportConfig != null) ? transportConfig.getEstablishTrustInTarget() : null;
            
            if(!Utils.strEquals(oldTargetTrust, newTargetTrust)) {
                if(Utils.notEmpty(newTargetTrust)) {
                    if(transportConfig == null) {
                        transportConfig = iorSecurityConfig.newTransportConfig();
                        iorSecurityConfig.setTransportConfig(transportConfig);
                    }
                    transportConfig.setEstablishTrustInTarget(newTargetTrust);
                } else if(transportConfig != null) {
                    if(Utils.notEmpty(transportConfig.getConfidentiality()) || 
                            Utils.notEmpty(transportConfig.getIntegrity()) ||
                            Utils.notEmpty(transportConfig.getEstablishTrustInClient())
                            ) {
                        transportConfig.setEstablishTrustInTarget(null);
                    } else {
                        iorSecurityConfig.setTransportConfig(null);
                    }
                }

                theBean.firePropertyChange("iorTransportEstTrustTarget", oldTargetTrust, newTargetTrust); // NOI18N
                masterPanel.validateField(BaseEjb.FIELD_IOR_TRANSPORT);
            }
        }   
    }//GEN-LAST:event_estbTrstInTrgtComboBoxActionPerformed

    private void confidentialityComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_confidentialityComboBoxActionPerformed
        BaseEjb theBean = masterPanel.getBean();
        if(theBean != null) {
            IorSecurityConfig iorSecurityConfig = theBean.getIorSecurityConfig();
            TransportConfig transportConfig = iorSecurityConfig.getTransportConfig();
            String newConfidentiality = (String) confidentialityComboBox.getSelectedItem();
            String oldConfidentiality = (transportConfig != null) ? transportConfig.getConfidentiality() : null;
            
            if(!Utils.strEquals(oldConfidentiality, newConfidentiality)) {
                if(Utils.notEmpty(newConfidentiality)) {
                    if(transportConfig == null) {
                        transportConfig = iorSecurityConfig.newTransportConfig();
                        iorSecurityConfig.setTransportConfig(transportConfig);
                    }
                    transportConfig.setConfidentiality(newConfidentiality);
                } else if(transportConfig != null) {
                    if(Utils.notEmpty(transportConfig.getIntegrity()) ||
                            Utils.notEmpty(transportConfig.getEstablishTrustInClient()) ||
                            Utils.notEmpty(transportConfig.getEstablishTrustInTarget())
                            ) {
                        transportConfig.setConfidentiality(null);
                    } else {
                        iorSecurityConfig.setTransportConfig(null);
                    }
                }

                theBean.firePropertyChange("iorTransportConfidendiality", oldConfidentiality, newConfidentiality); // NOI18N
                masterPanel.validateField(BaseEjb.FIELD_IOR_TRANSPORT);
            }
        } 
    }//GEN-LAST:event_confidentialityComboBoxActionPerformed

    private void integrityComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_integrityComboBoxActionPerformed
        BaseEjb theBean = masterPanel.getBean();
        if(theBean != null) {
            IorSecurityConfig iorSecurityConfig = theBean.getIorSecurityConfig();
            TransportConfig transportConfig = iorSecurityConfig.getTransportConfig();
            String newIntegrity = (String) integrityComboBox.getSelectedItem();
            String oldIntegrity = (transportConfig != null) ? transportConfig.getIntegrity() : null;
            
            if(!Utils.strEquals(oldIntegrity, newIntegrity)) {
                if(Utils.notEmpty(newIntegrity)) {
                    if(transportConfig == null) {
                        transportConfig = iorSecurityConfig.newTransportConfig();
                        iorSecurityConfig.setTransportConfig(transportConfig);
                    }
                    transportConfig.setIntegrity(newIntegrity);
                } else if(transportConfig != null) {
                    if(Utils.notEmpty(transportConfig.getConfidentiality()) || 
                            Utils.notEmpty(transportConfig.getEstablishTrustInClient()) ||
                            Utils.notEmpty(transportConfig.getEstablishTrustInTarget())
                            ) {
                        transportConfig.setIntegrity(null);
                    } else {
                        iorSecurityConfig.setTransportConfig(null);
                    }
                }

                theBean.firePropertyChange("iorTransportIntegrity", oldIntegrity, newIntegrity); // NOI18N
                masterPanel.validateField(BaseEjb.FIELD_IOR_TRANSPORT);
            }
        } 
    }//GEN-LAST:event_integrityComboBoxActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel asContextLabel;
    private javax.swing.JPanel asContextPanel;
    private javax.swing.JComboBox authMethodComboBox;
    private javax.swing.JLabel authMethodLabel;
    private javax.swing.JComboBox callerPropagationComboBox;
    private javax.swing.JLabel callerPropagationLabel;
    private javax.swing.JComboBox confidentialityComboBox;
    private javax.swing.JLabel confidentialityLabel;
    private javax.swing.JComboBox estbTrstInClntComboBox;
    private javax.swing.JLabel estbTrstInClntLabel;
    private javax.swing.JComboBox estbTrstInTrgtComboBox;
    private javax.swing.JLabel estbTrstInTrgtLabel;
    private javax.swing.JPanel fillerPanel;
    private javax.swing.JComboBox integrityComboBox;
    private javax.swing.JLabel integrityLabel;
    private javax.swing.JLabel realmLabel;
    private javax.swing.JTextField realmTextField;
    private javax.swing.JComboBox requiredComboBox;
    private javax.swing.JLabel requiredLabel;
    private javax.swing.JLabel sasContextLabel;
    private javax.swing.JPanel sasContextPanel;
    private javax.swing.JLabel transportConfigLabel;
    private javax.swing.JPanel transportConfigPanel;
    private javax.swing.JPanel transportConfigPanel2;
    private javax.swing.JPanel transportConfigPanelPanel1;
    // End of variables declaration//GEN-END:variables

    private void initUserComponents() {
        putClientProperty(EjbCustomizer.PARTITION_KEY, ValidationError.PARTITION_EJB_IORSECURITY);
    }

    public void initFields(IorSecurityConfig iorSecurityConfig) {
        String transportIntegrity = null;
        String transportConfidentiality = null;
        String transportTrustTarget = null;
        String transportTrustClient = null;
        String asRequired = null;
        String asAuthMethod = null;
        String asRealm = null;
        String sasCallerPropagation = null;
        
        if(iorSecurityConfig != null) {
            TransportConfig transportConfig = iorSecurityConfig.getTransportConfig();
            
            if(transportConfig != null) {
                transportIntegrity = transportConfig.getIntegrity();
                transportConfidentiality = transportConfig.getConfidentiality();
                transportTrustTarget = transportConfig.getEstablishTrustInTarget();
                transportTrustClient = transportConfig.getEstablishTrustInClient();
            }

            AsContext asContext = iorSecurityConfig.getAsContext();
            if(asContext != null) {
                asRequired = asContext.getRequired();
                asAuthMethod = asContext.getAuthMethod();
                asRealm = asContext.getRealm();
            }

            SasContext sasContext = iorSecurityConfig.getSasContext();
            if(sasContext != null) {
                sasCallerPropagation = sasContext.getCallerPropagation();
            }
        }
        
        integrityComboBox.setSelectedItem(transportIntegrity);
        confidentialityComboBox.setSelectedItem(transportConfidentiality);
        estbTrstInTrgtComboBox.setSelectedItem(transportTrustTarget);
        estbTrstInClntComboBox.setSelectedItem(transportTrustClient);
        requiredComboBox.setSelectedItem(asRequired);
        authMethodComboBox.setSelectedItem(asAuthMethod);
        realmTextField.setText(asRealm);
        callerPropagationComboBox.setSelectedItem(sasCallerPropagation);
    }
}
