/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
/*
 * ImportComplibPanel.java
 *
 * Created on May 31, 2006, 3:42 PM
 */

package org.netbeans.modules.visualweb.complib.ui;

import java.awt.Dialog;
import java.io.File;
import java.util.List;

import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

import org.netbeans.modules.visualweb.complib.Complib;
import org.netbeans.modules.visualweb.complib.ComplibPackage;
import org.netbeans.modules.visualweb.complib.ComplibServiceProvider;
import org.netbeans.modules.visualweb.complib.ExtensionComplib;
import org.netbeans.modules.visualweb.complib.IdeUtil;
import org.netbeans.modules.visualweb.complib.Complib.InitialPaletteFolder;

/**
 * Import complib panel dialog. NetBeans Matisse generated code is at the
 * beginning of this file and user added code appears after.
 *
 * @author Edwin Goei
 */
public class ImportComplibPanel extends javax.swing.JPanel {
    private static final long serialVersionUID = 1L;

    /** Creates new form ImportComplibPanel */
    public ImportComplibPanel() {
        // Init in showDialog()
        // initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        packageLabel = new javax.swing.JLabel();
        packageTextField = new javax.swing.JTextField();
        browseButton = new javax.swing.JButton();
        previewLabel = new javax.swing.JLabel();
        previewScrollPane = new javax.swing.JScrollPane();
        previewTree = new javax.swing.JTree();
        errorLabel = new javax.swing.JLabel();

        packageLabel.setLabelFor(packageTextField);
        org.openide.awt.Mnemonics.setLocalizedText(packageLabel, org.openide.util.NbBundle.getBundle(ImportComplibPanel.class).getString("import.packageLabel"));
        packageLabel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ImportComplibPanel.class, "ACSN_import.packageLabel"));
        packageLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ImportComplibPanel.class, "ACSD_import.packageLabel"));

        packageTextField.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ImportComplibPanel.class, "ACSN_import.packageLabel"));
        packageTextField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ImportComplibPanel.class, "ACSD_import.packageLabel"));

        org.openide.awt.Mnemonics.setLocalizedText(browseButton, org.openide.util.NbBundle.getMessage(ImportComplibPanel.class, "import.browseButton"));
        browseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseButtonActionPerformed(evt);
            }
        });

        browseButton.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ImportComplibPanel.class, "ACSN_import.browseButton"));
        browseButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ImportComplibPanel.class, "ACSD_import.browseButton"));

        previewLabel.setLabelFor(previewTree);
        previewLabel.setText(org.openide.util.NbBundle.getMessage(ImportComplibPanel.class, "import.previewLabel"));
        previewLabel.getAccessibleContext().setAccessibleDescription(previewLabel.getText());

        previewTree.setRootVisible(false);
        previewTree.setSelectionModel(null);
        previewScrollPane.setViewportView(previewTree);

        errorLabel.setForeground(java.awt.Color.red);
        errorLabel.setText("Error");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, previewScrollPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 401, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(packageTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 316, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(browseButton))
                    .add(org.jdesktop.layout.GroupLayout.LEADING, previewLabel)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, packageLabel)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, errorLabel))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(packageLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(browseButton)
                    .add(packageTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(previewLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(previewScrollPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 117, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(errorLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 14, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton browseButton;
    private javax.swing.JLabel errorLabel;
    private javax.swing.JLabel packageLabel;
    private javax.swing.JTextField packageTextField;
    private javax.swing.JLabel previewLabel;
    private javax.swing.JScrollPane previewScrollPane;
    private javax.swing.JTree previewTree;
    // End of variables declaration//GEN-END:variables

    /**
     * Beginning of non-generated code
     */

    private static File savedCurDir = ComplibOptionsPanel.getImportStartDir();

    private static DefaultTreeModel EMPTY_TREE_MODEL = new DefaultTreeModel(
            new DefaultMutableTreeNode("/emptyPaletteRoot"));

    private DialogDescriptor descriptor;

    private ComplibPackage complibPackage;

    /**
     * Filter file selection so only files with complibExtention are shown
     */
    private static class CompLibFileFilter extends FileFilter {

        public final static String compLibExtension = "complib"; // NOI18N

        /**
         * Allow directories
         */
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }

            String extension = getExtension(f);
            if (extension != null) {
                return extension.equals(compLibExtension);
            }
            return false;
        }

        public String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf('.');

            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }

        /** The description of this filter */
        public String getDescription() {
            return NbBundle.getMessage(CompLibFileFilter.class,
                    "import.compLibFileFilter"); // NOI18N
        }
    }

    private void browseButtonActionPerformed(java.awt.event.ActionEvent evt) {
        JFileChooser fcd = org.netbeans.modules.visualweb.extension.openide.awt.JFileChooser_RAVE
                .getJFileChooser();
        CompLibFileFilter compLibFileFilter = new CompLibFileFilter();
        fcd.setFileFilter(compLibFileFilter);
        fcd.setCurrentDirectory(savedCurDir);

        if (fcd.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
            File packageFile = fcd.getSelectedFile();

            // Save the directory containing the chosen file for future dialogs
            if (packageFile != null) {
                File curDir = packageFile.getParentFile();
                if (curDir != null) {
                    savedCurDir = curDir;
                }
            }

            // This causes DocumentListener events to be fired
            packageTextField.setText(packageFile.getAbsolutePath());
        }
    }

    /**
     * This method is the main entry point for this dialog panel
     * 
     * @param compLibManagerPanel
     *            Component Library Manager
     */
    public void showDialog(final CompLibManagerPanel compLibManagerPanel) {
        initComponents();

        packageTextField.getDocument().addDocumentListener(
                new DocumentListener() {
                    public void changedUpdate(DocumentEvent e) {
                    }

                    public void insertUpdate(DocumentEvent e) {
                        packageFileChanged();
                    }

                    public void removeUpdate(DocumentEvent e) {
                        packageFileChanged();
                    }
                });

        // Init predefined categories to empty list
        previewTree.setModel(EMPTY_TREE_MODEL);

        // Override the leaf icon to be the same as a closed branch icon
        previewTree.setCellRenderer(new DefaultTreeCellRenderer() {
            private static final long serialVersionUID = 1L;

            public Icon getLeafIcon() {
                return getClosedIcon();
            }
        });

        clearErrorMessage();
        setValid(false);

        // TODO Change the label on the OK button to "Import". Note we can't use
        // the following code because the setValid() method does not work.
        if (false) {
            String importButton = NbBundle.getMessage(ImportComplibPanel.class,
                    "import.importButton"); // NOI18N
            String cancelButton = NbBundle.getMessage(ImportComplibPanel.class,
                    "global.cancelButton"); // NOI18N
            String helpButton = NbBundle.getMessage(ImportComplibPanel.class,
                    "global.helpButton"); // NOI18N
            Object[] options = new Object[] { importButton, cancelButton };
        }

        String title = NbBundle.getMessage(ImportComplibPanel.class,
                "import.dialogTitle"); // NOI18N
        HelpCtx helpCtx = new HelpCtx(
                "projrave_ui_elements_dialogs_import_components_db"); // NOI18N
        descriptor = new DialogDescriptor(this, title, true,
                DialogDescriptor.OK_CANCEL_OPTION, DialogDescriptor.OK_OPTION,
                DialogDescriptor.DEFAULT_ALIGN, helpCtx, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.getAccessibleContext().setAccessibleName(
                java.util.ResourceBundle.getBundle(
                        "org/netbeans/modules/visualweb/complib/ui/Bundle").getString(
                        "ACSN_import.dialog"));
        dialog.getAccessibleContext().setAccessibleDescription(
                java.util.ResourceBundle.getBundle(
                        "org/netbeans/modules/visualweb/complib/ui/Bundle").getString(
                        "ACSD_import.dialog"));

        descriptor.setValid(false);

        dialog.setVisible(true);
        if (!descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            // Cancel, or Esc: do nothing
            return;
        }

        final Dialog progressDialog = showProgressBar("import.progressImport");

        RequestProcessor.getDefault().post(new Runnable() { // separate thread
                    public void run() {
                        Complib newComplib = null;
                        try {
                            newComplib = doImportLibrary();
                        } catch (Exception e) {
                            // Log the exception
                            IdeUtil.logError(e);

                            // Notify user to check ide.log for more info
                            String msg = NbBundle.getMessage(
                                    ImportComplibPanel.class,
                                    "import.importFailed"); // NOI18N
                            NotifyDescriptor nd = new NotifyDescriptor.Message(
                                    msg, NotifyDescriptor.ERROR_MESSAGE);
                            DialogDisplayer.getDefault().notify(nd);
                        }

                        progressDialog.dispose();
                        compLibManagerPanel.notifyImportComplete(newComplib);
                    }
                });
    }

    private Dialog showProgressBar(String resourceKey) {
        String msg = NbBundle.getMessage(ImportComplibPanel.class, resourceKey);
        String title = NbBundle.getMessage(ImportComplibPanel.class,
                "global.progressTitle");

        JPanel panel = new JPanel();
        java.awt.GridBagConstraints gridBagConstraints;
        JLabel jLabel1 = new javax.swing.JLabel();
        JProgressBar jProgressBar1 = new javax.swing.JProgressBar();
        jProgressBar1.setIndeterminate(true);
        jProgressBar1.setStringPainted(false);
        panel.setLayout(new java.awt.GridBagLayout());

        jLabel1.setText(msg);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 11);
        panel.add(jLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 11, 11);
        panel.add(jProgressBar1, gridBagConstraints);

        // Create dialog with a single "close" button
        String close = NbBundle.getMessage(ImportComplibPanel.class,
                "global.labelClose"); // NOI18N
        Object[] options = new Object[] { close };
        DialogDescriptor dlg = new DialogDescriptor(panel, title, false,
                options, close, DialogDescriptor.DEFAULT_ALIGN, null, null);
        Dialog progressDialog = DialogDisplayer.getDefault().createDialog(dlg);
        progressDialog.setVisible(true);
        return progressDialog;
    }

    /**
     * @return new complib iff a new complib was actually imported
     * @throws Exception
     */
    private ExtensionComplib doImportLibrary() throws Exception {
        assert descriptor.isValid();

        ComplibServiceProvider compManager = ComplibServiceProvider
                .getInstance();

        if (compManager.isInstalled(complibPackage)) {
            String message = NbBundle.getMessage(ImportComplibPanel.class,
                    "import.libraryExists"); // NOI18N
            NotifyDescriptor nd = new NotifyDescriptor.Confirmation(message,
                    NotifyDescriptor.YES_NO_OPTION);
            Object result = DialogDisplayer.getDefault().notify(nd);
            if (NotifyDescriptor.YES_OPTION != result) {
                return null;
            }
            // Continue which will overwrite the old library
        }

        return compManager.installComplibPackage(complibPackage);
    }

    private void clearErrorMessage() {
        // not empty - that will shrink the height to 0
        errorLabel.setText(" ");
    }

    private void setValid(boolean state) {
        if (descriptor != null) {
            descriptor.setValid(state);
        }
    }

    /**
     * Validate the package file field and return corresponding ComplibPackage
     * iff valid. If it returns null, then error message and valid state has
     * been set.
     * 
     * @return ExtensionComplib iff package file field is valid
     */
    private ComplibPackage validatePackageFile() {
        File packageFile = validatePackageName();
        if (packageFile == null) {
            // Invalid package message and valid state has already been set
            return null;
        }

        ComplibPackage inputPackage;
        try {
            inputPackage = new ComplibPackage(packageFile);
        } catch (Exception e) {
            // Log the exception
            IdeUtil.logError(e);

            setErrorMessage("import.notReadable"); // NOI18N
            return null;
        }

        return inputPackage;
    }

    /**
     * Validate the package file
     */
    private void packageFileChanged() {
        complibPackage = validatePackageFile();
        if (complibPackage == null) {
            // Invalid package
            // Error message and valid state has already been set.

            // Clear preview model
            previewTree.setModel(EMPTY_TREE_MODEL);
            return;
        }

        // If we get here then the package file is valid.
        updatePreviewTreeModel();
        clearErrorMessage();
        setValid(true);
    }

    private void updatePreviewTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("/paletteRoot");

        List<InitialPaletteFolder> topFolders = complibPackage
                .getInitialPaletteFolders();
        if (topFolders.isEmpty()) {
            // No initial palette folders defined so use title
            root.add(new DefaultMutableTreeNode(complibPackage.getTitle()));
        } else {
            for (InitialPaletteFolder folder : topFolders) {
                DefaultMutableTreeNode n = new DefaultMutableTreeNode(folder
                        .getName());
                root.add(n);
            }
        }

        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        previewTree.setModel(treeModel);
    }

    /**
     * Validate Package file name field
     * 
     * @return null iff not a *.complib file and sets error message and state
     */
    private File validatePackageName() {
        // Perform validation
        String text = packageTextField.getText().trim();

        // Convert to absolute and check that it's a non-directory
        File f = validateFileName(text);
        if (f == null) {
            return null;
        }

        // Check that it is a complib file
        if (new CompLibFileFilter().accept(f)) {
            return f;
        }

        setErrorMessage("import.notCompLib"); // NOI18N
        return null;
    }

    private void setErrorMessage(String key) {
        errorLabel.setText(NbBundle.getMessage(ImportComplibPanel.class, key)); // NOI18N
        setValid(false);
    }

    /**
     * Validate that "name" is a non-directory file and return it as an absolute
     * File using the saved current directory if it is relative.
     * 
     * @param fileName
     * @return File object representing fileName or null if not valid
     */
    private File validateFileName(String fileName) {
        File f = new File(fileName);
        if (!f.isAbsolute()) {
            f = new File(savedCurDir, fileName);
        }

        if (f.exists()) {
            if (f.isDirectory()) {
                setErrorMessage("import.isDirectory"); // NOI18N
                return null;
            }
            return f;
        }

        setErrorMessage("import.noSuchFile"); // NOI18N
        return null;
    }
}
