/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xsl.scenario;

import org.netbeans.modules.xml.api.scenario.*;

/**
 * This is a ScenarioFactory implementation which creates scenarios of
 * type FileXSLScenario.
 * //!!! What is relation to ScenarioCookie?
 *
 * @author  asgeir@dimonsoftware.com
 */
public class FileXSLScenarioFactory implements ScenarioFactory {

    /** Creates a new instance of FileXSLScenarioFactory */
    public FileXSLScenarioFactory() {
    }

    /**
     * Creates a new FileXSLScenario.
     * @return a newly constructed FileXSLScenario.
     */
    public Scenario createScenario() {
        return new FileXSLScenario();
    }
    
    /**
     * Decides if the scenario type created by this factory is allowed
     * for this DataObject
     * @param dataObject The DataObject which should be tested for this Factory.
     * @return true if this factory should be allowed for that DataObject.
     */
    public boolean isEnabled(org.openide.loaders.DataObject dataObject) {
        return (dataObject instanceof org.netbeans.modules.xsl.XSLDataObject);
    }
    
    /**
     * Get a more detailed describtion of the scenario type created by this factory.
     * @return The describtion of the scenario type created by this factory.
     */
    public String getDescription() {
        return Util.THIS.getString("NAME_file_scenario_factory_description");
    }
    
    /**
     * Get the name of the scenario type created by this Factory.
     * @return The name of the scenario type created by this Factory.
     */
    public String getName() {
        return Util.THIS.getString("NAME_file_scenario_factory_name");
    }
    
    /** 
     * @return  The name of the scenario type created by this Factory.
     */
    public String toString() {
        return getName();
    }

    /** @link dependency */
    /*# FileXSLScenario lnkFileXSLScenario; */
}
