package expectj;


import java.io.InputStream;
import java.io.OutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;

/**
 * This class represents a spawned process. This will also interact with
 * the process to read and write to it.
 *
 * @author	Sachin Shekar Shetty  
 * @version 1.0
 */
public class SpawnedProcess extends ExpectHandler {

    // Command to be executed
    private String m_sCommand = null;


    // Debugger object
    Debugger debug = new Debugger("SpawnedProcess", true);

    private ProcessRunner ps = null;


    // Piper objects to pipe the process streams to standard streams
    private StreamPiper interactIn = null;
    private StreamPiper interactOut = null;
    private StreamPiper interactErr = null;

    /**
     * Constructor
     *
     * @param sCommand Process commmand to be executed
     * @param lDefaultTimeOut Default timeout for expect commands
     *
     */
    SpawnedProcess(String sCommand, long lDefaultTimeOut) 
        throws ExpectJException {
    		
    		super(lDefaultTimeOut);
            m_sCommand = sCommand;
            
            ps = new ProcessRunner(sCommand, -1);
            ps.start();
            debug.print("Spawned Process: " + sCommand);               

            inStream = ps.getInputStream();
            outStream = ps.getOutputStream();
            errStream = ps.getErrorStream();
            in = new BufferedReader(
                    new InputStreamReader(ps.getInputStream()));
            err = new BufferedReader(
                    new InputStreamReader(ps.getErrorStream()));
            out = new BufferedWriter(
                    new OutputStreamWriter(ps.getOutputStream()));

        }





    /**
     * This method returns true if the process has already exited. 
     * This method shoud be use use to check the process status 
     * before invoking send()
     */
    public boolean isClosed() {

        return ps.isClosed();

    }

    /**
     * This method returns the exit code of the process if the process has 
     * already exited.
     */
    public int getExitValue() {

        return ps.getExitValue();

    }



    /** 
     * This method functions like exactly the Unix interact command. 
     * It allows the user to interact with the spawned process.
     * Known Issues: User input is echoed twice on the screen, need to 
     * fix this ;)
     *
     */
    public void interact() throws ExpectJException {

        try {
            interactIn = new StreamPiper(null, 
                    System.in, outStream);
            interactIn.start();
            interactOut = new StreamPiper(null, 
                    inStream, System.out);
            interactOut.start();
            interactErr = new StreamPiper(null, 
                    errStream, System.err);
            interactErr.start();
            ps.stopPipingToStandardOut();

        }
        catch (Exception exp) {
            throw new ExpectJException("Error in SpawnedProcess.interact", exp);
        }



    }

    /**
     * This method kills the process represented by SpawnedProcess object.
     */ 
    public void stop() {

        if (interactIn != null)
            interactIn.stopProcessing();
        if (interactOut != null)
            interactOut.stopProcessing();
        if (interactErr != null)
            interactErr.stopProcessing();
        ps.stop();

    } 


}
