/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/

package com.sun.j2ee.blueprints.airlinesupplier.powebservice;

import java.util.*;
import java.text.*;
import java.io.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.*;

public class AirlineOrder implements Serializable {

    protected String orderId;
    protected String depFlightId;
    protected Calendar depFlightDate;
    protected String retFlightId;
    protected Calendar retFlightDate;
    protected int headCount;

    // Constructor
    public AirlineOrder() {}

    public AirlineOrder(String orderId, String depFlightId, 
      Calendar depFlightDate, String retFlightId,
      Calendar retFlightDate, int headCount) {
        this.orderId = orderId;
        this.depFlightId = depFlightId;
        this.depFlightDate = depFlightDate;
        this.retFlightId = retFlightId;
        this.retFlightDate = retFlightDate;
        this.headCount = headCount;
    }

    // getter methods
    public String getOrderId() {
        return orderId;
    }

    public String getDepFlightId() {
        return depFlightId;
    }

    public Calendar getDepFlightDate() {
        return depFlightDate;
    }

    public String getRetFlightId() {
        return retFlightId;
    }

    public Calendar getRetFlightDate() {
        return retFlightDate;
    }

    public int getHeadCount() {
        return headCount;
    }

    // setter methods
    public void setOrderId(String id) {
        this.orderId = id;
    }

    public void setDepFlightId(String id) {
        this.depFlightId = id;
    }

    public void setDepFlightDate(Calendar depFlightDate) {
        this.depFlightDate = depFlightDate;
    }

    public void setRetFlightId(String id) {
        this.retFlightId = id;
    }

    public void setRetFlightDate(Calendar retFlightDate) {
        this.retFlightDate = retFlightDate;
    }

    public void setHeadCount(int headCount) {
        this.headCount = headCount;
    }

    public static AirlineOrder fromXML(String flightPO)
        throws InvalidOrderException{
      
        AirlineOrder flight = null;      
        try { 
          
            InputSource source = new InputSource(new StringReader(flightPO));      
            DocumentBuilderFactory docBuilderFactory =
    DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();      
            //parse the source doc and extract details
            Document doc = docBuilder.parse(source);      
            Element elem = (Element)doc.getDocumentElement().getFirstChild().getNextSibling();
            flight = new AirlineOrder();

      // OrderId
            flight.setOrderId(((Text)(elem.getFirstChild())).getData());

      // DepFlightId
            elem =  getNextSibling(elem);
            flight.setDepFlightId(((Text)(elem.getFirstChild())).getData());

      // DepFlightDate
            elem = getNextSibling(elem); 
            Date date = new SimpleDateFormat("MM-dd-yy").parse(((Text)(elem.getFirstChild())).getData());
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            flight.setDepFlightDate(cal);

      // RetFlightId
            elem =  getNextSibling(elem);
            flight.setRetFlightId(((Text)(elem.getFirstChild())).getData());

      // RetFlightDate
            elem = getNextSibling(elem); 
            date = new SimpleDateFormat("MM-dd-yy").parse(((Text)(elem.getFirstChild())).getData());
            cal = Calendar.getInstance();
            cal.setTime(date);
            flight.setRetFlightDate(cal);

      // HeadCount
            elem =  getNextSibling(elem);
            flight.setHeadCount(Integer.parseInt(((Text)(elem.getFirstChild())).getData()));
        } catch(Exception exe){
            exe.printStackTrace(System.err);
            throw new InvalidOrderException("PO for Airline not valid : " +
                                            exe.getMessage());
        }      
        return flight;   
    }
    
    public static Element getNextSibling(Element elem) {
        for(Node sib=elem.getNextSibling(); sib!=null; sib=sib.getNextSibling()){
            if(sib.getNodeType() == Node.ELEMENT_NODE){
                return (Element) sib;
            }            
        }
        return null;     
    }
}

