/*
 * Package org.OpenJUMP.layer.style.classification pour JUMP
 *
 * Copyright (C) 2004
 * Olivier Bedel, ingnieur informaticien laboratoire Reso UMR ESO 6590, Bassin versant du Jaudy-Guindy-Bizien.
 * Cline Foureau, stagiaire MIAGE, laboratoire Reso UMR ESO 6590.
 * Erwan Bocher, doctorant en gographie, laboratoire Reso UMR ESO 6590, Bassin versant du Jaudy-Guindy-Bizien
 *
 * Date de cration : 19 aout. 2004
 *
 * Dvelopp dans le cadre du Projet APARAD 
 *  (Laboratoire Reso UMR ESO 6590 CNRS / Bassin Versant du Jaudy-Guindy-Bizien)
 *    Responsable : Erwan BOCHER
 *    Dveloppeurs : Cline FOUREAU, Olivier BEDEL
 *
 * olivier.bedel@uhb.fr ou olivier.bedel@yahoo.fr
 * erwan.bocher@uhb.fr ou erwan.bocher@free.fr
 * celine.foureau@uhb.fr ou celine.foureau@wanadoo.fr
 * 
 * Ce package hrite de la licence GPL de JUMP. Il est rgi par la licence CeCILL soumise au droit franais et
 * respectant les principes de diffusion des logiciels libres. (http://www.cecill.info)
 * 
 */
package org.openjump.core.ui.style.classification;

import java.util.Comparator;
import java.util.TreeMap;

/** 
 * @author FOUREAU_C
 */

public class Quantile {
	private boolean includingMin;
	private boolean includingMax;
	private Object max;
	private Object min;

	public Quantile() {
	}

	public Quantile(
		Object min,
		boolean includingMin,
		Object max,
		boolean includingMax) {
		this.min = min;
		this.max = max;
		this.includingMin = includingMin;
		this.includingMax = includingMax;
	}

	public Quantile(Object min, Object max) {
		this.min = min;
		this.max = max;
	}

	public boolean isIncludingMax() {
		return includingMax;
	}

	public boolean isIncludingMin() {
		return includingMin;
	}

	public Object getMax() {
		return max;
	}

	public Object getMin() {
		return min;
	}

	public void setIncludingMax(boolean b) {
		includingMax = b;
	}

	public void setIncludingMin(boolean b) {
		includingMin = b;
	}

	public void setMax(Object object) {
		max = object;
	}

	public void setMin(Object object) {
		min = object;
	}

	public boolean equals(Object obj) {
		return Quantile.QUANTILE_COMPARATOR.compare(this, obj)
			== 0;
	}

	private static final Comparator INFINITY_COMPARATOR = new Comparator() {
		public int compare(Object o1, Object o2) {
			if (o1 instanceof PositiveInfinity
				|| o2 instanceof NegativeInfinity) {
				return +1;
			}
			if (o1 instanceof NegativeInfinity
				|| o2 instanceof PositiveInfinity) {
				return -1;
			}
			return ((Comparable) o1).compareTo(o2);
		}
	};

	public static final Comparator QUANTILE_COMPARATOR = new Comparator() {
		public int compare(Object o1, Object o2) {
			Quantile classificationQuantile1 =
				o1 instanceof Quantile
					? (Quantile) o1
					: new Quantile(o1, true, o1, true);
			Quantile classificationQuantile2 =
				o2 instanceof Quantile
					? (Quantile) o2
					: new Quantile(o2, true, o2, true);
			int max1ComparedToMin2 =
				INFINITY_COMPARATOR.compare(
					classificationQuantile1.getMax(),
					classificationQuantile2.getMin());
			if (max1ComparedToMin2 < 0
				|| (max1ComparedToMin2 == 0
					&& (!classificationQuantile1.isIncludingMax()
						|| !classificationQuantile2.isIncludingMin()))) {
				return -1;
			}
			int min1ComparedToMax2 =
				INFINITY_COMPARATOR.compare(
					classificationQuantile1.getMin(),
					classificationQuantile2.getMax());
			if (min1ComparedToMax2 > 0
				|| (min1ComparedToMax2 == 0
					&& (!classificationQuantile1.isIncludingMin()
						|| !classificationQuantile2.isIncludingMax()))) {
				return +1;
			}
			return 0;
		}
	};

	public static final class NegativeInfinity {
	}

	public static final class PositiveInfinity {
	}

	//Trivial, but necessary for Java2XML serialization.
	public static class ClassificationQuantileTreeMap extends TreeMap {
		public ClassificationQuantileTreeMap() {
			super(QUANTILE_COMPARATOR);
		}
	}
}
