/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This file is part of SableCC.                             *
 * See the file "LICENSE" for copyright information and the  *
 * terms and conditions for copying, distribution and        *
 * modification of SableCC.                                  *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

package org.sablecc.sablecc.parser;

import org.sablecc.sablecc.analysis.AnalysisAdapter;
import org.sablecc.sablecc.node.*;

class TokenIndex extends AnalysisAdapter
{
    int index;

    public void caseTPackage(TPackage node)
    {
        index = 0;
    }

    public void caseTStates(TStates node)
    {
        index = 1;
    }

    public void caseTHelpers(THelpers node)
    {
        index = 2;
    }

    public void caseTTokens(TTokens node)
    {
        index = 3;
    }

    public void caseTIgnored(TIgnored node)
    {
        index = 4;
    }

    public void caseTProductions(TProductions node)
    {
        index = 5;
    }

    public void caseTTokenSpecifier(TTokenSpecifier node)
    {
        index = 6;
    }

    public void caseTProductionSpecifier(TProductionSpecifier node)
    {
        index = 7;
    }

    public void caseTDot(TDot node)
    {
        index = 8;
    }

    public void caseTDDot(TDDot node)
    {
        index = 9;
    }

    public void caseTSemicolon(TSemicolon node)
    {
        index = 10;
    }

    public void caseTEqual(TEqual node)
    {
        index = 11;
    }

    public void caseTLBkt(TLBkt node)
    {
        index = 12;
    }

    public void caseTRBkt(TRBkt node)
    {
        index = 13;
    }

    public void caseTLPar(TLPar node)
    {
        index = 14;
    }

    public void caseTRPar(TRPar node)
    {
        index = 15;
    }

    public void caseTLBrace(TLBrace node)
    {
        index = 16;
    }

    public void caseTRBrace(TRBrace node)
    {
        index = 17;
    }

    public void caseTPlus(TPlus node)
    {
        index = 18;
    }

    public void caseTMinus(TMinus node)
    {
        index = 19;
    }

    public void caseTQMark(TQMark node)
    {
        index = 20;
    }

    public void caseTStar(TStar node)
    {
        index = 21;
    }

    public void caseTBar(TBar node)
    {
        index = 22;
    }

    public void caseTComma(TComma node)
    {
        index = 23;
    }

    public void caseTSlash(TSlash node)
    {
        index = 24;
    }

    public void caseTArrow(TArrow node)
    {
        index = 25;
    }

    public void caseTColon(TColon node)
    {
        index = 26;
    }

    public void caseTId(TId node)
    {
        index = 27;
    }

    public void caseTChar(TChar node)
    {
        index = 28;
    }

    public void caseTDecChar(TDecChar node)
    {
        index = 29;
    }

    public void caseTHexChar(THexChar node)
    {
        index = 30;
    }

    public void caseTString(TString node)
    {
        index = 31;
    }

    public void caseTPkgId(TPkgId node)
    {
        index = 32;
    }

    public void caseEOF(EOF node)
    {
        index = 33;
    }
}
