/*
 * SetiApplet.h
 *
 * Description: struct and prototype definitions for seti applet
 *
 * Author: Richard Kinder <r_kinder@yahoo.com>
 *
 * Date: 8/1/00
 *
 * modified: 26/3/00 by Craig Orsinger (CJO) <cjorsinger@earthlink.net>
 *            - removed prototypes for static functions
 */

#include "interface.h"
#include "support.h"
#include <applet-widget.h>

#ifndef _SETI_H
#define _SETI_H

/* Filenames for state and user info */
#define USER_INFO_SAH "user_info.sah"
#define USER_INFO_TXT "user_info.txt"
#define STATE_SAH "state.sah"
#define STATE_TXT "state.txt"

/*if 65 seconds elapse and no progress (and seti running) then start flashing the logo*/
#define TIMEOUT_ATTENTION 65

/*1300ms between pixmap changes*/
#define ATTENTION_INTERVAL 1300

typedef struct _setiapplet setiapplet;

struct _setiapplet
{
	gchar* setidir; /*Directory containing seti client*/
	gint updateinterval;    /*update of UI interval (secs)*/
	gint fileupdateinterval;        /*how often the state file is re-read*/
	gint current_image;
	gint showcpu;
	gint showspike;     /*whether to display the best spike of the current data set*/
	gint showgaussian;  /*whether to display the best gaussian of the current data set*/
	gint showunits;  /*whether to display current user info*/
	gint showpercentage;        /*whether to display the percentage complete for the current data set*/
	gint nicevalue; /*Nice level to run the process as*/
	gchar* extraparams; /*Extra command line options to pass the client*/
	gint separateexedir; /*whether the exe is in a separate dir from the seti root dir*/
	gchar* setiexedir;
	gint launchonstart; /*whether to attempt to launch seti@home on applet start*/
};

/*Prototypes*/
gchar * re_read_file ( gchar *full_path );
void update_applet_menu( void );
void on_SetiAppletProperties_apply ( GnomePropertyBox*, gint, gpointer );
void on_SetiAppletProperties_help ( GnomePropertyBox*, gint, gpointer );
#endif
