.TH SETIATHOME 1 "March 22, 2000"
.\" Author: Gopal Narayanan <gopal@debian.org>
.\" Based on the README file that accompanies the seti@home
.\" client tar file
.SH NAME
setiathome \- the SETI@home client program
.SH SYNOPSIS
.B setiathome 
[\c
.BI options\fR\c
]

.SH DESCRIPTION
.LP
.B setiathome 
is the UNIX version of the SETI@home client. It
downloads radio telescope data from a network server, analyzes 
the data looking for signals of extraterrestrial origin, and 
uploads results to the server, repeating this cycle indefinitely.
See http://setiathome.ssl.berkeley.edu for more information.
.SH FILES
.LP
The program generates several files with .sah extension in the
directory from which it's run.  These should not be modified.
.LP
If you want to run multiple instances of setiathome (on a
multiprocessor machine, or on multiple machines that share a
filesystem) each one must be run in a different directory.
.LP
.B setiathome 
uses a lock file (lock.txt) to prevent multiple instances from running
in the same directory.
.LP
To finish up your current work unit, return your result, and not
download a new work unit, while the client is running, touch
a file named "stop_after_send.txt" in the client directory.
When the processing is finished, and the result sent, the client
will stop.
.LP
The file "pid.sah" contains the process ID of the current instance.
.SH RUNNING SETIATHOME
.LP
It is suggested that
the user create a new directory, say, 
.I \&$HOME/setiathome
(henceforth referred to as SETIDIR)
and then cd into SETIDIR, before running 
.B setiathome 
for the first time. The first time you run 
.B setiathome 
it will interactively
ask you for email address, name, country etc. 
This info is stored 
in a file and no interaction is needed when you run the program 
subsequently.
.LP
After this you can run 
.B setiathome 
in the background, and direct its output to /dev/null if you like.
.LP
.B setiathome 
can be freely aborted and restarted. It saves its state in files, 
and will pick up where it left off.
.LP
If you want
.B setiathome 
to be started automatically, you may wish to setup a cron job. 
If you add the following line to your crontab:
.LP
.nf
0 * * * * cd SETIDIR; setiathome -nice 19 > /dev/null 2> /dev/null
.fi
.LP
(where SETIDIR is the directory chosen above  - where you normally run
the client program from),
this cron job will attempt to start the client
at the top of every hour.  If it is already running, the next
invocation will do nothing.  If the client is not running, it will
be started.  For more information on cron jobs see the 
.BR crontab(1)
manual page.
.LP
The following script will stop all instances 
.B SETI@home:
.LP
.nf
#! /bin/sh
kill \`ps aux | grep setia | grep -v grep | awk '{print $2}'\`
.fi
.LP
The following will stop the instance in the current directory:
.LP
.nf
#! /bin/sh
kill \`cat pid.sah\`
.fi
.LP
Please do not operate the client on machines for which you do not
have permission.
.LP
.SH ENVIRONMENT VARIABLES
.LP
If the environment variable HTTP_PROXY is defined, setiathome will
connect through a proxy server, specified as hostname or hostname:port.
.LP
If the environment variable SOCKS_SERVER is defined, setiathome will
connect through a SOCKS server, specified as hostname or
hostname:port.  If the environment variables SOCKS_USER and
SOCKS_PASSWD are defined, these will be used as the login name and
password for the SOCKS server.  Otherwise setiathome will query you.
.LP
.ne 5
.SH OPTIONS
.TP
.B \-login
Login or create new account.
.ne 3
.TP
.B \-countries
Show list of country codes.
.ne 3
.TP    
.B \-version
show software version
.ne 3
.TP        
.B \-nice  \ N
set "nice" priority to N (default 1);
.ne 3
.TP    
.B \-email
Send email (to login email address) on errors.
Useful if you run in background directed to /dev/null.
.ne 3
.TP
.B \-graphics
Generate a data stream for the xsetiathome graphical interface
(available from version 2). See
.BR xsetiathome(1)
.ne 3
.TP    
.B \-proxy \ hostname:port
Connect to SETI@home server via specified proxy server and port.
.ne 3
.TP
.B \-socks_server \ hostname:port
Connect to SETI@home server via specified SOCKS server and port.
Overrides SOCKS_SERVER. SOCKS versions 4 and 5 are supported.
.ne 3
.TP
.B \-socks_user \ name
SOCKS user name.
.ne 3
.TP
.B \-socks_password \ password
SOCKS password.
.ne 3
.TP    
.B \-stop_after_process
If a work_unit.sah file is present, process this work unit
and stop after processing is complete, do not return result.
If the client is started with this option, and there is
a completed result.sah file present, the client will first
return the results, then pick up a new work unit, process
to completion, then exit.
.ne 3
.TP    
.B \-stop_after_xfer
Return results and pick up a new work unit.
This option only functions if the result.sah file is present
and complete indicating that processing is finished for this
work unit.  If a work_unit.sah is present, indicating processing
is not complete, no transfer or processing will be performed,
and the client will exit.
(see also: stop_after_send.txt mentioned in FILES above)
.ne 3
.TP
.B \-verbose
print a running summary of the work being done
Starting with the version 2.4 clients, the client is silent
to stdout during processing.  There are messages at the start
and finish of processing a work unit, but there are no progress
messages printed during processing unless this option is used.
.ne 3
.TP
.B \-nolock
omit the multiple-instance check, which uses file locking
(not available on some NFS systems)
.LP
.SH KNOWN BUGS
Outstanding shared memory segments and semaphores may be left
active in case of an abnormal exit of the 'setiathome -graphics'
process.  These can prevent any future invocation of
'setiathome -graphics'.  To resolve this problem, use 'ipcs'
and 'ipcrm' to remove shared memory segments and semaphores that
are not associated with a process.  This behavior may vary
depending upon how your UNIX system handles this situation.
See also ipcs(1) and ipcrm(1)

.SH AUTHOR
This manual page was written by Gopal Narayanan
<gopal@debian.org>,
for the Debian GNU/Linux system (but may be used by others). This
manual page is mostly derived from the README file that accompanies the 
.B setiathome
client program.





