#ifndef __NMPALM_B_H__
#define __NMPALM_B_H__

#define B_SECTION  __attribute__ ((section ("b")))

/*
Copyright (C) 1998, 1999, 2000 Wabasoft

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.
*/

#include <PalmOS.h>
#include <Chars.h>

// globals

// PlamOS Version 2.0 or later is supported.
// Note that you should use < or >= in these comparisons,
// in nearly every case, because 3.0.1 should be treated the same way as 3.0.
// If you say "if vers <= 3.0" you'd often do the wrong thing.
#define wabaMinVersion      sysMakeROMVersion(2,0,0,sysROMStageRelease,0)
#define palmOS_Version3p0   sysMakeROMVersion(3,0,0,sysROMStageRelease,0)
#define palmOS_Version3p1   sysMakeROMVersion(3,1,0,sysROMStageRelease,0)
#define palmOS_Version3p3   sysMakeROMVersion(3,3,0,sysROMStageRelease,0)
#define palmOS_Version3p5   sysMakeROMVersion(3,5,0,sysROMStageRelease,0)

#define NET_NOT_READY_FOR_OPEN  0
#define NET_READY_FOR_OPEN      1
#define NET_IS_OPEN             2
#define NET_OPEN_FAILED         3

extern WObject      globalMainWin;
extern int32        globalTimerInterval;
extern int32        globalTimerStart;
extern int          classDbCount;
extern DmOpenRef*   classDbList;
extern ULong        appCreatorId;
extern Word         globalSocketLibRefNum;
extern int          globalNetState;
extern DWord        palmOS_ROM_Version;

#ifdef QUICKBIND
extern int32        postEventMethodMapNum;
extern int32        onTimerTickMethodMapNum;
#endif

/*** Isao F. Yamashita 1218/2000 ***/
extern UInt32              globalScreenDepth;

#ifdef WITH_THREAD

//*** Isao's Multithread implementation START ***
// Thread variables - Isao F. Yamashita 07/25/2000
#define THREAD_LIST_MAX_SIZE 8

typedef struct
{
    WClass* tClass;
    WObject tObject;
    WObject syncObject;

    WClassMethod* syncMethod;

    int32   runMethodMapNum;
    int32   syncMethodMapNum;

    uint32  sleepCountSet;
    uint32  sleepCountNow;

    uchar   isSleepCountAlreadySet;

    uchar   isWaiting;
} WThread;

extern WThread wThreadList[THREAD_LIST_MAX_SIZE];
extern uint32  threadListCurrentSize;
extern uint32  threadProcessIndex;
extern uint32  threadSynchMethodIndex;



//*** This "_onThreadStart()" method is called from "start()" method.
Var ThreadStart(Var stack[]) B_SECTION;

//*** This "_onThreadStop()" method is called from "stop()" method.
Var ThreadStop(Var stack[]) B_SECTION;

//*** This "_onThreadSleep()" method is called from "sleep()" method.
Var ThreadSleep(Var stack[]) B_SECTION;

//*** This "_onThreadWait()" method is called from "wait()" method.
Var ThreadWaitForSignal(Var stack[]) B_SECTION;

Var ThreadSignalAll(Var stack[]) B_SECTION;

//*** Isao's Multithread implementation END ***

#endif   /* WITH_THREAD */


Long millisToTicks(int32 millis) B_SECTION;
int32 getTimeStamp() B_SECTION;
void postStopEvent() B_SECTION;
void drawErrorWin() B_SECTION;
void drawMainWin() B_SECTION;
void timerCheck() B_SECTION;
void handleErrorWinEvent(EventPtr eventP) B_SECTION;
void handleMainWinEvent(EventPtr eventP) B_SECTION;
Long calcEventTimeout() B_SECTION;
int isostrncmp(uchar *s1, uchar *s2, uint16 n) B_SECTION;
uchar* lockWarpRec(char* path, uint16 pathLen, uint32* size) B_SECTION;
void unlockWarpRec(uchar *ptr, uint16 pathLen) B_SECTION;
uchar* nativeLoadClass(UtfString className, uint32* size) B_SECTION;

#ifdef SECURE_CLASS_HEAP

extern DmOpenRef classHeapDmRef;
extern VoidHand classHeapRecH;
extern VoidPtr classHeapRecP;

void delClassHeapDb();

#endif    /* SECURE_CLASS_HEAP */

WObject startApp(int runApp);
void stopApp(WObject mainWinObj);

DWord PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags);

#endif /* __NMPALM_B_H__ */

/*
   Local Variables:
   c-file-style: "smartdata"
   End:
*/
