/* ------------------------------------------------------------------------
 * TextureKitImpl.hh
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-10-18 by Steve Houston.
 *
 * Copyright (c) 2001 Steve Houston <steve@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _TextureKitImpl_hh_
#define _TextureKitImpl_hh_

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Nobel/TextureKit.hh"

// -- Local Includes
#include "KitImpl.hh"

// -- Namespace Definitions

class TextureKitImpl : public virtual POA_Nobel::TextureKit, 
		       public KitImpl {
public:
    
    /**
     * Constructor.
     **/
    TextureKitImpl() { }
    
    /**
     * Destructor.
     **/ 
    virtual ~TextureKitImpl() { }
    
    // IDL Functions
    virtual char *name() { return CORBA::string_dup("TextureKit"); }
    virtual char *description() {
	return CORBA::string_dup("Texture map component factory kit.");
    }

    virtual Nobel::Texture_ptr createTexture();
    virtual Nobel::ProceduralTexture_ptr createProceduralTexture();
    /*
    virtual Nobel::TextureGenerator_ptr
    createVNCTextureGenerator(const char *host, CORBA::Short port,
			      const char* passwd);
    */
    virtual Nobel::Mapper_ptr createPlanarMapper();

private:
    
    // No copy constructor for kits
    TextureKitImpl(const TextureKitImpl &kit);
};

#endif /* TextureKitImpl.hh */
