/* ------------------------------------------------------------------------
 * $Id: TextureKitImpl.cc,v 1.4 2001/08/21 21:37:40 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-10-18 by Steve Houston.
 *
 * Copyright (c) 2001 Steve Houston <steve@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- 3Dwm Includes
#include "Celsius/Mutex.hh"
#include "Polhem/ImageImpl.hh"
#include "Polhem/TextureKitImpl.hh"
#include "Polhem/MapperImpl.hh"

using namespace Nobel;

// -- Code Segment

Texture_ptr TextureKitImpl::createTexture()
{
    // Create and activate the object, register and return it!
    TextureImpl *texture = activate(new TextureImpl());
    return texture->_this();
}

ProceduralTexture_ptr TextureKitImpl::createProceduralTexture()
{
    // Create and activate the object, register and return it!
    ProceduralTextureImpl *procTex = activate(new ProceduralTextureImpl());
    return procTex->_this();
}

/*
TextureGenerator_ptr
TextureKitImpl::createVNCTextureGenerator(const char* host,
					  CORBA::Short port,
					  const char* passwd)
{
    VNCTextureGenerator *vncTexGen = 
	activate(new VNCTextureGenerator(host, port, passwd));
    return vncTexGen->_this();
}
*/

Mapper_ptr TextureKitImpl::createPlanarMapper()
{
    MapperImpl *mapper = activate(new PlanarMapperImpl());
    return mapper->_this();
}
