
/*
 *  Copyright (c) 1998 - 1999, 2001 Karel Zak "Zakkr" <zakkr@zf.jcu.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  $Id: draw.c,v 1.3 2001/01/02 14:16:15 zakkr Exp $
 */


#include "aca.h"

#include <ctype.h>
#include <stdlib.h>
#include <string.h>

   void draw_linebox(int y, int x, int yn, int xn, int color)
   {
      register int i;
   
      _D( " draw_linebox() ");
   
      aca_c(color);
   
      for(i=x+1; i < x+xn; i++) {
         mvaddch(y,	i,	 ACA_HLINE);
         mvaddch(y+yn,	i,	 ACA_HLINE);	
      }
      for(i=y+1; i < y+yn; i++) {
         mvaddch(i,	x,	 ACA_VLINE);
         mvaddch(i,	x+xn,	 ACA_VLINE);	
      }	 
      mvaddch(y,	x,	 ACA_ULCORNER);	
      mvaddch(y,	x+xn,	 ACA_URCORNER);
      mvaddch(y+yn,	x,	 ACA_LLCORNER);	
      mvaddch(y+yn,	x+xn,	 ACA_LRCORNER);
   }

   void aca_border(int y, int x, int yn, int xn, int color)
   {
      register int i;
   
      _D( " draw_linebox() ");
   
      aca_c(color);
   
      if (!aca.color)	{
         if ((*(GL_c+color)).bw != A_REVERSE) bold;
      } 
      else		
         ubold;
   
      for(i=x+1; i < x+xn; i++) {
         mvaddch(y,	i,	 ACA_HLINE);
         mvaddch(y+yn,	i,	 ACA_HLINE);	
      }
      for(i=y+1; i < y+yn; i++) {
         mvaddch(i,	x,	 ACA_VLINE);
         mvaddch(i,	x+xn,	 ACA_VLINE);	
      }	 
      mvaddch(y,	x,	 ACA_ULCORNER);	
      mvaddch(y,	x+xn,	 ACA_URCORNER);
      mvaddch(y+yn,	x,	 ACA_LLCORNER);	
      mvaddch(y+yn,	x+xn,	 ACA_LRCORNER);
   
      if (!aca.color) 
         if ((*(GL_c+color)).bw != A_REVERSE) ubold;
   }

   void clear_linebox(int y, int x, int yn, int xn, int color)
   {
      register int i;
   
      _D( " clean_linebox() ");
   
      for(i=x+1; i < x+xn; i++) {
         mvaddch(y,	i,	 ' ');
         mvaddch(y+yn,	i,	 ' ');	
      }
      for(i=y+1; i < y+yn; i++) {
         mvaddch(i,	x,	 ' ');
         mvaddch(i,	x+xn,	 ' ');	
      }	 
      mvaddch(y,	x,	 ' ');	
      mvaddch(y,	x+xn,	 ' ');
      mvaddch(y+yn,	x,	 ' ');	
      mvaddch(y+yn,	x+xn,	 ' ');
   }

#ifndef DEBUG_POSITION

   inline void clean_box(int y, int x, int yn, int xn, int color)
   {
      register int	lin, col;
   
      aca_c(color);
   
      for(lin=y; lin<=y+yn; lin++)      	
         for(col=x; col<=x+xn; col++)    
            mvaddch(lin, col , ' ');		
   }
   
#else
  
   inline void clean_box(int y, int x, int yn, int xn, int color)
   {
      register int	lin, col, q;
   
      aca_c(color);
   
      for(lin=y; lin<=y+yn; lin++)      	
         for(col=x, q=0; col<=x+xn; col++, q++)    {
            if (q == 10) q=0;
            mvprintw(lin, col, "%d", q);
      }      
   }    

#endif
   void center_addnstr(int y, int x, char *str, int max) /* 'x' is line center */
   {
      int	a=0, b, half=0;
      char	*p, *h;
   
      _D(" center_addnstr()");
   
      if (!str) return;
   
      for (p = str, half=0; *p != '\0'; p++, half++) 	
         if (*p == '\n') 
            break;	
      if (half > max) half = max;
      half/=2; 
      for (p=str, b=0; *p != '\0'; b++, p++) {
         if (*p == '\n') {
            ++a; b=-1; 
            for (h=p+1, half=1; *h != '\0'; h++, half++) {	
               if (*h == '\n') 
                  break;
            }
            if (half > max) half = max;		
            half/=2; 
            continue;
         }
      /* if (b < max) mvaddch(y+a, x-half+b, *p ); */
         if (b < max) mvprintw(y+a, x-half+b, "%c", *p ); 
      } 
   }

   void left_addnstr(int y, int x, char *str, int maxlines, int max)	
   {
      int	a=0, b;
      char	*p;
   
      _D(" left_addnstr()");

      if (!str) return;
   
      for (p=str, b=0; *p != '\0'; b++, p++) {
         if (*p == '\n') {
            if (++a > maxlines) 
               return;
            b=-1;
            continue;
         }
         if (b <= max) mvprintw(y+a, x+b, "%c", *p);
      } 
   }

   inline void mvaddline_nstr (int y, int x, char *str, int line, int max)	
   {
      int	a=0, b;
      char	*p;
   
      _D(" mvaddline_nstr()");

      if (!str) return;
   
      for (p=str, b=0; *p != '\0'; b++, p++) {
         if (*p == '\t') { 
            b+=8; 
            continue; 
         }	
         if (*p == '\n') {
            if (++a > line) 
               break;
            b=-1;
            continue;
         }
         if (a == line) {
            if (*p == '\0') break; 
            if (b <= max) mvprintw(y, x+b, "%c", *p);
            else 
               break;
         }	
      }	 		
   }

   inline void mvaddline_nstr_sht (int y, int x, char *str, int line, int max, int sht)	
   {
      int	a=0, b;
      char	*p = chN;
   
      _D(" mvaddline_nstr_sht()");

      if (!str) return;

      for (p=str, b=0; *p != '\0'; b++, p++) {
         if (*p == '\n') {
            if (++a > line) 
               break;
            b=-1;
            continue;
         }
         if (a == line) {
            if (*p == '\t') { 
            	b+=8; 
            	continue; 
            }
            if (b < sht) continue;
            if (b-sht <= max) { 
            	if (*p == '\0') break; 
            	mvprintw(y, x+(b-sht), "%c", *p);
            }
            else 
               break;
         }	
      }	 		
   }

   chtype **init_refresh_buffer()
   {
      int	i;
      chtype	**b;
   
      _D( " init_refresh_buffer()" );
   
      if ((b = (chtype **) calloc(LINES+1, sizeof(chtype *))) == NULL) 
         return (chtype **) NULL;
   
      for (i=0; i<=LINES; i++) 
         if ((*(b+i) = (chtype *) calloc(COLS+1, sizeof(chtype))) == NULL) 
            return (chtype **) NULL;			
      return b;
   }

   void fill_refresh_buffer(chtype **b)
   {
      register int	y, x;
      chtype		**i, *ii;
   
      _D( " fill_refresh_buffer() " );
   
      for(y=0, i=b; i<= b + LINES; i++, y++) 
         for(x=0, ii = *i; ii < *i + COLS; ii++, x++) 
            *ii = mvinch(y, x);
   }

   void print_refresh_buffer(chtype **b)
   {
      register int 	y, x;
      chtype		**i, *ii;
   
      _D( " print_refresh_buffer() " );	
   
      for(y=0, i=b; i<= b + LINES; i++, y++) 
         for(x=0, ii = *i; ii < *i + COLS; ii++, x++) {
            attron( *ii & A_COLOR);
            mvaddch(y,x, *ii );
         }	
   }

   inline void show_run()
   {
      int		showch=0;
      static int	last='/';
   
      switch(last) {
      case '|':  showch='/'; 
         break;		
      case '/':  showch='-'; 
         break;
      case '-':  showch='\\'; 
         break;	
      case '\\': showch='|'; 
         break;	
      
      }			
      mvaddch(0, COLS-1, showch);
      last = showch;
      refresh();
   }

