//This file is part of AcetoneISO. Copyright 2006,2007,2008,2009 Marco Di Antonio and Fabrizio Di Marco (acetoneiso@gmail.com)
//
//    AcetoneISO is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    AcetoneISO is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with AcetoneISO.  If not, see <http://www.gnu.org/licenses/>. 
void acetoneiso::psxrip()
{
QDir bin("/usr/bin");
QFile cdrdao;
QDir::setCurrent( bin.path() );
cdrdao.setFileName("cdrdao");

if (cdrdao.exists())
	{

     bool ok;
     QString text = QInputDialog::getText(this, tr("AcetoneISO::Insert cd/dvd device"),
                                          tr("Please specify your CD/DVD device. If you aren't sure just leave default.\nTypical devices are:\n/dev/cdrom or /dev/cdrom0 or /dev/cdrom1 or /dev/dvd and follow this symbolism."), QLineEdit::Normal,
                                          "/dev/cdrom", &ok);



if (ok && !text.isEmpty())
{


 QDir Home = QDir::home();
		 	QString fileName = QFileDialog::getSaveFileName(this, tr("AcetoneISO::Save BIN file"),
										Home.path() + "/AcetoneISO_PSX",
										tr("Images (*.bin)"));

			
			if ( fileName.isNull() )
			{
			  return;
			}

QString	filebin = fileName.append(".bin");
QString	filetoc = fileName.append(".toc");
UMountcdrom.start("umount",QStringList()  << text);	


	 showProgressDisplay();
	 PSxrip = new QProcess();
	 PSxrip->setReadChannel(QProcess::StandardOutput);
	 PSxrip->setProcessChannelMode(QProcess::MergedChannels);	
 	//connection to update the display
 	connect(PSxrip, SIGNAL(readyReadStandardOutput()), SLOT(updateProgressDisplay_PSxrip() )); 
	connect(PSxrip, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(printOutpsx(int, QProcess::ExitStatus)));

PSxrip->start("cdrdao",QStringList()  << "read-cd" << "--read-raw" << "--datafile" << filebin << "--device" << text << "--driver" << "generic-mmc-raw" << filetoc);

	}
}
else
QMessageBox::warning(this, "AcetoneISO::Warning!",tr("no cdrdao found in /usr/bin"));
}


