/*
	Actionaz
	Copyright (C) 2008-2012 Jonathan Mercier-Ganady

	Actionaz is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Actionaz is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program. If not, see <http://www.gnu.org/licenses/>.

	Contact : jmgr@jmgr.info
*/

#include "writeregistryinstance.h"
#include "readregistryinstance.h"

#ifdef Q_WS_WIN
#include <Windows.h>
#endif

namespace Actions
{
	void WriteRegistryInstance::startExecution()
	{
	#ifdef Q_WS_WIN
		bool ok = true;

		ActionTools::Registry::Key key = evaluateListElement<ActionTools::Registry::Key>(ok, ReadRegistryInstance::keys, "key");
		QString subKey = evaluateString(ok, "subKey");
		QString value = evaluateString(ok, "value");
		QVariant data = evaluateVariant(ok, "data");

		if(!ok)
			return;

		switch(ActionTools::Registry::write(data, key, subKey, value))
		{
		case ActionTools::Registry::WriteCannotFindSubKey:
			setCurrentParameter("subKey");
			emit executionException(CannotFindSubKeyException, tr("Cannot find subKey \"%1\"").arg(subKey));
			return;
		case ActionTools::Registry::WriteCannotWriteValue:
			setCurrentParameter("value");
			emit executionException(CannotWriteValueException, tr("Cannot write value \"%1\"").arg(value));
			return;
		default:
			break;
		}
	#endif

		emit executionEnded();
	}
}
