# ----------------------------------------------------------------------------
# - afnix-gcc-4                                                              -
# - afnix compiler configuration - gcc configuration                         -
# ----------------------------------------------------------------------------
# - This program is  free software;  you can  redistribute it and/or  modify -
# - it provided that this copyright notice is kept intact.                   -
# -                                                                          -
# - This  program  is  distributed in the hope  that it  will be useful, but -
# - without  any   warranty;  without  even   the   implied    warranty   of -
# - merchantability  or fitness for a particular purpose. In not event shall -
# - the copyright holder be  liable for  any direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.      -
# ----------------------------------------------------------------------------
# - copyright (c) 1999-2007 amaury darsch                                    -
# ----------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# - compiler and linker section                                              -
# ----------------------------------------------------------------------------

CC              = g++
LD              = gcc
LK		= gcc
AR              = ar
RANLIB		= ranlib
STDEVFLAGS      =
STDCCFLAGS      = -Wall -Werror -fno-builtin
STACCFLAGS	=
DYNCCFLAGS	= -fPIC
PLTCCFLAGS      = -MMD
DEBUGFLAGS      = -g
OPTCCFLAGS      = -O2
PFLCCFLAGS      = -g -pg
COVCCFLAGS      = -g -fprofile-arcs -ftest-coverage
CPPCCFLAGS      = -nostdinc -nostdinc++
CXXCCFLAGS      = 
STDDEFINES      = -D_REENTRANT
DBGDEFINES      = -DDEBUG
OPTDEFINES      =
STDINCLUDE      =
AFXCPPTYPE	= GNU
AFXCPPVERS	= 4

# ----------------------------------------------------------------------------
# - compiler dependant libraries                                             -
# ----------------------------------------------------------------------------

# adjust for darwin platform
ifeq ($(PLATNAME),darwin)
PLTSDKROOT	= $(SDKDIR)
PLTSDKARCH	= -arch ppc -arch i686
PLTCCFLAGS      = -isysroot ${PLTSDKROOT} $(PLTSDKARCH)
PLTLDFLAGS	= $(PLTCCFLAGS)
PLTLKFLAGS	= $(PLTCCFLAGS)
PLTEVFLAGS	= MACOSX_DEPLOYMENT_TARGET=10.4
endif

# ----------------------------------------------------------------------------
# - platform dependant linking flags                                         -
# ----------------------------------------------------------------------------

# adjust for linux platform
ifeq ($(PLATNAME),linux)
ARFLAGS		= rc
LDFLAGS		= -shared
ifeq ($(LKMODE),soname)
LDFLAGS	       += -Wl,-soname,$(SONAME)
endif
AFXCPPLIBS	= -lsupc++
endif

# adjust for solaris platform
ifeq ($(PLATNAME),solaris)
ARFLAGS		= rc
LDFLAGS		= -shared
ifeq ($(LKMODE),soname)
LDFLAGS	       += -Wl,-h,$(SONAME)
endif
AFXCPPLIBS	= -lsupc++
endif

# adjust for freebsd platform
ifeq ($(PLATNAME),freebsd)
LD		= g++
LK		= g++
ARFLAGS		= rc
LDFLAGS		= -shared
ifeq ($(LKMODE),soname)
LDFLAGS	       += -Wl,-soname,$(SONAME)
endif
AFXCPPLIBS	=
endif

# adjust for darwin platform
ifeq ($(PLATNAME),darwin)
LD		= g++
LK		= g++
ARFLAGS		= -rc
LDFLAGS		= -dynamiclib $(PLTLDFLAGS)
ifeq ($(LKMODE),dylib)
LDFLAGS	       += -compatibility_version $(MAJOR).$(MINOR)
LDFLAGS        += -current_version $(MAJOR).$(MINOR).$(PATCH)
else
$(error, "undefined darwin linking mode")
endif
AFXCPPLIBS	=
endif

# adjust for gnu/freebsd platform
ifeq ($(PLATNAME),gnukbsd)
ARFLAGS		= rc
LDFLAGS		= -shared
ifeq ($(LKMODE),soname)
LDFLAGS	       += -Wl,-soname,$(SONAME)
endif
AFXCPPLIBS	= -lsupc++
endif

# ----------------------------------------------------------------------------
# - platform dependant final executable flags                                -
# ----------------------------------------------------------------------------

LKFLAGS		=

# adjust linker flags for freebsd
ifeq ($(PLATNAME),freebsd)
LKFLAGS      	= -pthread
endif

# adjust linker flags for darwin
ifeq ($(PLATNAME),darwin)
LKFLAGS      	= $(PLTLKFLAGS)
endif

# ----------------------------------------------------------------------------
# - platform dependant compilation flags                                     -
# ----------------------------------------------------------------------------

# adjust platform flag for static or dynamic
ifeq ($(LKTYPE),dynamic)
PLTCCFLAGS     += $(DYNCCFLAGS)
endif
ifeq ($(LKTYPE),static)
PLTCCFLAGS     += $(STACCFLAGS)
endif

# adjust intel processor
ifeq ($(PROCNAME)-$(PROCTYPE),ia32-586)
OPTCCFLAGS     += -march=i586
endif
ifeq ($(PROCNAME)-$(PROCTYPE),ia32-686)
OPTCCFLAGS     += -march=i686
endif

