# ---------------------------------------------------------------------------
# - apx-nmesg                                                              -
# - afnix:apx message node class module                                    -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2007 amaury darsch                                   -
# ---------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# - global section                                                           -
# ----------------------------------------------------------------------------

# the message node class
const afnix:apx:mesg (class)

# ----------------------------------------------------------------------------
# - private section                                                          -
# ----------------------------------------------------------------------------

const AFNIX:APX:XML-HEAD-NAME "apx:head"
const AFNIX:APX:XML-MENV-NAME "apx:env"
const AFNIX:APX:XML-PAYL-NAME "apx:payload"

# the environment name/value attributes
const AFNIX:APX:XML-MNAM-ATTR "name"
const AFNIX:APX:XML-MVAL-ATTR "value"

# ----------------------------------------------------------------------------
# - initial section                                                          -
# ----------------------------------------------------------------------------

# initialize the apx message node
# @param name the message node name

trans afnix:apx:mesg:preset (name) {
  # set the base object
  trans this:super (afnix:xml:XmlTag name)
  # preinitialize the node
  this:preini
}

# pre-initialize the node
# @param name the node name
trans afnix:apx:mesg:preini nil {
  # create the head node
  const head (afnix:xml:XmlTag AFNIX:APX:XML-HEAD-NAME)
  # add the apx tag node
  this:add-child head
}

# ----------------------------------------------------------------------------
# - method section                                                          -
# ----------------------------------------------------------------------------

# attach a message node to this node
# @param node the node to attach

trans afnix:apx:mesg:attach-node (node) {
  assert true (afnix:xml:tag-p node)
  trans this:super node
}

# @return the base node

trans afnix:apx:mesg:get-base-node nil {
 eval this:super
}

# @return the head node

trans afnix:apx:mesg:get-head-node nil {
  this:lookup-child AFNIX:APX:XML-HEAD-NAME
}

# set the node payload
# @param data the payload to set

trans afnix:apx:mesg:set-payload-node (payl) {
  # check if the paylod node exists
  if (this:child-p AFNIX:APX:XML-PAYL-NAME) {
    throw "apx-error" "payload already exists in node"
  }
  # create a payload node
  const node (afnix:xml:XmlTag AFNIX:APX:XML-PAYL-NAME)
  # attach the payload based on the type
  if (afnix:xml:node-p payl) (node:add-child payl) (node:parse payl)
  # add the node as a child node
  this:add-child node
}

# @return the payload node

trans afnix:apx:mesg:get-payload-node nil {
  this:lookup-child AFNIX:APX:XML-PAYL-NAME
}

# add a environment name in the request node
# @param name the environment name to add

trans afnix:apx:mesg:add-environment-name (name) {
  # get the head node
  const head (this:get-head-node)
  # create an environment tag
  const menv (afnix:xml:XmlTag AFNIX:APX:XML-MENV-NAME)
  menv:set-attribute AFNIX:APX:XML-MNAM-ATTR name
  # add the node to the head
  head:add-child menv
}

# add a environment name/value pair in the request node
# @param name  the environment name  to add
# @param value the environment value to add

trans afnix:apx:mesg:add-environment-name-value (name value) {
  # get the head node
  const head (this:get-head-node)
  # create an environment tag
  const menv (afnix:xml:XmlTag AFNIX:APX:XML-MENV-NAME)
  menv:set-attribute AFNIX:APX:XML-MNAM-ATTR name
  menv:set-attribute AFNIX:APX:XML-MVAL-ATTR value
  # add the node to the head
  head:add-child menv
}

# add an environment list
# @param argl the argument list to add

trans afnix:apx:mesg:add-environment-list (argl) {
  # make sure we have a property list
  assert true (plist-p argl)
  # loop in the attribute list
  for (attr) (argl) {
    trans name (attr:get-name)
    trans pval (attr:get-value)
    this:add-environment-name-value name pval
  }
}
