#ifndef _LEVEL_LIST_H
#define _LEVEL_LIST_H

#include "level.h"
#include "builder.h"
#include "player.h"
#include "errlog.h"
#include "object_list.h"

/******************************************
 ** Holds the level object
 ******************************************/

struct chain_link {
   Level      *the_level;
   chain_link *next_link;
};

class Level_Chain;

/********************************************************
 ** Maintains the list of level chains
 ********************************************************/

class Level_List {
 public:
	 int get_status();

   Level_List(ErrLog *error_log, Object_List *obj_dbase);
   ~Level_List();
   int   load_levels(ErrLog *error_log, Object_List *obj_dbase);
   int   add_level(Level *the_level);
   int   check_levels(Player *the_player);
   Level *get_level(char *the_chain, int the_lvl);
   int   show_chains(Player *the_player);
   int   show_levels(Player *the_player, char *the_chain);


 private:
	 int status;

   Level_Chain *the_list;
};


/********************************************************
 ** Maintains a level chain, such as Wizard level chain, 
 ** Warrior level chain, etc
 ********************************************************/

class Level_Chain {
 public:
   
   Level_Chain(char *the_name);
   ~Level_Chain();
   char *get_chain_name();
   void set_chain_name(char *the_name);
   int  add_level(Level *the_level);
   int check_chain(Player *the_player, int the_lvl);
   Level *get_level(int the_lvl);
   int show_levels(Player *the_player);
   int get_num_levels();

   Level_Chain *get_next_chain();
   void set_next_chain(Level_Chain *new_chain); 

 private:

   Strings     chain_name;
   chain_link  *the_chain;

   Level_Chain *next_chain;
};


#endif

