#ifndef _TALENT_H
#define _TALENT_H

#include "entity.h"

class Builder;
class Player;
class Strings;

class Talent : public Entity {
 public:

   Talent();
   virtual ~Talent();
   Talent(char *quest_name);

   void set_description(char *the_string);
   char *get_description();
   void set_special(char *the_string);
   char *get_special();
   void set_cost(int the_num);
   int get_cost();
   void set_allowed(int the_num);
   int get_allowed();

   int assign_talent(Player *the_player);

   int load_talent(FILE *the_file, ErrLog *error_log, int is_builder);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);
   void write_object(FILE *the_file, int is_builder);


   int is_modified();
   void set_modified(int the_num);
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();


 private:

   int       modified;

   int       cost;
   int       allowed;

   Strings   description;
   Strings   the_special;
};

#endif
