#ifndef _ABERPDIRT_H
#define _ABERPDIRT_H

#include <stdio.h>
#include "../../include/flags.h"
#include "../../include/strings.h"
#include "../../include/lexer.h"

struct flag_name {
   char    *aberflag;
   char    *aimeflag;
};

struct temp_loc {
   Strings name;
   Strings dir[10];
   Strings title;
   Flags   *lflags;
   Strings desc;
};

struct temp_mob {
   Strings name;
   Strings title;
   Flags   *indflags;
   Strings location;
   int     str;
   int     damage;
   int     speed;
   int     aggression;
   int     armor;
   Strings desc;
   Strings examine;
};

struct temp_obj {
   Strings name;
   Strings title;
   Strings altname;
   Strings location;
   Flags   *itemflags;
   Flags   *wearflags;
   int     state;
   int     maxstate;
   int     basevalue;
   int     damage;
   int     armor;
   int     size;
   int     weight;
   Strings desc0;
   Strings desc1;
   Strings desc2;
   Strings examine;
   Strings linked;
   Strings poss_type;
};

int ap_convert(FILE *read_file, FILE *write_file, char *filename, float version);
int ap_read_location(FILE *read_file, FILE *write_file);
int ap_read_mobile(FILE *read_file, FILE *write_file);
int ap_read_object(FILE *read_file, FILE *write_file);
int ap_get_mob_element(FILE *read_file, token_record **the_token);
int ap_get_obj_element(FILE *read_file, token_record **the_token);
int ap_get_loc_element(FILE *read_file, token_record **the_token);
int ap_read_header(FILE *read_file);
int ap_write_obj(FILE *write_file);
void ap_display_options();
void ap_display_obj();
void ap_display_obj(Strings *the_string);
void ap_write_mudobj_attrib(FILE *write_file);
void ap_write_item_attrib(FILE *write_file);
void ap_write_moveable_attrib(FILE *write_file);
void ap_write_merger_attrib(FILE *write_file);
void ap_write_as_weapon(FILE *write_file);
void ap_write_as_book(FILE *write_file);
void ap_write_as_wearable(FILE *write_file);
void ap_write_as_moveable(FILE *write_file);
void ap_write_as_marker(FILE *write_file);
void ap_write_as_door(FILE *write_file);
void ap_write_as_food(FILE *write_file);
void ap_write_as_money(FILE *write_file);
void ap_write_as_key(FILE *write_file);

#endif







