/*****************************************************************************
*
* ALPS Project: Algorithms and Libraries for Physics Simulations
*
* ALPS Light Libraries
*
* Copyright (C) 2001-2003 by Prakash Dayal <prakash@comp-phys.org>,
*                            Matthias Troyer <troyer@comp-phys.org>,
*                            Rene Villiger <rvilliger@smile.ch>
*
* This software is part of the "ALPS Light" Libraries, public-domain
* part of the ALPS Libraries. If you need the full functionality of
* the ALPS Libraries, such as Lattice, Model, Scheduler, etc, please
* use the full version of ALPS Libraries, which is available from
* http://alps.comp-phys.org/.
*
* Permission is hereby granted, free of charge, to any person or organization
* obtaining a copy of the software and accompanying documentation covered by
* this license (the "Software") to use, reproduce, display, distribute,
* execute, and transmit the Software, and to prepare derivative works of the
* Software, and to permit third-parties to whom the Software is furnished to
* do so, all subject to the following:
*
* The copyright notices in the Software and this entire statement, including
* the above license grant, this restriction and the following disclaimer,
* must be included in all copies of the Software, in whole or in part, and
* all derivative works of the Software, unless such copies or derivative
* works are solely in the form of machine-executable object code generated by
* a source language processor.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT 
* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, 
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
* DEALINGS IN THE SOFTWARE.
*
*****************************************************************************/

/* $Id: ietl2lapack_interface.h,v 1.5 2003/09/05 08:12:38 troyer Exp $ */

#ifndef IETL_LAPACK_INTERFACE_H
#define IETL_LAPACK_INTERFACE_H
#include <complex>

extern "C" {
void sstev_(const char& jobz, const int& n, float sd[],
            float se[], float sz[], const int& ldz, 
            float swork[], int& info);

void dstev_(const char& jobz, const int& n, double dd[],
            double de[], double dz[], const int& ldz, 
            double swork[], int& info);
  
void csteqr_(const char& jobz, const int& n, float sd[],
            float se[], std::complex<float> sz[], const int& ldz, 
            float swork[], int& info);

void zsteqr_(const char& jobz, const int& n, double dd[],
            double de[], std::complex<double> dz[], const int& ldz, 
            double dwork[], int& info);  

void dsyevx_(const char& jobz,            const char& range,         const char& uplo,
                             const int& n,                double da[],               const int& lda,
                             const double& vl,            const double& vu,          const int& il,
                             const int& iu,               const double& abstol,      int& m,
                             double w[],                  double z[],                const int& ldz,
                             double work[],               const int& lwork,          int iwork[],
                             int ifail[],                 int& info);                                             

void ssyevx_(const char& jobz,            const char& range,         const char& uplo,
                             const int& n,                float da[],                const int& lda,
                             const float& vl,             const float& vu,           const int& il,
                             const int& iu,               const float& abstol,       int& m,
                             float w[],                   float z[],                 const int& ldz,
                             float work[],                const int& lwork,          int iwork[],
                             int ifail[],                 int& info);                                             
                             
void zheevx_(const char& jobz,            const char& range,         const char& uplo,
                             const int& n,                std::complex<double> da[], const int& lda,
                             const double& vl,            const double& vu,          const int& il,
                             const int& iu,               const double& abstol,      int& m,
                             double w[],                  std::complex<double> z[],  const int& ldz,
                             std::complex<double> work[], const int& lwork,          double rwork[],
                             int iwork[],                 int ifail[],               int& info);                  

void cheevx_(const char& jobz,            const char& range,         const char& uplo,
                             const int& n,                std::complex<float> da[],  const int& lda,
                             const float& vl,             const float& vu,           const int& il,
                             const int& iu,               const float& abstol,       int& m,
                             float w[],                   std::complex<float> z[],   const int& ldz,
                             std::complex<float> work[],  const int& lwork,          float rwork[],
                             int iwork[],                 int ifail[],               int& info);                  
                             
void dsysv_(const char& uplo,             const int& n,              const int& nrhs,
                            double a[],                   const int& lda,            int ipiv[],
                            double b[],                   const int& ldb,            double work[],
                            const int& lwork,             int& info);                                             
                            
void ssysv_(const char& uplo,             const int& n,              const int& nrhs,
                            float a[],                    const int& lda,            int ipiv[],
                            float b[],                    const int& ldb,            float work[],
                            const int& lwork,             int& info);                                             
                        
void chesv_(const char& uplo,             const int& n,              const int& nrhs,
                            std::complex<float> a[],      const int& lda,            int ipiv[],
                            std::complex<float> b[],      const int& ldb,            std::complex<float> work[],
                            const int& lwork,             int& info);                                             
                            
void zhesv_(const char& uplo,             const int& n,              const int& nrhs,
                            std::complex<double> a[],     const int& lda,            int ipiv[],
                            std::complex<double> b[],     const int& ldb,            std::complex<double> work[],
                            const int& lwork,             int& info);                                             

void dsyev_(const char& jobz,            const char& uplo, const int& n,
                            double da[],                 const int& lda,   double w[],
                            double work[],               const int& lwork, int& info);                 

void ssyev_(const char& jobz,            const char& uplo, const int& n,
                            float da[],                  const int& lda,   float w[],
                            float work[],                const int& lwork, int& info);                  

void zheev_(const char& jobz,            const char& uplo, const int& n,
                            std::complex<double> da[],   const int& lda,   double w[],
                            std::complex<double> work[], const int& lwork, double rwork[], int& info); 

void cheev_(const char& jobz,            const char& uplo, const int& n,
                            std::complex<float> da[],    const int& lda,   float w[],
                            std::complex<float> work[],  const int& lwork, float rwork[],  int& info);

}
#endif
