import { Buffer, RectF, Transform, Matrix, Color, Rect, Region } from '../../src/flickerlib/common.js';
import { VISIBLE_CHIP } from '../../src/flickerlib/treeview/Chips';

const standardTransform = new Transform(0, new Matrix(1, 0, 0, 0, 1, 0));
const standardRect = new Rect(0, 0, 0, 0);
const standardColor = new Color(0, 0, 0, 1);
const standardCrop = new Rect(0, 0, -1, -1);

const expectedEmptyRegionLayer = {
  backgroundBlurRadius: 0,
  chips: [],
  cornerRadius: 0,
  effectiveScalingMode: 0,
  hwcCompositionType: "INVALID",
  id: 580,
  isOpaque: false,
  isRelativeOf: false,
  kind: "580",
  name: "SurfaceView - com.android.chrome/com.google.android.apps.chrome.Main#0",
  shadowRadius: 0,
  shortName: "SurfaceView - com.android.(...).Main#0",
  type: "BufferLayer",
  z: -1,
  zOrderRelativeOf: null,
  parentId: 579,
  activeBuffer: new Buffer(1440, 2614, 1472, 1),
  bufferTransform: standardTransform,
  color: new Color(0, 0, 0, 0.0069580078125),
  crop: standardCrop,
  hwcFrame: standardRect,
  screenBounds: new RectF(37, 43, 146, 152),
  transform: new Transform(0, new Matrix(1, 0, 37.37078094482422, 0, 1, -3.5995326042175293)),
  visibleRegion: new Region([new Rect(37, 43, 146, 152)]),
};
const emptyRegionProto = {
  2: "\nparent=0\ntype=BufferLayer\nname=Display Root#0",
  3: "\nparent=0\ntype=BufferLayer\nname=Display Overlays#0",
  4: "\nparent=2\ntype=BufferLayer\nname=mBelowAppWindowsContainers#0",
  5: "\nparent=2\ntype=BufferLayer\nname=com.android.server.wm.DisplayContent$TaskStackContainers@193aa46#0",
  6: "\nparent=5\ntype=BufferLayer\nname=animationLayer#0",
  7: "\nparent=5\ntype=BufferLayer\nname=splitScreenDividerAnchor#0",
  8: "\nparent=2\ntype=BufferLayer\nname=mAboveAppWindowsContainers#0",
  9: "\nparent=2\ntype=BufferLayer\nname=mImeWindowsContainers#0",
  10: "\nparent=5\ntype=BufferLayer\nname=Stack=0#0",
  11: "\nparent=10\ntype=ColorLayer\nname=animation background stackId=0#0",
  12: "\nparent=9\ntype=BufferLayer\nname=WindowToken{f81e7fc android.os.Binder@7c880ef}#0",
  13: "\nparent=4\ntype=BufferLayer\nname=WallpaperWindowToken{3756850 token=android.os.Binder@25b3e13}#0",
  18: "\nparent=13\ntype=BufferLayer\nname=fd46a8e com.breel.wallpapers.dioramas.lagos.LagosWallpaperService#0",
  19: "\nparent=18\ntype=BufferLayer\nname=com.breel.wallpapers.dioramas.lagos.LagosWallpaperService#0",
  20: "\nparent=8\ntype=BufferLayer\nname=WindowToken{fc1aa98 android.os.BinderProxy@3517c7b}#0",
  21: "\nparent=20\ntype=BufferLayer\nname=10022f1 DockedStackDivider#0",
  22: "\nparent=8\ntype=BufferLayer\nname=WindowToken{49a6772 android.os.BinderProxy@7ba1c7d}#0",
  23: "\nparent=22\ntype=BufferLayer\nname=56ef7c3 AssistPreviewPanel#0",
  24: "\nparent=8\ntype=BufferLayer\nname=WindowToken{35f7d5c android.os.BinderProxy@8b38fcf}#0",
  25: "\nparent=24\ntype=BufferLayer\nname=9029865 NavigationBar#0",
  26: "\nparent=8\ntype=BufferLayer\nname=WindowToken{a9a69ab android.os.BinderProxy@f64ffa}#0",
  27: "\nparent=26\ntype=BufferLayer\nname=5334808 StatusBar#0",
  28: "\nparent=8\ntype=BufferLayer\nname=WindowToken{a63ca37 android.os.BinderProxy@435eb36}#0",
  29: "\nparent=28\ntype=BufferLayer\nname=1a40ba4 ScreenDecorOverlay#0",
  30: "\nparent=8\ntype=BufferLayer\nname=WindowToken{4ed84c2 android.os.BinderProxy@33d1d0d}#0",
  31: "\nparent=30\ntype=BufferLayer\nname=7a0d2d3 ScreenDecorOverlayBottom#0",
  32: "\nparent=25\ntype=BufferLayer\nname=NavigationBar#0",
  33: "\nparent=27\ntype=BufferLayer\nname=StatusBar#0",
  34: "\nparent=29\ntype=BufferLayer\nname=ScreenDecorOverlay#0",
  35: "\nparent=31\ntype=BufferLayer\nname=ScreenDecorOverlayBottom#0",
  36: "\nparent=10\ntype=BufferLayer\nname=Task=239#0",
  37: "\nparent=632\ntype=BufferLayer\nname=AppWindowToken{188ce21 token=Token{824488 ActivityRecord{b0d882b u0 com.google.android.apps.nexuslauncher/.NexusLauncherActivity t239}}}#0",
  38: "\nparent=37\ntype=BufferLayer\nname=9f6e33d com.google.android.apps.nexuslauncher/com.google.android.apps.nexuslauncher.NexusLauncherActivity#0",
  44: "\nparent=37\ntype=BufferLayer\nname=81a00fc com.google.android.apps.nexuslauncher/com.google.android.apps.nexuslauncher.NexusLauncherActivity#0",
  88: "\nparent=5\ntype=BufferLayer\nname=Stack=2#0",
  89: "\nparent=88\ntype=ColorLayer\nname=animation background stackId=2#0",
  90: "\nparent=88\ntype=BufferLayer\nname=Task=241#0",
  91: "\nparent=633\ntype=BufferLayer\nname=AppWindowToken{a9f5144 token=Token{f102257 ActivityRecord{3a0fd6 u0 com.android.chrome/com.google.android.apps.chrome.Main t241}}}#0",
  96: "\nparent=91\ntype=BufferLayer\nname=87e310e com.android.chrome/com.google.android.apps.chrome.Main#0",
  574: "\nparent=8\ntype=BufferLayer\nname=WindowToken{37eed7d android.os.Binder@6e217d4}#0",
  579: "\nparent=96\ntype=BufferLayer\nname=com.android.chrome/com.google.android.apps.chrome.Main#0",
  580: "\nparent=579\ntype=BufferLayer\nname=SurfaceView - com.android.chrome/com.google.android.apps.chrome.Main#0",
  581: "\nparent=579\ntype=ColorLayer\nname=Background for -SurfaceView - com.android.chrome/com.google.android.apps.chrome.Main#0",
  583: "\nparent=44\ntype=BufferLayer\nname=com.google.android.apps.nexuslauncher/com.google.android.apps.nexuslauncher.NexusLauncherActivity#0",
  629: "\nparent=38\ntype=BufferLayer\nname=com.google.android.apps.nexuslauncher/com.google.android.apps.nexuslauncher.NexusLauncherActivity#2",
  632: "\nparent=6\ntype=BufferLayer\nname=Surface(name=AppWindowToken{188ce21 token=Token{824488 ActivityRecord{b0d882b u0 com.google.android.apps.nexuslauncher/.NexusLauncherActivity t239}}})/@0x90c9c46 - animation-leash#1",
  633: "\nparent=6\ntype=BufferLayer\nname=Surface(name=AppWindowToken{a9f5144 token=Token{f102257 ActivityRecord{3a0fd6 u0 com.android.chrome/com.google.android.apps.chrome.Main t241}}})/@0xd9b9374 - animation-leash#1"
};
const expectedEmptyRegion = {
  chips: [],
  proto: emptyRegionProto,
  hwcBlob: "",
  isVisible: true,
  kind: "entry",
  rects: [],
  shortName: "0d0h38m28s521ms",
  timestampMs: "2308521813510",
  where: "",
  name: "0d0h38m28s521ms",
  stableId: "LayerTraceEntry",
  visibleLayers: [],
};

const expectedInvalidLayerVisibilityLayer = {
  backgroundBlurRadius: 0,
  chips: [],
  cornerRadius: 0,
  effectiveScalingMode: 0,
  hwcCompositionType: "INVALID",
  id: 1536,
  isOpaque: false,
  isRelativeOf: false,
  kind: "1536",
  name: "com.google.android.apps.nexuslauncher/com.google.android.apps.nexuslauncher.NexusLauncherActivity#2",
  shadowRadius: 0,
  shortName: "com.google.(...).NexusLauncherActivity#2",
  type: "BufferLayer",
  z: 0,
  zOrderRelativeOf: null,
  parentId: 1535,
  stableId: "BufferLayer 1536 com.google.android.apps.nexuslauncher/com.google.android.apps.nexuslauncher.NexusLauncherActivity#2",
  activeBuffer: new Buffer(1440, 2880, 1472, 1),
  bufferTransform: standardTransform,
  color: new Color(-1, -1, -1, 0),
  hwcFrame: standardRect,
  transform: standardTransform,
  visibleRegion: new Region([standardRect]),
};
const invalidLayerVisibilityProto = {
  2: "\nparent=0\ntype=BufferLayer\nname=Display Root#0",
  3: "\nparent=0\ntype=BufferLayer\nname=Display Overlays#0",
  4: "\nparent=2\ntype=BufferLayer\nname=mBelowAppWindowsContainers#0",
  5: "\nparent=2\ntype=BufferLayer\nname=com.android.server.wm.DisplayContent$TaskStackContainers@4270eb4#0",
  6: "\nparent=5\ntype=BufferLayer\nname=animationLayer#0",
  7: "\nparent=5\ntype=BufferLayer\nname=boostedAnimationLayer#0",
  8: "\nparent=5\ntype=BufferLayer\nname=homeAnimationLayer#0",
  9: "\nparent=5\ntype=BufferLayer\nname=splitScreenDividerAnchor#0",
  10: "\nparent=2\ntype=BufferLayer\nname=mAboveAppWindowsContainers#0",
  11: "\nparent=2\ntype=BufferLayer\nname=mImeWindowsContainers#0",
  12: "\nparent=5\ntype=BufferLayer\nname=Stack=0#0",
  13: "\nparent=12\ntype=ColorLayer\nname=animation background stackId=0#0",
  14: "\nparent=11\ntype=BufferLayer\nname=WindowToken{268fcff android.os.Binder@6688c1e}#0",
  15: "\nparent=4\ntype=BufferLayer\nname=WallpaperWindowToken{6572e20 token=android.os.Binder@9543923}#0",
  20: "\nparent=15\ntype=BufferLayer\nname=5e2e96f com.breel.wallpapers.dioramas.lagos.LagosWallpaperService#0",
  21: "\nparent=20\ntype=BufferLayer\nname=com.breel.wallpapers.dioramas.lagos.LagosWallpaperService#0",
  26: "\nparent=10\ntype=BufferLayer\nname=WindowToken{68e3f31 android.os.BinderProxy@f018fd8}#0",
  27: "\nparent=26\ntype=BufferLayer\nname=2b80616 NavigationBar#0",
  28: "\nparent=10\ntype=BufferLayer\nname=WindowToken{4e20cae android.os.BinderProxy@9086129}#0",
  29: "\nparent=28\ntype=BufferLayer\nname=b09a4f StatusBar#0",
  30: "\nparent=3\ntype=BufferLayer\nname=WindowToken{501e3b8 android.os.BinderProxy@238661b}#0",
  31: "\nparent=30\ntype=BufferLayer\nname=d803591 ScreenDecorOverlay#0",
  32: "\nparent=3\ntype=BufferLayer\nname=WindowToken{56d48f7 android.os.BinderProxy@f0f2cf6}#0",
  33: "\nparent=32\ntype=BufferLayer\nname=1cd8364 ScreenDecorOverlayBottom#0",
  35: "\nparent=29\ntype=BufferLayer\nname=StatusBar#0",
  36: "\nparent=31\ntype=BufferLayer\nname=ScreenDecorOverlay#0",
  37: "\nparent=33\ntype=BufferLayer\nname=ScreenDecorOverlayBottom#0",
  38: "\nparent=12\ntype=BufferLayer\nname=Task=2#0",
  39: "\nparent=38\ntype=BufferLayer\nname=AppWindowToken{215b919 token=Token{104a060 ActivityRecord{7e30c63 u0 com.google.android.apps.nexuslauncher/.NexusLauncherActivity t2}}}#0",
  821: "\nparent=14\ntype=BufferLayer\nname=5c937c8 InputMethod#0",
  1078: "\nparent=10\ntype=BufferLayer\nname=WindowToken{7dc6283 android.os.BinderProxy@f83c532}#0",
  1079: "\nparent=1078\ntype=BufferLayer\nname=32c0c00 AssistPreviewPanel#0",
  1080: "\nparent=10\ntype=BufferLayer\nname=WindowToken{9f8a3df android.os.BinderProxy@825027e}#0",
  1081: "\nparent=1080\ntype=BufferLayer\nname=26d9efb DockedStackDivider#0",
  1403: "\nparent=10\ntype=BufferLayer\nname=WindowToken{dedcfff android.os.Binder@a80cb1e}#0",
  1447: "\nparent=39\ntype=BufferLayer\nname=39ca531 com.google.android.apps.nexuslauncher/com.google.android.apps.nexuslauncher.NexusLauncherActivity#0",
  1454: "\nparent=27\ntype=BufferLayer\nname=NavigationBar#0",
  1502: "\nparent=10\ntype=BufferLayer\nname=WindowToken{3ea357b android.os.Binder@6d9a90a}#0",
  1505: "\nparent=1518\ntype=BufferLayer\nname=Task=623#0",
  1506: "\nparent=1505\ntype=BufferLayer\nname=AppWindowToken{6deed44 token=Token{45cae57 ActivityRecord{7f14bd6 u0 com.android.server.wm.flicker.testapp/.SimpleActivity t623}}}#0",
  1518: "\nparent=5\ntype=BufferLayer\nname=Stack=51#0",
  1519: "\nparent=1518\ntype=ColorLayer\nname=animation background stackId=51#0",
  1521: "\nparent=1506\ntype=BufferLayer\nname=496d52e com.android.server.wm.flicker.testapp/com.android.server.wm.flicker.testapp.SimpleActivity#0",
  1534: "\nparent=1447\ntype=BufferLayer\nname=com.google.android.apps.nexuslauncher/com.google.android.apps.nexuslauncher.NexusLauncherActivity#0",
  1535: "\nparent=39\ntype=BufferLayer\nname=e280197 com.google.android.apps.nexuslauncher/com.google.android.apps.nexuslauncher.NexusLauncherActivity#0",
  1536: "\nparent=1535\ntype=BufferLayer\nname=com.google.android.apps.nexuslauncher/com.google.android.apps.nexuslauncher.NexusLauncherActivity#2",
};
const expectedInvalidLayerVisibility = {
  chips: [],
  proto: invalidLayerVisibilityProto,
  hwcBlob: "",
  isVisible: true,
  kind: "entry",
  rects: [],
  shortName: "2d22h13m17s233ms",
  timestampMs: "252797233543024",
  where: "",
  name: "2d22h13m17s233ms",
  stableId: "LayerTraceEntry",
  visibleLayers: [],
};

const expectedOrphanLayersLayer = {
  backgroundBlurRadius: 0,
  chips: [],
  cornerRadius: 0,
  effectiveScalingMode: 0,
  hwcCompositionType: "INVALID",
  id: 1012,
  isOpaque: true,
  isRelativeOf: false,
  kind: "1012",
  name: "SurfaceView - com.android.chrome/com.google.android.apps.chrome.Main#0",
  shadowRadius: 0,
  shortName: "SurfaceView - com.android.(...).Main#0",
  type: "BufferLayer",
  z: -1,
  zOrderRelativeOf: null,
  parentId: 1011,
  stableId: "BufferLayer 1012 SurfaceView - com.android.chrome/com.google.android.apps.chrome.Main#0",
  activeBuffer: new Buffer(1440, 2614, 1472, 1),
  bufferTransform: standardTransform,
  color: standardColor,
  crop: standardCrop,
  hwcFrame: standardRect,
  screenBounds: new RectF(0, 98, 1440, 2712),
  transform: new Transform(0, new Matrix(1, 0, 0, 0, 1, 98)),
  visibleRegion: new Region([new Rect(0, 98, 1440, 2712)]),
};
const expectedOrphanLayersProto = {
  2: "\nparent=0\ntype=BufferLayer\nname=Display Root#0",
  3: "\nparent=0\ntype=BufferLayer\nname=Display Overlays#0",
  4: "\nparent=2\ntype=BufferLayer\nname=mBelowAppWindowsContainers#0",
  5: "\nparent=2\ntype=BufferLayer\nname=com.android.server.wm.DisplayContent$TaskStackContainers@e7dd520#0",
  6: "\nparent=5\ntype=BufferLayer\nname=animationLayer#0",
  7: "\nparent=5\ntype=BufferLayer\nname=splitScreenDividerAnchor#0",
  8: "\nparent=2\ntype=BufferLayer\nname=mAboveAppWindowsContainers#0",
  9: "\nparent=2\ntype=BufferLayer\nname=mImeWindowsContainers#0",
  10: "\nparent=5\ntype=BufferLayer\nname=Stack=0#0",
  11: "\nparent=10\ntype=ColorLayer\nname=animation background stackId=0#0",
  12: "\nparent=9\ntype=BufferLayer\nname=WindowToken{1350b6f android.os.Binder@d1b0e4e}#0",
  13: "\nparent=4\ntype=BufferLayer\nname=WallpaperWindowToken{4537182 token=android.os.Binder@d87c4cd}#0",
  18: "\nparent=13\ntype=BufferLayer\nname=8d26107 com.breel.wallpapers.dioramas.lagos.LagosWallpaperService#0",
  19: "\nparent=18\ntype=BufferLayer\nname=com.breel.wallpapers.dioramas.lagos.LagosWallpaperService#0",
  20: "\nparent=8\ntype=BufferLayer\nname=WindowToken{fba948d android.os.BinderProxy@756b124}#0",
  21: "\nparent=20\ntype=BufferLayer\nname=dc26642 DockedStackDivider#0",
  22: "\nparent=8\ntype=BufferLayer\nname=WindowToken{45663b4 android.os.BinderProxy@5273887}#0",
  23: "\nparent=22\ntype=BufferLayer\nname=c617bdd AssistPreviewPanel#0",
  24: "\nparent=8\ntype=BufferLayer\nname=WindowToken{ef90888 android.os.BinderProxy@9d4dc2b}#0",
  25: "\nparent=24\ntype=BufferLayer\nname=1d24221 NavigationBar#0",
  26: "\nparent=8\ntype=BufferLayer\nname=WindowToken{6b1dca9 android.os.BinderProxy@a53d830}#0",
  27: "\nparent=26\ntype=BufferLayer\nname=eaca22e StatusBar#0",
  28: "\nparent=8\ntype=BufferLayer\nname=WindowToken{72e584c android.os.BinderProxy@3ba407f}#0",
  29: "\nparent=28\ntype=BufferLayer\nname=46af095 ScreenDecorOverlay#0",
  30: "\nparent=8\ntype=BufferLayer\nname=WindowToken{bc659b android.os.BinderProxy@f1405aa}#0",
  31: "\nparent=30\ntype=BufferLayer\nname=80ead38 ScreenDecorOverlayBottom#0",
  33: "\nparent=27\ntype=BufferLayer\nname=StatusBar#0",
  34: "\nparent=29\ntype=BufferLayer\nname=ScreenDecorOverlay#0",
  35: "\nparent=31\ntype=BufferLayer\nname=ScreenDecorOverlayBottom#0",
  36: "\nparent=10\ntype=BufferLayer\nname=Task=2#0",
  37: "\nparent=36\ntype=BufferLayer\nname=AppWindowToken{5162f77 token=Token{ac99d76 ActivityRecord{7749795 u0 com.google.android.apps.nexuslauncher/.NexusLauncherActivity t2}}}#0",
  38: "\nparent=37\ntype=BufferLayer\nname=2c19e73 com.google.android.apps.nexuslauncher/com.google.android.apps.nexuslauncher.NexusLauncherActivity#0",
  41: "\nparent=25\ntype=BufferLayer\nname=NavigationBar#1",
  43: "\nparent=37\ntype=BufferLayer\nname=2f0c80b com.google.android.apps.nexuslauncher/com.google.android.apps.nexuslauncher.NexusLauncherActivity#0",
  46: "\nparent=5\ntype=BufferLayer\nname=Stack=1#0",
  47: "\nparent=46\ntype=ColorLayer\nname=animation background stackId=1#0",
  48: "\nparent=46\ntype=BufferLayer\nname=Task=89#0",
  49: "\nparent=48\ntype=BufferLayer\nname=AppWindowToken{1d514da token=Token{d36fe85 ActivityRecord{e0ec0ef u0 com.android.chrome/com.google.android.apps.chrome.Main t89}}}#0",
  54: "\nparent=49\ntype=BufferLayer\nname=8ae6e06 com.android.chrome/com.google.android.apps.chrome.Main#0",
  607: "\nparent=5\ntype=BufferLayer\nname=Stack=9#0",
  608: "\nparent=607\ntype=ColorLayer\nname=animation background stackId=9#0",
  609: "\nparent=607\ntype=BufferLayer\nname=Task=97#0",
  615: "\nparent=609\ntype=BufferLayer\nname=AppWindowToken{28730c9 token=Token{4d768d0 ActivityRecord{faf093 u0 com.google.android.gm/.welcome.WelcomeTourActivity t97}}}#0",
  616: "\nparent=615\ntype=BufferLayer\nname=44e6e5c com.google.android.gm/com.google.android.gm.welcome.WelcomeTourActivity#0",
  679: "\nparent=12\ntype=BufferLayer\nname=2d0b1e4 InputMethod#0",
  993: "\nparent=8\ntype=BufferLayer\nname=WindowToken{e425e58 android.os.Binder@6d9a73b}#0",
  1011: "\nparent=54\ntype=BufferLayer\nname=com.android.chrome/com.google.android.apps.chrome.Main#0",
  1012: "\nparent=1011\ntype=BufferLayer\nname=SurfaceView - com.android.chrome/com.google.android.apps.chrome.Main#0",
  1013: "\nparent=1011\ntype=ColorLayer\nname=Background for -SurfaceView - com.android.chrome/com.google.android.apps.chrome.Main#0",
};
const expectedOrphanLayers = {
  chips: [],
  proto: expectedOrphanLayersProto,
  hwcBlob: "",
  isVisible: true,
  kind: "entry",
  rects: [],
  shortName: "3d23h30m9s820ms",
  timestampMs: "343809820196384",
  where: "",
  name: "3d23h30m9s820ms",
  stableId: "LayerTraceEntry",
  visibleLayers: [],
};

const expectedRootLayer = {
  backgroundBlurRadius: 0,
  cornerRadius: 0,
  effectiveScalingMode: 0,
  hwcCompositionType: "INVALID",
  id: 12545,
  isOpaque: true,
  isRelativeOf: false,
  kind: "12545",
  name: "com.android.server.wm.flicker.testapp/com.android.server.wm.flicker.testapp.SimpleActivity#0",
  shadowRadius: 0,
  shortName: "com.android.(...).SimpleActivity#0",
  type: "BufferQueueLayer",
  z: 0,
  zOrderRelativeOf: null,
  parentId: 12541,
  stableId: "BufferQueueLayer 12545 com.android.server.wm.flicker.testapp/com.android.server.wm.flicker.testapp.SimpleActivity#0",
  activeBuffer: new Buffer(1440, 2960, 1472, 1),
  chips: [VISIBLE_CHIP],
  bufferTransform: standardTransform,
  color: standardColor,
  crop: new Rect(0, 0, 1440, 2960),
  hwcFrame: standardRect,
  screenBounds: new RectF(0, 0, 1440, 2960),
  sourceBounds: new RectF(0, 0, 1440, 2960),
  transform: standardTransform,
  visibleRegion: new Region([new Rect(0, 0, 1440, 2960)]),
};
const expectedRootProto = {
  2: "\nparent=-1\ntype=ContainerLayer\nname=Root#0",
  3: "\nparent=2\ntype=ContainerLayer\nname=mWindowContainers#0",
  4: "\nparent=2\ntype=ContainerLayer\nname=mOverlayContainers#0",
  5: "\nparent=3\ntype=ContainerLayer\nname=mBelowAppWindowsContainers#0",
  6: "\nparent=3\ntype=ContainerLayer\nname=com.android.server.wm.DisplayContent$TaskContainers@708b672#0",
  7: "\nparent=6\ntype=ContainerLayer\nname=animationLayer#0",
  8: "\nparent=6\ntype=ContainerLayer\nname=boostedAnimationLayer#0",
  9: "\nparent=6\ntype=ContainerLayer\nname=homeAnimationLayer#0",
  10: "\nparent=6\ntype=ContainerLayer\nname=splitScreenDividerAnchor#0",
  11: "\nparent=3\ntype=ContainerLayer\nname=mAboveAppWindowsContainers#0",
  12: "\nparent=3\ntype=ContainerLayer\nname=ImeContainer#0",
  13: "\nparent=6\ntype=ContainerLayer\nname=Task=1#0",
  18: "\nparent=5\ntype=ContainerLayer\nname=WallpaperWindowToken{4c3f8ef token=android.os.Binder@a0341ce}#0",
  19: "\nparent=18\ntype=ContainerLayer\nname=aa9ba7e com.breel.wallpapers18.soundviz.wallpaper.variations.SoundVizWallpaperV2#0",
  20: "\nparent=19\ntype=BufferQueueLayer\nname=com.breel.wallpapers18.soundviz.wallpaper.variations.SoundVizWallpaperV2#0",
  23: "\nparent=11\ntype=ContainerLayer\nname=WindowToken{2e98b86 android.os.BinderProxy@6e5dbc8}#0",
  24: "\nparent=23\ntype=ContainerLayer\nname=5976c47 NavigationBar0#0",
  25: "\nparent=11\ntype=ContainerLayer\nname=WindowToken{525aa4 android.os.BinderProxy@df1e236}#0",
  26: "\nparent=25\ntype=ContainerLayer\nname=986c00d NotificationShade#0",
  27: "\nparent=11\ntype=ContainerLayer\nname=WindowToken{7ec5009 android.os.BinderProxy@de2add3}#0",
  28: "\nparent=27\ntype=ContainerLayer\nname=3a0542f StatusBar#0",
  31: "\nparent=-1\ntype=ContainerLayer\nname=WindowToken{eef604c android.os.BinderProxy@d3a687f}#0",
  32: "\nparent=31\ntype=ContainerLayer\nname=20b5895 ScreenDecorOverlay#0",
  33: "\nparent=-1\ntype=ContainerLayer\nname=WindowToken{4846f6f android.os.BinderProxy@39824e}#0",
  34: "\nparent=33\ntype=ContainerLayer\nname=1d714 ScreenDecorOverlayBottom#0",
  36: "\nparent=32\ntype=BufferQueueLayer\nname=ScreenDecorOverlay#0",
  38: "\nparent=34\ntype=BufferQueueLayer\nname=ScreenDecorOverlayBottom#0",
  40: "\nparent=28\ntype=BufferQueueLayer\nname=StatusBar#0",
  43: "\nparent=12\ntype=ContainerLayer\nname=WindowToken{fa12db9 android.os.Binder@4b88380}#0",
  46: "\nparent=13\ntype=ContainerLayer\nname=Task=4#0",
  47: "\nparent=46\ntype=ContainerLayer\nname=ActivityRecord{99bbfb0 u0 com.google.android.apps.nexuslauncher/.NexusLauncherActivity#0",
  54: "\nparent=24\ntype=BufferQueueLayer\nname=NavigationBar0#0",
  71: "\nparent=43\ntype=ContainerLayer\nname=e8f94d2 InputMethod#0",
  11499: "\nparent=47\ntype=ContainerLayer\nname=6737b79 com.google.android.apps.nexuslauncher/com.google.android.apps.nexuslauncher.NexusLauncherActivity#0",
  11501: "\nparent=-1\ntype=ContainerLayer\nname=Input Consumer recents_animation_input_consumer#2",
  11759: "\nparent=6\ntype=ContainerLayer\nname=Task=873#0",
  11760: "\nparent=11759\ntype=ContainerLayer\nname=Task=874#0",
  11761: "\nparent=11760\ntype=ContainerLayer\nname=ActivityRecord{7398002 u0 com.android.server.wm.flicker.testapp/.ImeActivityAutoFocus#0",
  11785: "\nparent=11761\ntype=ColorLayer\nname=Letterbox - right#0",
  12131: "\nparent=11\ntype=ContainerLayer\nname=WindowToken{bbffcfd android.os.Binder@547b554}#0",
  12379: "\nparent=47\ntype=ContainerLayer\nname=3f8f098 com.google.android.apps.nexuslauncher/com.google.android.apps.nexuslauncher.NexusLauncherActivity#0",
  12412: "\nparent=11761\ntype=ContainerLayer\nname=edca7c6 com.android.server.wm.flicker.testapp/com.android.server.wm.flicker.testapp.ImeActivityAutoFocus#0",
  12448: "\nparent=2147483645\ntype=ContainerLayer\nname=Surface(name=ActivityRecord{99bbfb0 u0 com.google.android.apps.nexuslauncher/.NexusLauncherActivity)/@0x2c3972c - animation-leash#0",
  12449: "\nparent=2147483645\ntype=ContainerLayer\nname=Surface(name=ActivityRecord{fc16c94 u0 com.android.server.wm.flicker.testapp/.ImeActivity)/@0x7049863 - animation-leash#0",
  12485: "\nparent=6\ntype=ContainerLayer\nname=Task=908#0",
  12486: "\nparent=12485\ntype=ContainerLayer\nname=Task=909#0",
  12487: "\nparent=12486\ntype=ContainerLayer\nname=ActivityRecord{4b3c5cb u0 com.android.server.wm.flicker.testapp/.ImeActivity#0",
  12500: "\nparent=2147483645\ntype=ContainerLayer\nname=Surface(name=ActivityRecord{99bbfb0 u0 com.google.android.apps.nexuslauncher/.NexusLauncherActivity)/@0x2c3972c - animation-leash#0",
  12501: "\nparent=2147483645\ntype=ContainerLayer\nname=Surface(name=ActivityRecord{4b3c5cb u0 com.android.server.wm.flicker.testapp/.ImeActivity)/@0x4ad47a1 - animation-leash#0",
  12502: "\nparent=2147483645\ntype=ContainerLayer\nname=Surface(name=WallpaperWindowToken{4c3f8ef token=android.os.Binder@a0341ce})/@0xcde5e65 - animation-leash#0",
  12511: "\nparent=12487\ntype=ColorLayer\nname=Letterbox - right#1",
  12514: "\nparent=12487\ntype=ContainerLayer\nname=debe1ed com.android.server.wm.flicker.testapp/com.android.server.wm.flicker.testapp.ImeActivity#0",
  12526: "\nparent=11\ntype=ContainerLayer\nname=WindowToken{6b7d663 android.os.BinderProxy@391f21d}#0",
  12527: "\nparent=12526\ntype=ContainerLayer\nname=32aa260 AssistPreviewPanel#0",
  12529: "\nparent=11\ntype=ContainerLayer\nname=WindowToken{31f7489 android.os.BinderProxy@67b1e53}#0",
  12530: "\nparent=12529\ntype=ContainerLayer\nname=cbb28bc DockedStackDivider#0",
  12536: "\nparent=6\ntype=ContainerLayer\nname=Task=910#0",
  12537: "\nparent=12536\ntype=ContainerLayer\nname=Task=911#0",
  12538: "\nparent=12537\ntype=ContainerLayer\nname=ActivityRecord{d3b8a44 u0 com.android.server.wm.flicker.testapp/.SimpleActivity#0",
  12541: "\nparent=12538\ntype=ContainerLayer\nname=a3583c5 com.android.server.wm.flicker.testapp/com.android.server.wm.flicker.testapp.SimpleActivity#0",
  12545: "\nparent=12541\ntype=BufferQueueLayer\nname=com.android.server.wm.flicker.testapp/com.android.server.wm.flicker.testapp.SimpleActivity#0",
  2147483645: "\nparent=-1\ntype=\nname=Offscreen Root",
};
const expectedRoot = {
  chips: [],
  proto: expectedRootProto,
  hwcBlob: "",
  isVisible: true,
  kind: "entry",
  shortName: "0d1h46m19s146ms",
  timestampMs: "6379146308030",
  where: "",
  name: "0d1h46m19s146ms",
  stableId: "LayerTraceEntry",
};

const expectedRootAospLayer = {
  backgroundBlurRadius: 0,
  cornerRadius: 0,
  effectiveScalingMode: 0,
  hwcCompositionType: "INVALID",
  id: 876,
  isOpaque: false,
  isRelativeOf: false,
  kind: "876",
  name: "com.android.launcher3/com.android.launcher3.Launcher#0",
  shadowRadius: 0,
  shortName: "com.android.(...).Launcher#0",
  type: "BufferLayer",
  z: 0,
  zOrderRelativeOf: null,
  parentId: 41,
  activeBuffer: new Buffer(1440, 2880, 1472, 1),
  bufferTransform: standardTransform,
  chips: [VISIBLE_CHIP],
  color: standardColor,
  crop: new Rect(0, 0, 1440, 2880),
  hwcFrame: standardRect,
  screenBounds: new RectF(0, 0, 1440, 2880),
  sourceBounds: new RectF(0, 0, 1440, 2880),
  transform: standardTransform,
  visibleRegion: new Region([new Rect(0, 0, 1440, 2880)]),
};
const expectedRootAospProto = {
  2: "\nparent=-1\ntype=ContainerLayer\nname=Display Root#0",
  3: "\nparent=-1\ntype=ContainerLayer\nname=Display Overlays#0",
  4: "\nparent=2\ntype=ContainerLayer\nname=mBelowAppWindowsContainers#0",
  5: "\nparent=2\ntype=ContainerLayer\nname=com.android.server.wm.DisplayContent$TaskStackContainers@d8077b3#0",
  6: "\nparent=5\ntype=ContainerLayer\nname=animationLayer#0",
  7: "\nparent=5\ntype=ContainerLayer\nname=boostedAnimationLayer#0",
  8: "\nparent=5\ntype=ContainerLayer\nname=homeAnimationLayer#0",
  9: "\nparent=5\ntype=ContainerLayer\nname=splitScreenDividerAnchor#0",
  10: "\nparent=2\ntype=ContainerLayer\nname=mAboveAppWindowsContainers#0",
  11: "\nparent=2\ntype=ContainerLayer\nname=mImeWindowsContainers#0",
  12: "\nparent=5\ntype=ContainerLayer\nname=Stack=0#0",
  13: "\nparent=12\ntype=ColorLayer\nname=animation background stackId=0#0",
  18: "\nparent=4\ntype=ContainerLayer\nname=WallpaperWindowToken{5a7eaca token=android.os.Binder@438b635}#0",
  23: "\nparent=10\ntype=ContainerLayer\nname=WindowToken{d19e48 android.os.BinderProxy@560ac3a}#0",
  24: "\nparent=23\ntype=ContainerLayer\nname=b2a84e1 NavigationBar0#0",
  25: "\nparent=10\ntype=ContainerLayer\nname=WindowToken{74d6851 android.os.BinderProxy@8b22adb}#0",
  26: "\nparent=25\ntype=ContainerLayer\nname=16448b6 StatusBar#0",
  27: "\nparent=-1\ntype=ContainerLayer\nname=WindowToken{624863c android.os.BinderProxy@975b02f}#0",
  28: "\nparent=27\ntype=ContainerLayer\nname=cdb9fc5 ScreenDecorOverlay#0",
  29: "\nparent=-1\ntype=ContainerLayer\nname=WindowToken{cb7204b android.os.BinderProxy@b8f3d1a}#0",
  30: "\nparent=29\ntype=ContainerLayer\nname=ad1ca28 ScreenDecorOverlayBottom#0",
  31: "\nparent=28\ntype=BufferLayer\nname=ScreenDecorOverlay#0",
  32: "\nparent=30\ntype=BufferLayer\nname=ScreenDecorOverlayBottom#0",
  33: "\nparent=18\ntype=ContainerLayer\nname=4f4b23b com.android.systemui.ImageWallpaper#0",
  34: "\nparent=33\ntype=BufferLayer\nname=com.android.systemui.ImageWallpaper#0",
  36: "\nparent=26\ntype=BufferLayer\nname=StatusBar#0",
  37: "\nparent=12\ntype=ContainerLayer\nname=Task=144#0",
  38: "\nparent=37\ntype=ContainerLayer\nname=AppWindowToken{54e2de0 token=Token{f4c5fe3 ActivityRecord{6a9dc12 u0 com.android.launcher3/.Launcher t144}}}#0",
  40: "\nparent=-1\ntype=ContainerLayer\nname=Input Consumer recents_animation_input_consumer#1",
  41: "\nparent=38\ntype=ContainerLayer\nname=418b5c0 com.android.launcher3/com.android.launcher3.Launcher#0",
  45: "\nparent=11\ntype=ContainerLayer\nname=WindowToken{9158878 android.os.Binder@4f4a5db}#0",
  46: "\nparent=24\ntype=BufferLayer\nname=NavigationBar0#0",
  731: "\nparent=10\ntype=ContainerLayer\nname=WindowToken{c0ebbde android.os.BinderProxy@1af0e60}#0",
  732: "\nparent=731\ntype=ContainerLayer\nname=b37d1bf AssistPreviewPanel#0",
  733: "\nparent=10\ntype=ContainerLayer\nname=WindowToken{dc6b7ea android.os.BinderProxy@166b08c}#0",
  734: "\nparent=733\ntype=ContainerLayer\nname=2a1cadb DockedStackDivider#0",
  862: "\nparent=10\ntype=ContainerLayer\nname=WindowToken{f63efe6 android.os.Binder@d536e41}#0",
  865: "\nparent=887\ntype=ContainerLayer\nname=Task=170#0",
  866: "\nparent=865\ntype=ContainerLayer\nname=AppWindowToken{c829d40 token=Token{59970c3 ActivityRecord{36f2472 u0 com.android.server.wm.flicker.testapp/.PipActivity t170}}}#0",
  871: "\nparent=866\ntype=ContainerLayer\nname=8153ff7 com.android.server.wm.flicker.testapp/com.android.server.wm.flicker.testapp.PipActivity#0",
  876: "\nparent=41\ntype=BufferLayer\nname=com.android.launcher3/com.android.launcher3.Launcher#0",
  887: "\nparent=5\ntype=ContainerLayer\nname=Stack=78#0",
  888: "\nparent=887\ntype=ColorLayer\nname=animation background stackId=78#0",
};
const expectedRootAosp = {
  chips: [],
  proto: expectedRootAospProto,
  hwcBlob: "",
  isVisible: true,
  kind: "entry",
  shortName: "0d1h3m1s911ms",
  timestampMs: "3781911657318",
  where: "",
  name: "0d1h3m1s911ms",
  stableId: "LayerTraceEntry",
};

const expectedEntries = [
  expectedEmptyRegion,
  expectedInvalidLayerVisibility,
  expectedOrphanLayers,
  expectedRoot,
  expectedRootAosp
];
const expectedLayers = [
  expectedEmptyRegionLayer,
  expectedInvalidLayerVisibilityLayer,
  expectedOrphanLayersLayer,
  expectedRootLayer,
  expectedRootAospLayer
];
const layers_traces = [
  '../spec/traces/layers_trace/layers_trace_emptyregion.pb',
  '../spec/traces/layers_trace/layers_trace_invalid_layer_visibility.pb',
  '../spec/traces/layers_trace/layers_trace_orphanlayers.pb',
  '../spec/traces/layers_trace/layers_trace_root.pb',
  '../spec/traces/layers_trace/layers_trace_root_aosp.pb',
];

export { expectedEntries, expectedLayers, layers_traces };
