# distribution-name.sh: revision name -> distribution name
# 
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

command_line="$*"

################################################################
# special options
# 
# Some options are special:
# 
#       --version | -V
#       --help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
                printf "revision name -> distribution name\\n"
                printf "usage: distribution-name [options] revision"
                printf "\\n"
                printf " -V --version                  print version info\\n"
                printf " -h --help                     display help\\n"
		printf "\\n"
		printf " --dist NAME                   use name, rather than the branch\\n"
		printf "                               name of REVISION for the generic name\\n"
		printf "                               of the distribution.\\n"
		printf "\\n"
		printf "Print the distribution name corresponding to REVISION.\\n"
                printf "\\n"
                printf "	revision:			distribution:\\n"
                printf "\\n"
                printf "	arch--1.0--base-0		arch-1.0pre0\\n"
                printf "	arch--1.0--patch-3		arch-1.0pre3\\n"
                printf "	arch--1.0--version-0		arch-1.0\\n"
                printf "	arch--1.0--versionfix-5		arch-1.0.5\\n"
                printf "\\n"
                printf "The top-level directory in the tar file has the same name as the tar\\n"
                printf "file (but without the \".tar.gz\" suffix).\\n"
                printf "\\n"
                exit 0
                ;;

      *)
                ;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

dist=

while test $# -ne 0 ; do

  case "$1" in 

    --dist)		shift
			if test $# -eq 0 ; then
			  printf "distribution-name: --dist requires an argument\\n" 1>&2
			  printf "try --help\\n"
			  exit 1
			fi
			dist="$1"
			shift
			;;

    --)			shift
    			break
			;;

    -*)                 printf "distribution-name: unrecognized option (%s)\\n" "$1" 1>&2
                        printf "try --help\\n" 1>&2
                        exit 1
                        ;;

    *)                  break
                        ;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 1 ; then
  printf "usage: distribution-name [options] revision\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

rev_spec="$1"
shift

################################################################
# Sanity Check and Process Defaults
# 
  
larch valid-package-name -e distribution-name --lvl "$rev_spec"

if test -z "$dist" ; then
  dist="`larch parse-package-name \"$rev_spec\"`"
fi

vsn="`larch parse-package-name --vsn \"$rev_spec\"`"
lvl="`larch parse-package-name --lvl \"$rev_spec\"`"


################################################################
# Print the Distribution Name
# 

case "$lvl" in

  base-0)	suffix=pre0
		;;

  patch-*)	suffix=pre${lvl#*-}
		;;

  version-0)	suffix=
		;;

  versionfix-*)	suffix=".${lvl#*-}"
		;;

  *)		printf "distribution-name: internal error!\\n" 1>&2
  		printf "  odd patch level: %s\\n" "$revision" 1>&2
		exit 1
esac


printf "%s-%s%s\n" "$dist" "$vsn" "$suffix"
  
# tag: Tom Lord Sat Jan 26 18:30:45 2002 (web/distribution-suffix.sh)
#
