#include <glib.h>

#include <asdutil.h>
#include "io.h"
#include "asderrno.h"

gboolean asd_read(int sock, void*p, guint32 l)
{
  g_assert((sock >= 0) && p && (l > 0));

  if (atomic_read(sock, p, l) != l)
    {
      asd_set_errno(PROTOCOL_ASD_LOCAL_ERROR_SYSTEM);
      return FALSE;
    }

  return TRUE;
}

gboolean asd_write(int sock, void *p, guint32 l)
{
  g_assert((sock >= 0) && p && (l > 0));

  if (atomic_write(sock, p, l) != l)
    {
      asd_set_errno(PROTOCOL_ASD_LOCAL_ERROR_SYSTEM);
      return FALSE;
    }

  return TRUE;
}

gboolean asd_write_request(int fd, guint16 id, guint16 c, guint32 l)
{
  ProtocolAsdRequest req;
  g_assert(fd >= 0);

  req.id = GUINT16_TO_LE(id);
  req.version = PROTOCOL_ASD_VERSION;
  req.command = GUINT16_TO_LE(c);
  req.length = GUINT32_TO_LE(l);
  return asd_write(fd, &req, sizeof(req));
}

gboolean asd_read_ack(int fd, guint16 id, guint32 l)
{
  ProtocolAsdRequest req;
  g_assert(fd >= 0);

  if (!asd_read(fd, &req, sizeof(req)))
    return FALSE;
  
  if (!((GUINT16_FROM_LE(req.id) == id) && (req.version == PROTOCOL_ASD_VERSION)))
    {
      asd_set_errno(PROTOCOL_ASD_LOCAL_ERROR_PROTOCOL_CORRUPT);
      return FALSE;
    }

  if (GUINT16_FROM_LE(req.command) == PROTOCOL_ASD_COMMAND_ACKNOWLEDGE)
    {
      if (GUINT32_FROM_LE(req.length) == l)
	return TRUE;
      else 
	{
	  asd_set_errno(PROTOCOL_ASD_LOCAL_ERROR_PROTOCOL_CORRUPT);
	  return FALSE;
	}
    }
      
  asd_set_errno(PROTOCOL_ASD_LOCAL_ERROR_PROTOCOL_CORRUPT);
			
  if (GUINT16_FROM_LE(req.command) == PROTOCOL_ASD_COMMAND_ERROR)
    {
      ProtocolAsdError err;
      if (asd_read(fd, &err, sizeof(err)))
	asd_set_errno(GUINT16_FROM_LE(err.error));
    }

  return FALSE;
}
