#ifndef asddefh
#define asddefh

#define ASD_CHANNELS_MAX 16

#define ASD_NAME_LENGTH 120
#define ASD_SHORTNAME_LENGTH 12
#define ASD_TYPE_LENGTH 20

#define ASD_MIX_BLOCKS_MAX 32
#define ASD_THROUGHPUT_VALUES_MAX 5

#define ASD_PROTOCOL_HTTP_INET_PORT 4568

#define ASD_DEFAULT_PLAY_SINK "play0"
#define ASD_DEFAULT_CAPTURE_SOURCE "capt0"


typedef enum {SOURCE_DISABLED, SOURCE_RUNNING, SOURCE_PAUSED, SOURCE_DIRECT} SourceMode;

#define SOURCE_AUTOCLEAN 1          // Automatically remove conjunctions after thread end?
#define SOURCE_PUSH_WAIT 2          // Always wait until all data is written to the block-queues
#define SOURCE_IMMEDIATE_STOP 4     // Empty block-queue on connection loss? (Otherwise wait for block queue empty)
#define SOURCE_DIRECT_SUPPORTED 8   // We support direct mode

typedef enum {SINK_DISABLED, SINK_RUNNING, SINK_PAUSED, SINK_DIRECT} SinkMode;

#define SINK_AUTOCLEAN 1          // Automatically remove conjunctions after thread end
#define SINK_DIRECT_SUPPORTED 8   // We support direct mode

#endif
