#include <stdio.h>
#include <glib.h>

#include "asdutil.h"


void g_mutex_unlock_cleanup_handler(void* m)
{
  g_mutex_unlock((GMutex*) m);
}

/* void g_static_mutex_unlock_cleanup_handler(void* m) */
/* { */
/*   g_static_mutex_unlock((GStaticMutex*) m); */
/* } */

void fd_cleanup_handler(void* f) 
{
 close(*((int*) f)); 
} 

 ssize_t atomic_read (int FILEDES, void *BUFFER, size_t SIZE)
{
  ssize_t i, r;
  char *p = (char*) BUFFER;

  g_assert((FILEDES >= 0) && BUFFER && (SIZE > 0));
  
  i = 0;
  while (i < SIZE)
    {
      r = read(FILEDES, p, SIZE-i);
      if (r < 0)
	return r;

      if (r == 0)
	return i;

      i+=r;
      p+=r;
    }

  return SIZE;
}

ssize_t atomic_write(int FILEDES, const void *BUFFER, size_t SIZE)
{  
  ssize_t i, r;
  char *p = (char*) BUFFER;

  g_assert((FILEDES >= 0) && BUFFER && (SIZE > 0));
  
  i = 0;
  while (i < SIZE)
    {
      r = write(FILEDES, p, SIZE-i);
      if (r < 0)
	return r;

      if (r == 0)
	return i;

      i+=r;
      p+=r;
    }

  return SIZE;
}


gboolean passthrough(int sock)
{
  gchar buf[1024];

  for (;;)
    {
      ssize_t l = read(sock, buf, sizeof(buf));
      if (l < 0) return FALSE;
      if (l == 0) return TRUE;

      if (atomic_write(1, buf, l) != l)
	return FALSE;
    }
}
