#include <string.h>
#include <stdlib.h>

#include "volume.h"

#define VOLUME_FROM_LR(l,r) ((guint8) MAX((guint8)l, (guint8)r))
#define BALANCE_FROM_LR(l,r) ((gint8) (ASD_VOLUME_FROM_LR(l,r) == 0 ? 0 : \
                                           ( ((l>r) ? -1 : 1) * (gint)abs((gint)l-(gint)r) * 127 / ((gint)ASD_VOLUME_FROM_LR(l,r)) )))
#define LEFT_FROM_VB(v,b) ((guint8) ((b) <= 0 ? (v) : (gint)(v)*(127-(gint)abs(b))/127))
#define RIGHT_FROM_VB(v,b) ((guint8) ((b) >= 0 ? (v) : (gint)(v)*(127-(gint)abs(b))/127))

void volume_mute(Volume *v)
{
  g_assert(v);
  memset(v, 0, sizeof(Volume));
}

void volume_max(Volume *v)
{
  g_assert(v);
  memset(v, 0xFF, sizeof(Volume));
}

gboolean volume_is_muted(Volume *v)
{
  guint i;
  g_assert(v);

  for (i = 0; i < ASD_CHANNELS_MAX; i++)
    if (v->factor[i] != 0)
      return FALSE;

  return TRUE;
}

gboolean volume_is_max(Volume *v)
{
  guint i;
  g_assert(v);

  for (i = 0; i < ASD_CHANNELS_MAX; i++)
    if (v->factor[i] != 0xFFFF)
      return FALSE;

  return TRUE;
}

void volume_from_vb(Volume *v, guint32 volume, gint32 balance)
{
  g_assert(v);

  volume_mute(v);
  v->factor[0] = LEFT_FROM_VB(volume, balance);
  v->factor[1] = RIGHT_FROM_VB(volume, balance);
}

void volume_from_lr(Volume *v, guint32 l, guint32 r)
{
  g_assert(v);

  volume_mute(v);
  v->factor[0] = l;
  v->factor[1] = r;
}

void volume_from_le(Volume *v)
{
  guint i;
  g_assert(v);
  for (i = 0; i < ASD_CHANNELS_MAX; i++)
    v->factor[i] = GUINT16_FROM_LE(v->factor[i]);
}

void volume_to_le(Volume *v)
{
  guint i;
  g_assert(v);
  for (i = 0; i < ASD_CHANNELS_MAX; i++)
    v->factor[i] = GUINT16_FROM_LE(v->factor[i]);
}

void volume_parse(Volume *vol, gchar *p)
{
  gchar *b = p, *e;
  guint i = 0;
  guint16 r;

  g_assert(p && vol);

  while ((e = strchr(b, ',')))
    {
      *e = 0;
      
      vol->factor[i++] = atoi(b);
      
      b = e+1;
    }

  r = atoi(b);
  
  while (i < ASD_CHANNELS_MAX)
    vol->factor[i++] = r;
}

void volume_to_string(Volume *vol, gchar *s, guint l)
{
  gchar *c;
  guint i, r, f;
  g_assert(vol && s && l);

  g_snprintf(s, l, "%i,%i", vol->factor[0], vol->factor[1]);
  c = strchr(s, 0);
  l -= strlen(s);

  f = vol->factor[ASD_CHANNELS_MAX-1];
  for (r = ASD_CHANNELS_MAX-2; r >= 1; r--)
    if (f != vol->factor[r])
      break;

  for (i = 2; i <= r+1; i++)
    {
      g_snprintf(c, l, ",%i", vol->factor[i]);
      
      if (!*c) return;
      
      l -= strlen(c);
      c = strchr(c, 0);
    }

  //  g_snprintf(c, l, ",...");
}
