#ifndef latencyh
#define latencyh

#include <glib.h>

#include <origin.h>

typedef struct {
  GTimeVal tv[ORIGIN_MAX];
} Latency;

typedef struct {
  guint32 msec[ORIGIN_MAX];
  guint instance[ORIGIN_MAX];
} LatencyBank;

#include <block.h>

void latency_reset(Latency *l);
void latency_set(Latency *l, OriginId id);
void latency_merge(Latency *a, Latency *b);

void latency_bank_reset(LatencyBank *b);
void latency_bank_process(LatencyBank *b, Block*block);
guint32 latency_bank_get(LatencyBank *b, OriginId id);

void latency_global_process(Block *b);
guint32 latency_global_get(OriginId id);
guint32 latency_global_average();

#endif
