#ifndef sinkdefaulth
#define sinkdefaulth

#include <glib.h>

#include "sink.h"

typedef struct
{
  gchar* filename;
  gboolean is_open;
  int fd;
  guchar *buffer;
  gulong buffer_size;
  gboolean error;
} SinkDefaultPrivate;

SinkDefaultPrivate* sink_default_alloc_private(gchar *name);

gboolean sink_default_open_impl(Sink *s);
void sink_default_close_impl(Sink *s);
void sink_default_flush_impl(Sink *s);
gboolean sink_default_reopen_impl(Sink *s);
glong sink_default_write_impl(Sink *s, guchar*p, gulong l);
gboolean sink_default_write_block_impl(Sink *s, Block *b);
void sink_default_free_private_impl(Sink *s);
void sink_default_save_private_impl(Sink *s, xmlNodePtr node);

#endif
