/* menufunc.h: menu functions
 *
 * Copyright (C) 1995-97 Roman Hodek <Roman.Hodek@informatik.uni-erlangen.de>
 *               1996-97 Michael Schlueter <schlue00@marvin.informatik.uni-dortmund.de>
 *
 * This program is free software.  You can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation: either version 2 or
 * (at your option) any later version.
 *
 */

#ifndef _menufuncs_h
#define _menufuncs_h

/* $Id: menufuncs.h,v 1.8 1998/09/19 01:29:11 rnhodek Exp $
 *
 * $Log: menufuncs.h,v $
 * Revision 1.8  1998/09/19 01:29:11  rnhodek
 * New clear_partitions() function.
 *
 * Revision 1.7  1997/07/10 20:36:37  rnhodek
 * New menu function move_partition_ars().
 * Fixed some minor bugs.
 *
 * Revision 1.6  1997/07/08 18:59:04  rnhodek
 * Ouch, too many changes without commits in between...
 * Implemented moving of partitions
 * Implemented checking of "extended start condition" (great changes in
 *   new_partition())
 * Some more tests in verify()
 *
 * Revision 1.5  1997/06/21 20:47:46  rnhodek
 * Added RCS keywords
 *
 * Revision 1.4  1997/06/13 10:18:45  rnhodek
 * Implemented settings bootflags on XGM part.
 * allow write command if opened read-only and ALPHA_VERSION; actual writing
 * 	 skipped in swrite
 * nicer output of list_table
 * 
 * Revision 1.3  1997/06/12 13:43:39  rnhodek
 * Fix many small bugs here and there. The ones you find when first running a
 * program...
 * 
 * Revision 1.2  1997/06/11 14:41:58  rnhodek
 * Added 'b' and 'f' menu items
 * 
 * Revision 1.1  1997/06/11 14:36:36  rnhodek
 * Initial revision
 * 
 * Revision 1.1.1.1  1997/06/11 14:36:36  rnhodek
 * Started using CVS for atafdisk
 *
 */

/***************************** Prototypes *****************************/

void set_bootable( void );
void bad_sector_list( void );
void change_partition_size( int i );
void clear_partitions( void );
void delete_partition( int i );
void convert_partition( int i );
void select_xfmt( void );
void change_contents_flag( int i );
void new_partition( void );
void move_partition( int i );
void move_partition_ars( int i );
void list_table( void );
void change_partid( int i );
void select_options( void );
void parse_options( char *options );
void verify( void);
void write_table( void);

/************************* End of Prototypes **************************/

#endif  /* _menufuncs_h */
