// This file may be redistributed and modified only under the terms of
// the GNU Lesser General Public License (See COPYING for details).
// Copyright (C) 2000-2001 Michael Day

#ifndef ATLAS_NEGOTIATE_H
#define ATLAS_NEGOTIATE_H

#include <Atlas/Task.h>

namespace Atlas {

template <class Stream>
class Codec;

/** Negotiation of codecs and filters for an Atlas connection

non blocking negotiation of Codecs
requires a list of avalable Codecs,
along with the name of sender and a Socket

@see Connection
@see Codec
*/

template <typename Stream>
class Negotiate : public Task
{
    public:

    enum State
    {
	IN_PROGRESS,
	SUCCEEDED,
	FAILED,
    };

    virtual State getState() = 0;
    virtual Codec<Stream>* getCodec() = 0;
};

} // Atlas namespace

#endif
