/*
   iom128.h - AVR ATmega128 defines
   
   Contributors:
    Created by Peter Jansen <peter@smartcontainer.net> 

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

*/

#ifndef __IOM128
#define __IOM128 1

#define AVR_MEGA 1
#define AVR_ENHANCED 1

/*
 * Predefined SFR Addresses.
 * NOTE: These addresses will be either DATA MEMORY or I/O MEMORY addresses,
 * depending on how you define __SFR_OFFSET (0x0 for I/O, 0x20 for DATA).
 * For accesses to memory locations 0x20 through to 0x5F, gcc subtracts
 * 0x20 from the address supplied and uses an I/O instruction, rather than
 * a data memory access instruction (I/O instructions can only address the
 * first 64 I/O memory locations).
 * By using the __SFR_OFFSET symbol defined as 0x20 in the header file, all
 * special file registers (data memory addresses 0x00--0x1F), all I/O
 * registers (data memory address 0x20--0x5F, I/O memory address 0x00--0x3F)
 * and all extended I/O registers (data memory address 0x60--0xFF) can be
 * used as is, without being wrapped in macros to adjust the address.
 */
/* #define __SFR_OFFSET 0x0 */
#define __SFR_OFFSET 0x20

/* Input Pins, Port F */
#define PINF      (0x0 + __SFR_OFFSET)

/* Input Pins, Port E */
#define PINE      (0x1 + __SFR_OFFSET)

/* Data Direction Register, Port E */
#define DDRE      (0x2 + __SFR_OFFSET)

/* Data Register, Port E */
#define PORTE     (0x3 + __SFR_OFFSET)

/* ADC Low Byte */
#define ADCL      (0x4 + __SFR_OFFSET)

/* ADC High Byte */
#define ADCH      (0x5 + __SFR_OFFSET)

/* ADC Control and status register */
#define ADCSR     (0x6 + __SFR_OFFSET)

/* ADC Multiplexer select */
#define ADMUX     (0x7 + __SFR_OFFSET)

/* Analog Comparator Control and Status Register */
#define ACSR      (0x8 + __SFR_OFFSET)

/* USART0 Baud Rate Register Low */
#define UBRR0L    (0x9 + __SFR_OFFSET)

/* USART0 Control and Status Register B */
#define UCSR0B    (0xA + __SFR_OFFSET)

/* USART0 Control and Status Register A */
#define UCSR0A    (0xB + __SFR_OFFSET)

/* USART I/O Data Register */
#define UDR0      (0xC + __SFR_OFFSET)

/* SPI Control Register */
#define SPCR      (0xD + __SFR_OFFSET)

/* SPI Status Register */
#define SPSR      (0xE + __SFR_OFFSET)

/* SPI I/O Data Register */
#define SPDR      (0xF + __SFR_OFFSET)

/* Input Pins, Port D */
#define PIND      (0x10 + __SFR_OFFSET)

/* Data Direction Register, Port D */
#define DDRD      (0x11 + __SFR_OFFSET)

/* Data Register, Port D */
#define PORTD     (0x12 + __SFR_OFFSET)

/* Input Pins, Port C */
#define PINC	  (0x13 + __SFR_OFFSET)

/* Data Direction Register, Port C */
#define DDRC	  (0x14 + __SFR_OFFSET)

/* Data Register, Port C */
#define PORTC     (0x15 + __SFR_OFFSET)

/* Input Pins, Port B */
#define PINB      (0x16 + __SFR_OFFSET)

/* Data Direction Register, Port B */
#define DDRB      (0x17 + __SFR_OFFSET)

/* Data Register, Port B */
#define PORTB     (0x18 + __SFR_OFFSET)

/* Input Pins, Port A */
#define PINA      (0x19 + __SFR_OFFSET)

/* Data Direction Register, Port A */
#define DDRA      (0x1A + __SFR_OFFSET)

/* Data Register, Port A */
#define PORTA     (0x1B + __SFR_OFFSET)

/* EEPROM Control Register */
#define EECR      (0x1C + __SFR_OFFSET)

/* EEPROM Data Register */
#define EEDR      (0x1D + __SFR_OFFSET)

/* EEPROM Address Register Low */
#define EEARL     (0x1E + __SFR_OFFSET)

/* EEPROM Address Register High */
#define EEARH     (0x1F + __SFR_OFFSET)

/* Special Function I/O Register */
#define SFIOR     (0x20 + __SFR_OFFSET)

/* Watchdog Timer Control Register */
#define WDTCR     (0x21 + __SFR_OFFSET)

/* On-chip Debug Register */
#define OCDR	  (0x22 + __SFR_OFFSET)

/* Timer2 Output Compare Register */
#define OCR2      (0x23 + __SFR_OFFSET)

/* Timer/Counter 2 */
#define TCNT2     (0x24 + __SFR_OFFSET)

/* Timer/Counter 2 Control register */
#define TCCR2     (0x25 + __SFR_OFFSET)

/* T/C 1 Input Capture Register Low */
#define ICR1L     (0x26 + __SFR_OFFSET)

/* T/C 1 Input Capture Register High */
#define ICR1H     (0x27 + __SFR_OFFSET)

/* Timer/Counter1 Output Compare Register B Low */
#define OCR1BL    (0x28 + __SFR_OFFSET)

/* Timer/Counter1 Output Compare Register B High */
#define OCR1BH    (0x29 + __SFR_OFFSET)

/* Timer/Counter1 Output Compare Register A Low */
#define OCR1AL    (0x2A + __SFR_OFFSET)

/* Timer/Counter1 Output Compare Register A High */
#define OCR1AH    (0x2B + __SFR_OFFSET)

/* Timer/Counter 1 Low */
#define TCNT1L    (0x2C + __SFR_OFFSET)

/* Timer/Counter 1 High */
#define TCNT1H    (0x2D + __SFR_OFFSET)

/* Timer/Counter 1 Control and Status Register */
#define TCCR1B    (0x2E + __SFR_OFFSET)

/* Timer/Counter 1 Control Register */
#define TCCR1A    (0x2F + __SFR_OFFSET)

/* Timer/Counter 0 Asynchronous Control & Status Register */
#define ASSR      (0x30 + __SFR_OFFSET)

/* Output Compare Register 0 */
#define OCR0      (0x31 + __SFR_OFFSET)

/* Timer/Counter 0 */
#define TCNT0     (0x32 + __SFR_OFFSET)

/* Timer/Counter 0 Control Register */
#define TCCR0     (0x33 + __SFR_OFFSET)

/* MCU Status Register */
#define MCUSR     (0x34 + __SFR_OFFSET)

/* MCU general Control Register */
#define MCUCR     (0x35 + __SFR_OFFSET)

/* Timer/Counter Interrupt Flag Register */
#define TIFR      (0x36 + __SFR_OFFSET)

/* Timer/Counter Interrupt MaSK register */
#define TIMSK     (0x37 + __SFR_OFFSET)

/* External Interrupt Flag Register */
#define EIFR      (0x38 + __SFR_OFFSET)

/* External Interrupt MaSK register */
#define EIMSK     (0x39 + __SFR_OFFSET)

/* External Interrupt Control Register B */
#define EICRB     (0x3A + __SFR_OFFSET)

/* RAM Page Z select register */
#define RAMPZ     (0x3B + __SFR_OFFSET)

/* XDIV Divide control register */
#define XDIV      (0x3C + __SFR_OFFSET)

/* Stack Pointer Low */
#define SPL       (0x3D + __SFR_OFFSET)

/* Stack Pointer High */
#define SPH       (0x3E + __SFR_OFFSET)

/* Status REGister */
#define SREG      (0x3F + __SFR_OFFSET)

/* Data Direction Register, Port F */
#define DDRF      (0x61)

/* Data Register, Port F */
#define PORTF	  (0x62)

/* Input Pins, Port G */
#define PING      (0x63)

/* Data Direction Register, Port G */
#define DDRG      (0x64)

/* Data Register, Port G */
#define PORTG	  (0x65)

/* Store Program Memory Control Register */
#define SPMCR	  (0x68)

/* External Interrupt Control Register A */
#define EICRA	  (0x6A)

/* External Memory Control Register B */
#define XMCRB	  (0x6C)

/* External Memory Control Register A */
#define XMCRA	  (0x6D)

/* Oscillator Calibration Register */
#define OSCCAL	  (0x6F)

/* 2-wire Serial Interface Bit Rate Register */
#define TWBR	  (0x70)

/* 2-wire Serial Interface Status Register */
#define TWSR	  (0x71)

/* 2-wire Serial Interface Address Register */
#define TWAR	  (0x72)

/* 2-wire Serial Interface Data Register */
#define TWDR	  (0x73)

/* 2-wire Serial Interface Control Register */
#define TWCR	  (0x74)

/* Time Counter 1 Output Compare Register C Low */
#define OCR1CL	  (0x78)

/* Time Counter 1 Output Compare Register C High */
#define OCR1CH	  (0x79)

/* Timer/Counter 1 Control Register C */
#define TCCR1C	  (0x7A)

/* Extended Timer Interrupt Flag Register */
#define ETIFR	  (0x7C)

/* Extended Timer Interrupt Mask Register */
#define ETIMSK	  (0x7D)

/* Timer/Counter 3 Input Capture Register Low */
#define ICR3L	  (0x80)

/* Timer/Counter 3 Input Capture Register High */
#define ICR3H	  (0x81)

/* Timer/Counter 3 Output Compare Register C Low */
#define OCR3CL	  (0x82)

/* Timer/Counter 3 Output Compare Register C High */
#define OCR3CH	  (0x83)

/* Timer/Counter 3 Output Compare Register B Low */
#define OCR3BL	  (0x84)

/* Timer/Counter 3 Output Compare Register B High */
#define OCR3BH	  (0x85)

/* Timer/Counter 3 Output Compare Register A Low */
#define OCR3AL	  (0x86)

/* Timer/Counter 3 Output Compare Register A High */
#define OCR3AH	  (0x87)

/* Timer/Counter 3 Counter Register High */
#define TCNT3L	  (0x88)

/* Timer/Counter 3 Counter Register High */
#define TCNT3H	  (0x89)

/* Timer/Counter 3 Control Register B */
#define TCCR3B	  (0x8A)

/* Timer/Counter 3 Control Register A */
#define TCCR3A	  (0x8B)

/* Timer/Counter 3 Control Register C */
#define TCCR3C	  (0x8C)

/* USART0 Baud Rate Register High */
#define UBRR0H    (0x90)

/* USART0 Control and Status Register C */
#define UCSR0C	  (0x95)

/* USART1 Baud Rate Register High */
#define UBRR1H	  (0x98)

/* USART1 Baud Rate Register Low*/
#define UBRR1L	  (0x99)

/* USART1 Control and Status Register B */
#define UCSR1B	  (0x9A)

/* USART1 Control and Status Register A */
#define UCSR1A	  (0x9B)

/* USART1 I/O Data Register */
#define UDR1	  (0x9C)

/* USART1 Control and Status Register C */
#define UCSR1C	  (0x9D)

/*
  * Interrupt Vector Definitions
  */

#define SIG_INTERRUPT0		_vector_1
#define SIG_INTERRUPT1		_vector_2
#define SIG_INTERRUPT2		_vector_3
#define SIG_INTERRUPT3		_vector_4
#define SIG_INTERRUPT4		_vector_5
#define SIG_INTERRUPT5		_vector_6
#define SIG_INTERRUPT6		_vector_7
#define SIG_INTERRUPT7		_vector_8
#define SIG_OUTPUT_COMPARE2	_vector_9
#define SIG_OVERFLOW2		_vector_10
#define SIG_INPUT_CAPTURE1	_vector_11
#define SIG_OUTPUT_COMPARE1A	_vector_12
#define SIG_OUTPUT_COMPARE1B	_vector_13
#define SIG_OVERFLOW1		_vector_14
#define SIG_OUTPUT_COMPARE0	_vector_15
#define SIG_OVERFLOW0		_vector_16
#define SIG_SPI			_vector_17
#define SIG_UART0_RECV		_vector_18
#define SIG_UART0_DATA		_vector_19
#define SIG_UART0_TRANS		_vector_20
#define SIG_ADC			_vector_21
#define SIG_EEPROM_READY	_vector_22
#define SIG_COMPARATOR		_vector_23
#define SIG_OUTPUT_COMPARE1C	_vector_24
#define SIG_INPUT_CAPTURE3	_vector_25
#define SIG_OUTPUT_COMPARE3A	_vector_26
#define SIG_OUTPUT_COMPARE3B	_vector_27
#define SIG_OUTPUT_COMPARE3C	_vector_28
#define SIG_OVERFLOW3		_vector_29
#define SIG_UART1_RECV		_vector_30
#define SIG_UART1_DATA		_vector_31
#define SIG_UART1_TRANS		_vector_32
#define SIG_2WIRE_SERIAL	_vector_33
#define SIG_SPM_READY		_vector_34

#define END_VECTOR		(34)
#define INT_VECT_SIZE (0x8c)

/*
   The Register Bit names are represented by their bit number (0-7).
*/

/* 2-wire Control Register */
#define    TWINT        7
#define    TWEA         6
#define    TWSTA        5
#define    TWSTO        4
#define    TWWC         3
#define    TWEN         2
#define    TWIE         0

/* 2-wire Address Register */
#define    TWA6         7
#define    TWA5         6
#define    TWA4         5
#define    TWA3         4
#define    TWA2         3
#define    TWA1         2
#define    TWA0         1
#define    TWGCE        0

/* 2-wire Status Register */
#define    TWS7         7
#define    TWS6         6
#define    TWS5         5
#define    TWS4         4
#define    TWS3         3
#define    TWPS1        1
#define    TWPS0        0

/* External Memory Control Register A */
#define    SRL2         6
#define    SRL1         5
#define    SRL0         4
#define    SRW01        3
#define    SRW00        2
#define    SRW11        1

/* External Memory Control Register B */
#define    XMBK         7
#define    XMM2         2
#define    XMM1         1
#define    XMM0         0

/* XDIV Divide control register*/
#define    XDIVEN       7
#define    XDIV6        6
#define    XDIV5        5
#define    XDIV4        4
#define    XDIV3        3
#define    XDIV2        2
#define    XDIV1        1
#define    XDIV0        0

/* RAM Page Z select register */
#define     RAMPZ0      0

/* External Interrupt Control Register A */
#define    ISC31        7
#define    ISC30        6
#define    ISC21        5
#define    ISC20        4
#define    ISC11        3
#define    ISC10        2
#define    ISC01        1
#define    ISC00        0

/* External Interrupt Control Register B */
#define    ISC71        7
#define    ISC70        6
#define    ISC61        5
#define    ISC60        4
#define    ISC51        3
#define    ISC50        2
#define    ISC41        1
#define    ISC40        0

/* Store Program Memory Control Register */
#define    SPMIE        7
#define    RWWSB        6
#define    RWWSRE       4
#define    BLBSET       3
#define    PGWRT        2
#define    PGERS        1
#define    SPMEN        0

/* External Interrupt MaSK register */
#define    INT7         7
#define    INT6         6
#define    INT5         5
#define    INT4         4
#define    INT3         3
#define    INT2         2
#define    INT1         1
#define    INT0         0

/* External Interrupt Flag Register */
#define    INTF7        7
#define    INTF6        6
#define    INTF5        5
#define    INTF4        4

/* Timer/Counter Interrupt MaSK register */
#define    OCIE2        7
#define    TOIE2        6
#define    TICIE1       5
#define    OCIE1A       4
#define    OCIE1B       3
#define    TOIE1        2
#define    OCIE0        1
#define    TOIE0        0

/* Timer/Counter Interrupt Flag Register */
#define    OCF2         7
#define    TOV2         6
#define    ICF1         5
#define    OCF1A        4
#define    OCF1B        3
#define    TOV1         2
#define    OCF0         1
#define    TOV0         0

/* Extended Timer Interrupt MaSK register */
#define    TICIE3       5
#define    OCIE3A       4
#define    OCIE3B       3
#define    TOIE3        2
#define    OCIE3C       1
#define    OCIE1C       0

/* Extended Timer Interrupt Flag Register */
#define    ICF3         5
#define    OCF3A        4
#define    OCF3B        3
#define    TOV3         2
#define    OCF3C        1
#define    OCF1C        0

/* MCU general Control Register */
#define    SRE          7
#define    SRW          6
#define    SE           5
#define    SM1          4
#define    SM0          3
#define    SM2          2
#define    IVSEL        1
#define    IVCE         0

/* MCU Status Register */
#define    JTD          7
#define    JTRF         4
#define    WDRF         3
#define    BORF         2
#define    EXTRF        1
#define    PORF         0

/* Timer/Counter Control Register */
#define    FOC          7
#define    WGM0         6
#define    COM1         5
#define    COM0         4
#define    WGM1         3
#define    CS2          2
#define    CS1          1
#define    CS0          0

/* Timer/Counter 0 Asynchronous Control & Status Register */
#define    AS0          3
#define    TCN0UB       2
#define    OCR0UB       1
#define    TCR0UB       0

/* Timer/Counter Control Register A */
#define    COMA1        7
#define    COMA0        6
#define    COMB1        5
#define    COMB0        4
#define    COMC1        3
#define    COMC0        2
#define    WGMA1        1
#define    WGMA0        0

/* Timer/Counter Control and Status Register B */
#define    ICNC         7
#define    ICES         6
#define    WGMB3        4
#define    WGMB2        3
#define    CSB2         2
#define    CSB1         1
#define    CSB0         0

/* Timer/Counter Control Register C */
#define    FOCA         7
#define    FOCB         6
#define    FOCC         5

/* On-chip Debug Register */
#define    OCDR7        7
#define    OCDR6        6
#define    OCDR5        5
#define    OCDR4        4
#define    OCDR3        3
#define    OCDR2        2
#define    OCDR1        1
#define    OCDR0        0

/* Watchdog Timer Control Register */
#define    WDCE         4
#define    WDE          3
#define    WDP2         2
#define    WDP1         1
#define    WDP0         0

/* Special Function I/O Register */
#define    TSM          7
#define    ADHSM        4
#define    ACME         3
#define    PUD          2
#define    PSR0         1
#define    PSR321       0

/* EEPROM Control Register */
#define    EERIE        3
#define    EEMWE        2
#define    EEWE         1
#define    EERE         0

/* Port Data Register */
#define    PORT7        7
#define    PORT6        6
#define    PORT5        5
#define    PORT4        4
#define    PORT3        3
#define    PORT2        2
#define    PORT1        1
#define    PORT0        0

/* Port Data Direction Register */
#define    DD7          7
#define    DD6          6
#define    DD5          5
#define    DD4          4
#define    DD3          3
#define    DD2          2
#define    DD1          1
#define    DD0          0

/* Port Input Pins */
#define    PIN7         7
#define    PIN6         6
#define    PIN5         5
#define    PIN4         4
#define    PIN3         3
#define    PIN2         2
#define    PIN1         1
#define    PIN0         0

/* Status Register */
#define    SREG_I       7
#define    SREG_T       6
#define    SREG_H       5
#define    SREG_S       4
#define    SREG_V       3
#define    SREG_N       2
#define    SREG_Z       1
#define    SREG_C       0

/* SPI Status Register */
#define    SPIF         7
#define    WCOL         6
#define    SPI2X        0

/* SPI Control Register */
#define    SPIE         7
#define    SPE          6
#define    DORD         5
#define    MSTR         4
#define    CPOL         3
#define    CPHA         2
#define    SPR1         1
#define    SPR0         0

/* USART Register C */
#define    UMSEL        6
#define    UPM1         5
#define    UPM0         4
#define    USBS         3
#define    UCSZ1        2
#define    UCSZ0        1
#define    UCPOL        0

/* USART Status Register A */
#define    RXC          7
#define    TXC          6
#define    UDRE         5
#define    FE           4
#define    OVR          3    /* This definition differs from the databook */
  /*definition to avoid problems with the OR instruction */

/* USART Control Register */
#define    RXCIE        7
#define    TXCIE        6
#define    UDRIE        5
#define    RXEN         4
#define    TXEN         3
#define    UCSZ         2
#define    RXB8         1
#define    TXB8         0

/* Analog Comparator Control and Status Register */
#define    ACD          7
#define    ACBG         6
#define    ACO          5
#define    ACI          4
#define    ACIE         3
#define    ACIC         2
#define    ACIS1        1
#define    ACIS0        0

/* ADC Control and status register */
#define    ADEN         7
#define    ADSC         6
#define    ADFR         5
#define    ADIF         4
#define    ADIE         3
#define    ADPS2        2
#define    ADPS1        1
#define    ADPS0        0

/* ADC Multiplexer select */
#define    REFS1        7
#define    REFS0        6
#define    ADLAR        5
#define    MUX4         4
#define    MUX3         3
#define    MUX2         2
#define    MUX1         1
#define    MUX0         0

/* Pointer definition */
#define    XL       r26
#define    XH       r27
#define    YL       r28
#define    YH       r29
#define    ZL       r30
#define    ZH       r31

/* Constants */
#define    RAMEND   0x10FF     /* Last On-Chip SRAM Location */
#define    XRAMEND  0xFFFF
#define    E2END    0x0FFF
#define    FLASHEND 0x1FFFF

#endif /* __IOM128 */
