#include <X11/Xlib.h>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/time.h>


#include "bblaunch.h"


int main (int argc, char **argv)
  {
    Display *display;
    int screen_num;
    unsigned long i,start;
    Window root;
    LArgs launchargs;

    Window bblwin;
    Atom bbsma,bbwinadd,bbwscnt,bbstart;
    Atom wmproto[2];
    XEvent event;

    Window leader, client;

    (void) XSetErrorHandler(xerror);

    launchargs = arginit(argc,argv);

    display = XOpenDisplay( XDisplayName(NULL) );
  
    if (display == NULL)
      die(NULL,"Cannot connect to display");

    screen_num = DefaultScreen(display);
    root = RootWindow(display,screen_num);

    bblwin = XCreateSimpleWindow(display,root,0,0,1,1,0,CopyFromParent,CopyFromParent);


    bbstart = XInternAtom(display, "_BLACKBOX_NOTIFY_STARTUP", False);
    bbsma = XInternAtom(display, "_BLACKBOX_STRUCTURE_MESSAGES", False);
    bbwinadd = XInternAtom(display, "_BLACKBOX_NOTIFY_WINDOW_ADD", False);
    bbwscnt = XInternAtom(display, "_BLACKBOX_NOTIFY_WORKSPACE_COUNT", False); 

    wmproto[0] = XInternAtom(display, "WM_DELETE_WINDOW", False);
    wmproto[1] = bbsma;

    if (XSetWMProtocols(display, bblwin,wmproto, 2) == 0)
      die(display, "Could not initialize bblaunch");

    if (XMapWindow(display,bblwin) == BadWindow)
      die(display, "Could not initialize bblaunch window");

    while(1)
      {
          (void) XNextEvent(display,&event);
          if (event.type == ClientMessage)
            if (event.xclient.message_type == bbsma)
              if ((Atom) event.xclient.data.l[0] == bbstart)
                break;
      }

    while(XCheckTypedEvent(display,ClientMessage,&event))
      if (event.xclient.message_type == bbsma)
        if ((Atom)event.xclient.data.l[0] == bbwscnt)
          if (launchargs.workspace + 1 > event.xclient.data.l[1])
              launchargs.workspace = 0;

    if(!launch(launchargs))
      die(display, "Command did not launch!");

    start = getmilliseconds();

    for(i=start; i<start + launchargs.pause; i = getmilliseconds())
      {
        if (XPending(display))
          {
            (void) XNextEvent(display,&event);
            if (event.type == ClientMessage)
              if (event.xclient.message_type == bbsma)
                if ((Atom) event.xclient.data.l[0] == bbwinadd)
                  {
                    leader = getleader(display,(Window)event.xclient.data.l[1]);
                    if ((int)leader)
                      {
                        client = leader;
                      }
                    else
                      {
                        client = (Window) event.xclient.data.l[1];
                      }
                    if (checkcommand(display,client,launchargs))
                        hintwin(display,root,(Window)event.xclient.data.l[1],
                                launchargs);
                  }
          }
      }

    (void) XCloseDisplay(display);


    return(0);
  }

int checkcommand(Display *display, Window leader, LArgs launchargs)
  {

    unsigned int j;
    char **cliargv = NULL;
    int cliargc, retval;
    char tcommand[1024];

    if(XGetCommand (display, leader, &cliargv, &cliargc) == 0)
      {
        fprintf(stderr, "Warning: XGetCommand can't allocate enough memory\n");
        return(0);
      }

    if (cliargc > 0)
      {
        tcommand[0] = 0;
        for (j=0;j<cliargc;j++)
          {
            sprintf(tcommand,"%s%s ",tcommand,cliargv[j]);
          }

        XFreeStringList (cliargv);

        if(strncmp(tcommand,launchargs.command,strlen(tcommand) -1))
          {
            return(0);
          }
      }

    return(1);
  }

Window getleader(Display *display, Window client)
  {
    Atom atom, type, winatom;
    int status, format;
    unsigned long nitems, bytes, *prop = NULL;

    atom = XInternAtom(display,"WM_CLIENT_LEADER",False);
    winatom = XInternAtom(display,"WINDOW",False);

    status = XGetWindowProperty(display, client, atom,
                                0l, 1l, False, AnyPropertyType, &type,
                                &format, &nitems, &bytes,
                                (unsigned char **)&prop);

    if (nitems > 0 && type == winatom)
      return(*prop);

    return(0);
  }

LArgs arginit(int argc, char **argv)
  {
    LArgs launchargs;
    char *targ = "";
    int i, valargs;

    launchargs.flags = launchargs.attrib = 0l;
    launchargs.workspace = launchargs.stack = launchargs.decoration = 0;
    launchargs.pause = 1000;

    sprintf(launchargs.call,"%s", (char *)atoi(argv[0]));

    i = 1;
    valargs = 1;
    while ((i < argc) && valargs)
      {
        valargs = 0;

        if ((!strcmp(argv[i],"-s")) | (!strcmp(argv[i],"--shaded")))
          {
            valargs = 1;
            launchargs.flags |= (1l << 0);
            launchargs.attrib |= (1l << 0);
            
          }
        if ((!strcmp(argv[i],"-h")) | (!strcmp(argv[i],"--maxhoriz")))
          {
            valargs = 1;
            launchargs.flags |= (1l << 1);
            launchargs.attrib |= (1l << 1);

          }
        if ((!strcmp(argv[i],"-v")) | (!strcmp(argv[i],"--maxvert")))
          {
            valargs = 1;
            launchargs.flags |= (1l << 2);
            launchargs.attrib |= (1l << 2);
          }
        if ((!strcmp(argv[i],"-o")) | (!strcmp(argv[i],"--omnipresent")))
          {
            valargs = 1;
            launchargs.flags |= (1l << 3);
            launchargs.attrib |= (1l << 3);
          }
        if ((!strcmp(argv[i],"-w")) | (!strcmp(argv[i],"--workspace")))
          {
            if (++i == argc) usage();

            valargs = 1;
            launchargs.flags |= (1l << 4);
            launchargs.workspace = atoi(argv[i]) - 1;
          }
        if ((!strcmp(argv[i],"-k")) | (!strcmp(argv[i],"--stack")))
          {
            if (++i == argc) usage();

            valargs = 1;
            launchargs.flags |= (1l << 5);
            launchargs.stack = atoi(argv[i]) - 1;
          }
        if ((!strcmp(argv[i],"-d")) | (!strcmp(argv[i],"--decor")))
          {
            if (++i == argc) usage();

            valargs = 1;
            launchargs.flags |= (1l << 6);
            launchargs.decoration = atoi(argv[i]);
          }
        if ((!strcmp(argv[i],"-p")) | (!strcmp(argv[i],"--pause")))
          {
            if (++i == argc) usage();

            valargs = 1;
            launchargs.pause = atoi(argv[i]);
          }
        if ((!strcmp(argv[i],"-?")) | (!strcmp(argv[i],"--help")))
          {
            usage();
          }

        if (valargs) i++;
      }

    if (i == argc)
      usage();
    else
     {
       launchargs.command[0] = 0;
       for (;i<argc;i++)
         {
           targ = argv[i];
           sprintf(launchargs.command,"%s%s ",launchargs.command,targ);
         }
     }

    return(launchargs);

  }

int launch(LArgs launchargs)
  {
    extern char **environ;
    int pid = fork();

    if (pid == -1)
      return(-1);

    if (pid == 0)
      {
        char *argv[4];

        argv[0] = "sh";
        argv[1] = "-c";
        argv[2] = launchargs.command;
        argv[3] = 0;

        (void) execve("/bin/sh", argv, environ);

        }

    return(pid);
  }

void hintwin(Display *display, Window root, Window win,LArgs launchargs)
  {

    XEvent event;
    unsigned long mask;
    Atom attratom;
    attratom = XInternAtom(display, "_BLACKBOX_CHANGE_ATTRIBUTES", False);

    event.xclient.type = ClientMessage;
    event.xclient.window = win;
    event.xclient.message_type = attratom;
    event.xclient.format = 32;
    event.xclient.data.l[0] = launchargs.flags; 
    event.xclient.data.l[1] = launchargs.attrib;
    event.xclient.data.l[2] = launchargs.workspace;
    event.xclient.data.l[3] = launchargs.stack;
    event.xclient.data.l[4] = launchargs.decoration;
    event.xclient.data.l[5] = 0;

    mask =  SubstructureRedirectMask;
    if (XSendEvent(display, root,False, mask, &event) == 0)
      die(display, "Could not send event to window manager");

  }

unsigned long getmilliseconds(void)
  {
    struct timeval tv;
    double seconds, milliseconds;
    (void) gettimeofday(&tv,(struct timezone *) NULL);

    seconds = tv.tv_sec - (((int)tv.tv_sec / 1000) * 1000);
    milliseconds = (tv.tv_usec / 1000) * 0.001000;


    return ((unsigned long)((seconds + milliseconds) * 1000));
  }

void usage(void)
  {

    fprintf (stderr,
        "usage:  bblaunch [-options ...] command\n\n");
    fprintf (stderr,
        "where options include:\n");
    fprintf (stderr,
        "  -s --shaded                      shaded\n");
    fprintf (stderr,
        "  -h --maxhorz                     horizontally maximixed\n");
    fprintf (stderr,
        "  -v --maxvert                     vertically maximized\n");
    fprintf (stderr,
        "  -o --omnipresent                 omnipresent\n");
    fprintf (stderr,
        "  -w --workspace <workspace>       specify initialworkspace\n");
    fprintf (stderr,
        "  -k --stack <stack>               specify stack placement\n");
    fprintf (stderr,
        "  -d --decor <decorations>         specify window decorations\n");
    fprintf (stderr,
        "  -p --pause <milliseconds>        time to wait for windows to map\n");
    fprintf (stderr,
        "  -? --help                        displays this message\n");


    exit(EXIT_FAILURE);
  }

void die(Display *display, char * error)
 {

   if (display != NULL)
     (void) XCloseDisplay(display);

   fprintf(stderr,"Fatal Error: %s\n",error);
   exit(EXIT_FAILURE);
  }

int xerror(Display *display, XErrorEvent *error)
  {
    char msg[80];
    msg[0] = 0;

    (void) XGetErrorText(display,error->error_code,msg,80);
    fprintf(stderr,"Non Fatal Error: %s\n",msg);

    return(0);
  }
