#include "includes.h"

int parseschedule(char *scheset, int * retval)
{
    unsigned int bh,bm,eh,em;
    unsigned int day;
    unsigned int begin;
    unsigned int end;
    char presenteddays[7];

    if ((strlen(scheset)>=11)&&
	(isdigit(scheset[0])) && (isdigit(scheset[1])) && (scheset[2]==':') &&
	(isdigit(scheset[3])) && (isdigit(scheset[4])) && (scheset[5]=='-') &&
	(isdigit(scheset[6])) && (isdigit(scheset[7])) && (scheset[8]==':') &&
	(isdigit(scheset[9])) && (isdigit(scheset[10])))
    {	
	if (strlen(scheset)==11)
	{	/* no day field presented */
    	    bh=(scheset[0]-48)*10+(scheset[1]-48);
	    bm=(scheset[3]-48)*10+(scheset[4]-48);
	    eh=(scheset[6]-48)*10+(scheset[7]-48);
	    em=(scheset[9]-48)*10+(scheset[10]-48);
	    day=0;
	}
	else if ((strlen(scheset)<19) && (strlen(scheset)>12) &&
		 (scheset[11]==';'))
	{	/* day field presented */
	    int l=1;
	    int i=12;
	    
	    memset(presenteddays, 0, 7);
	    while ((scheset[i]) && (l))
	    {
		if ((scheset[i]<48) || (scheset[i]>54)) l=0;
		if (presenteddays[scheset[i]-48]) l=0;
		presenteddays[scheset[i]-48]=1;
		i++;
	    }
	    if (!l) 
	    {
		return 0;
	    }
	    else
	    {	/* good schedule with day field */
		int i;
		
        	bh=(scheset[0]-48)*10+(scheset[1]-48);
		bm=(scheset[3]-48)*10+(scheset[4]-48);
		eh=(scheset[6]-48)*10+(scheset[7]-48);
		em=(scheset[9]-48)*10+(scheset[10]-48);
		day=0;
		for (i=0;i<7;i++)
		{
		    if (presenteddays[i])
			day |= (1<<i);
		}
	    }
	}
	else
	{
	    return 0;
	}
    }
    else
    {
	return 0;
    }
    
    if ((bh>24)||(bh<0)||(eh>24)||(eh<0)||
	(bm>60)||(bm<0)||(em>60)||(em<0))
	return 0;
	
    if (eh*60+em<bh*60+bm)
	return 0;
    
    begin=bh*60+bm;
    end=eh*60+em;
    end=end<<12;
    day=day<<24;
    
    *retval=begin|end|day;
    return 1;
}

void schedule(struct struc_bootmanager *btmgr, int recnum, char *scheset)
{
    if (reccheck(btmgr->sbmkdata.boot_records[recnum]))
    {
	int schdword;

	if (!scheset)
	{
	    btmgr->sbmkdata.boot_records[recnum].flags&=(byte)~INFOFLAG_SCHEDULED;
	    btmgr->sbmkdata.boot_records[recnum].schedule_time=0;
	}
	else if (parseschedule(scheset, &schdword))
	{
	    btmgr->sbmkdata.boot_records[recnum].flags|=INFOFLAG_SCHEDULED;
	    btmgr->sbmkdata.boot_records[recnum].schedule_time=schdword;
	}
	else
	{
	    fprintf(stderr,"Wrong schedule time!\n");
	    usage();
	}
    }
    else
    {
        fprintf(stderr,"The given record isn't good (schedule)!\n");
	exit(-3);
    }
}
