/***************************************************************************
                          dlgaddbrowser.h  -  description
                             -------------------
    begin                : Sat Nov 16 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kschenke at users dot sourceforge dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA         *
 *   02110-1301, USA                                                       *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   The DlgAddBrowser class represents a dialog box used to display a     *
 *   list of browsers to the user, allowing them to select a browser as an *
 *   origin or destination.                                                *
 *                                                                         *
 ***************************************************************************/

#ifndef DLGADDBROWSER_H
#define DLGADDBROWSER_H

#include "ui_dlgaddbrowser.h"
#include "bridgecfg.h"

#include <vector>

class DlgAddBrowser : public QDialog, public Ui::DlgAddBrowser
{
	Q_OBJECT;

public:
	DlgAddBrowser(
				  const std::vector<BrowserCfg> &browsers,
				  QWidget* parent = 0);
	virtual ~DlgAddBrowser();

	BRWSNUM		ordinal;	// the ordinal of the currently selected browser

public slots:
	void on_listBrowsers_itemSelectionChanged(void);

private:
	const std::vector<BrowserCfg> m_browsers;

	void    refreshButtons(void);
	void    refreshList(void);
};

#endif  // end of DLGADDBROWSER_H
