/*
 * shrink_eucja():
 * insert '\n' into text taking Japanese-multibyte into consideration.
 * Making the line at most maxlinelen+1 bytes long.
 * Note: when maxlinelen < 3, the result will be 4 bytes long.
 *
 * copyright (c) 2000 Akira Yoshiyama, see GPL ver.2 or BSD for license
 * Patch copyright (c) 2000 Junichi Uekawa, see GPL version 2 or later for license
 *
 * ver 1.0: initial release.
 * ver 1.1: added buffer length checking.
 */

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>

#define check_remaining(width)			\
	 {					\
	  if (count + (width) > maxlinelen)	\
	    {					\
	      dest[bp++] = '\n';		\
	      count = 0;			\
	    }					\
	} 

#define copy_one_octet					\
	if (*sp == '\0')				\
	  break;					\
	else {						\
	  dest[bp++] = *sp++;				\
	  if (++count >= maxbuffersize) return NULL;	\
	}

char *
shrink_string(char *dest, char *source, int maxlinelen, int maxbuffersize)
{
  unsigned char *sp = (unsigned char *)source;
  unsigned int count = 0, bp = 0;  
  
  while (*sp) 
    {
      /*
       * 0x0 <= *sp <= 0x20
       * control characters
       * (using 1 byte/character)
       */
      if (*sp <= 0x20)
	{
	  if (*sp == '\n') count = 0;
	  copy_one_octet;
	}
      /*
       * 0x21 <= *sp <= 0x7E
       * codeset 0; ASCII / JIS roman
       * (using 1 byte/character)
       */
      else if (0x21 <= *sp && *sp <= 0x7E)
	{
	  check_remaining(1);
	  copy_one_octet;
	}
      /*
       * 0xA1 <= *sp <= 0xFE
       * codeset 1; JIS X 0208-1990
       * (using 2 byte/character)
       */
      else if (0xA1 <= *sp && *sp <= 0xFE)
	{
	  check_remaining(2);
	  copy_one_octet;
	  copy_one_octet;
	}
      /*
       * *sp == 0x8E
       * codeset 2; JIS hankaku kana
       * (using 2 bytes/character)
       */
      else if (*sp == 0x8E)
	{
	  check_remaining(1);
	  copy_one_octet;
	  copy_one_octet;
	}
      /*
       * *sp == 0x8F
       * codeset 3; JIS X 0212-1990
       * (using 3 bytes/character)
       */
      else if (*sp == 0x8F)
	{
	  check_remaining(2);
	  copy_one_octet;
	  copy_one_octet;
	  copy_one_octet;
	}
      /*
       * others
       */
      else
	{
	  check_remaining(1);
	  copy_one_octet;
	}
    }

  dest[bp] = '\0';

  return (char *)dest;
}

#ifdef TESTING
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

char *program_name;

void 
usage(void)
{
  fprintf(stderr, "%s <max len> : input from stdin\n", program_name);
  fprintf(stderr, "%s <max len> <filename> ...: input from <filename>\n", program_name);
  exit(1);
}

int
do_shrink(int fd, int maxlen)
{
  char buf[BUFSIZ], buf2[BUFSIZ];
  
  while (read(fd, buf, BUFSIZ))
    puts(shrink_string(buf2, buf, maxlen, BUFSIZ));

  return 0;
}

int
main(int argc, char **argv)
{
  int maxlen;
  int fd, i;

  program_name = argv[0];

  if (argc == 1)
    usage();

  if (! (maxlen = atoi(argv[1])) )
    {
      fprintf(stderr, "%s: too narrow\n", program_name);
      exit(1);
    }

  if (argc == 2)
    do_shrink(0, maxlen);
  else
    for (i = 2; i < argc; i++)
      if ( (fd = open(argv[i], O_RDONLY)) < 0 )
	{
	  perror(__FUNCTION__ "fd");
	  exit(1);
	}
      else
	do_shrink(fd, maxlen);

  return 0;
}
#endif
