/*

floppy_modules.c

Copyright (C) 2000 Guillaume Morin, Alcve

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

This work has been sponsored by Alcve http://www.alcove.fr.

For any comments write to Guillaume Morin <gemorin@debian.org>


TODO

	* Better error messages (please help)
*/

#include <stdio.h>
#include <sys/mount.h>
#include <sys/stat.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#include <string.h>
#include <stdlib.h>
#include "dbootstrap.h"
#include "lang.h"
#include "util.h"
#include "boxes.h"

#define MOUNT_DIR "/floppy"
#if !(#cpu(s390))
#define FLOPPY_DEVICE "/dev/fd0"
#else
#define FLOPPY_DEVICE "/dev/rd/1"
#endif
#define BOOT_MODULES_PLACE "boot"


/* the purpose of this structure is to simplify
 * the call to cleanquit which basically free allocated stuff
 * and chdir
 */

struct quit
{
	char * old_dir;
	int nb;
	struct d_choices * choices_ptr;
	char * tobefreed;
};

static void cleanquit(struct quit q)
{
	int i;
	for (i = 0 ; i < q.nb ; ++i )
	{
		free(q.choices_ptr[i].string);
	}
	free(q.choices_ptr);
	free(q.tobefreed);
	if ( chdir(q.old_dir) == -1)
	{
		perrorBox("chdir failed: ");
	}
	if ( umount(MOUNT_DIR) == -1 )
	{
		perrorBox("umount failed: ");
	}
	return;
}


/* ac for already called */
/* this sucks but I do not want to use a global variable */
int load_modules_after_boot_ac(void)
{
	static char already_called = 0;
	if ( already_called )
	{
		return 1;
	}
	already_called = 1;
	return 0;
}


int load_modules_after_boot(void) 
{	
	struct stat statbuf;
	/*
	struct d_choices choices[3] = {
		{NULL,"ext2",0},
		{NULL,"minix",0},
		{NULL,"msdos",0}
		};
	*/
	struct d_choices * mod_choices;
	
	DIR * dir;
	struct dirent * dirent;
	char * tmp;
	char * already_loaded;
	char * modules_dir;
	char current_dir[256];
	char buffer[256];
	FILE  *pipe;
	int nb;
	/*
	int nitems = 3;
	*/
	int ret;
	struct quit q;
	int i;
	FILE *fd = NULL;	
	/*char text[512];*/

	if ( yesNoBox(_("This step is only required if the hard disk controller, on which you want to install Debian GNU/Linux, is not recognized. In most cases, you can safely skip this.\n"
				"Would you like to proceed with this step?"), _("Preload essential modules from a floppy")) == DLG_NO)
	{
		return 1;
	}

	if ( yesNoBox(_("Now please insert the floppy in /dev/fd0. \n"
	"All the modules you want to load with this process must reside in the boot subdirectory of your floppy disk.\n"
	"At this time, the process cannot determine any module dependencies. So if a module depends on other ones, you'll have to load them first.\n"
	"That is to say that you should use this process to load only the modules that you'll need for the very next steps.\n"
	"All the modules you will load will be executed at every boot using initrd.\n"
	"Are you sure you want to continue?"),_("Warning")) == DLG_NO )
	{
		return 1;
	}
	
	/* check if  /floppy is a dir, if not try to make it */
	if (( ! NAME_ISDIR(MOUNT_DIR,&statbuf) ) && (mkdir("/floppy",0777) != 0) )
	{
		problemBox(_("The process cannot make the mount point. This step will be skipped"),_("Problem"));
		return 1;
	}
	/*
	strcpy(text,_("Insert the floppy disk in "));
	strcat(text,FLOPPY_DEVICE);
	strcat(text,_(" and then select its filesystem"));
	ret = menuBox(text,_("Filesystem Selection"),choices,nitems,1);
	if ( ret == -1 )
	{
		return 1;
	}
	if ( mount(FLOPPY_DEVICE,MOUNT_DIR,choices[ret].string,MS_RDONLY,NULL) )
   	{
		perrorBox(_("Unable to mount the floppy disk"));
		return 1;
	}
	*/
	pipe = popen("cat /proc/filesystems","r");
	
    if ( pipe == NULL )
    {
        perrorBox("Can't read /proc/filesystems: ");
        return 1;
    }
    while (fgets(buffer,sizeof(buffer),pipe) )
    {
        buffer[strlen(buffer)-1] = '\0';
        if ( *buffer == 'n' )
        {
            /* the entry begins by nodev, so we forget it */
            continue;
        }
        tmp = buffer;
        while ( *tmp == '\0' || *tmp == '\t' )
        {
            ++tmp;
		}
		if ( mount (FLOPPY_DEVICE,MOUNT_DIR,tmp,MS_RDONLY,NULL) )
		{
			continue;
		}
		pclose(pipe);
		pipe = NULL;
		break;
	}
	if ( pipe != NULL )
	{
		pclose(pipe);
		problemBox(_("Unable to mount the floppy disk, can't continue"),_("Critical Error"));
		return 1;
	}
	modules_dir = malloc(sizeof(MOUNT_DIR) + sizeof('/') + sizeof(BOOT_MODULES_PLACE));
	if ( modules_dir == NULL )
	{
		umount(MOUNT_DIR);
		return 1;
	}
	strcpy(modules_dir,MOUNT_DIR);
	strcat(modules_dir,"/");
	strcat(modules_dir,BOOT_MODULES_PLACE);
	q.tobefreed = modules_dir;
	if ( ! NAME_ISDIR(modules_dir,&statbuf))
	{
		problemBox(_("The floppy disk doesn't contain the boot subdirectory with the modules, stopping this step"),_("Problem"));
		free(modules_dir);
		umount(MOUNT_DIR);
		return 1;
	}
	
	dir = opendir(modules_dir);
	if ( dir == NULL )
	{
		problemBox(_("opendir(modules_dir) returned NULL, please report this bug to gemorin@debian.org"),_("Critical Error"));
		free(modules_dir);
		umount(MOUNT_DIR);
		return 1;
	}
	
	/* we're gonna find in this dir the .o regular file and add it in a choice
	 * array */
	dirent = readdir(dir);
	if ( ! getcwd(current_dir,sizeof(current_dir)) )
	{
		perrorBox(_("getcwd failed:"));
		free(modules_dir);
		umount(MOUNT_DIR);
		return 1;
	}
	q.old_dir = current_dir;
	if (chdir(modules_dir) == -1 )
	{
		perrorBox(_("Warning! Can't umount floppy, chdir() failed: "));
		return 1;
	}
	
	nb = 0;
	
	mod_choices = NULL;
	while ( dirent != NULL )
	{
		if ( NAME_ISREG(dirent->d_name,&statbuf) )
		{
			tmp = strstr(dirent->d_name,".o");
			/* check if the filename has an object extension */
			if ( (tmp) && *(tmp + 2) == '\0' )
			{
				/* add an entry in the menu */
				mod_choices = realloc(mod_choices,(nb + 1) * sizeof(struct d_choices));
				q.choices_ptr = mod_choices;
				mod_choices[nb].tag = NULL;
				mod_choices[nb].state = 0;
				mod_choices[nb].string = strdup(dirent->d_name);
				++nb;
			}
		}
		dirent = readdir(dir);
	}
	q.nb = nb;
	already_loaded = malloc(nb * sizeof(char));
	memset(already_loaded,0,nb * sizeof(char));
	if ( already_loaded == NULL )
	{
		problemBox(_("Can't allocate memory"),_("Error"));
		cleanquit(q);
	}
	if ( closedir(dir) == -1 )
	{
		perrorBox(_("closedir: "));
		cleanquit(q);
		return 1;
	}
	i = 0; /* nb of loaded modules */
	for (;;)
	{
		ret = menuBox(_("Choose the module you want to load"),_("Modules Selection"),mod_choices,nb,1);
		if ( ret == -1 )
		{
			break;
		}
		if ( already_loaded[ret] )
		{
			problemBox(_("This module has been already loaded"),_("Error"));
			continue;
		}
		tmp = inputBox(_("Would you like to pass any arguments to the module?"),_("Modules arguments"),'\0');
      sprintf(prtbuf, "/sbin/insmod -f %s %s", mod_choices[ret].string, tmp);
		if ( execlog(prtbuf,LOG_INFO) )
		{
			problemBox(_("The loading has failed."),_("Error"));
			
		} else {
			already_loaded[ret] = 1;
			++i;
			/* we're gonna save the modules that we'll put on our
			 * ramdisk into the MOD_SAVE_DIR directory. So we check if this
			 * directory exists otherwise we try to "mkdir" it */
			if ( (! NAME_ISDIR(MOD_SAVE_DIR,&statbuf)) && (mkdir(MOD_SAVE_DIR,0777) != 0) )
			{
				problemBox(_("Unable to access or create the directory used for saving the modules, can't continue"),_("Critical Error"));
				cleanquit(q);
			}
         sprintf(prtbuf, "cp %s %s", mod_choices[ret].string, MOD_SAVE_DIR);
			if ( execlog(prtbuf,LOG_DEBUG) )
			{
				problemBox(_("Can't copy module files"),_("Error"));
				cleanquit(q);
				return 1;
			}
			if ( fd == NULL )
			{
				fd = fopen(MOD_SAVE_FILE,"a");
				if ( fd == NULL )
				{
					problemBox(_("Can't create the 'mod-save' file"),_("Error"));
					cleanquit(q);
					return 1;
				}
			}
			fprintf(fd,"%s %s\n",mod_choices[ret].string,tmp);
		}
		free(tmp);
		if ( i == nb )
		{
			/* we have loaded all the modules */
			break;
		}
		else if ( yesNoBox(_("Would you like to load other modules?"),_("Question")) == DLG_NO )
		{
			break;
		}
	}
	
   if(fd)
      fclose(fd);
	fdisk_reread();
	cleanquit(q);	

	return 0;
}



int add_modules_from_floppy(void)
{
	struct stat statbuf;
	/*
	struct d_choices choices[3] = {
		{NULL,"ext2",0},
		{NULL,"minix",0},
		{NULL,"msdos",0}
		};
	int nitems=3;
	*/
	char sections[][10]={"block","cdrom","fs","ipv4","ipv6","misc","net","scsi",""};
	int i;
	char dir[256];
	char tmp_dir[256];
	char command[512];
	/*int ret;*/
	char buffer[256];
	FILE * pipe;
	char * ptr;
	
	/* it would be better if the path was /lib/modules/kernel-version/section,
	 * but we cannot do this with a msdos fs
	 */
#if !(#cpu(s390))
	if ( bootargs.isquiet || 
             yesNoBox(_("You may load some additional modules from an extra floppy disk, for example, device drivers "
			"shipped from your hardware vendor. They must reside on the floppy in the "
                        "standard modules tree (lib/modules/'section').  Unless you were provided with such a floppy, "
                        "just skip this step.\n\n"
			"Would you like to skip this step? "), _("Question")) == DLG_YES )
	{
		return 0;
	}
#endif
	/* check if  /floppy is a dir, if not try to "mkdir" it */
	if (( ! NAME_ISDIR(MOUNT_DIR,&statbuf) ) && (mkdir(MOUNT_DIR,0777) != 0) )
	{
		problemBox(_("The process cannot make the mount point. This step will be skipped"),_("Problem"));
		return -1;
	}

#if !(#cpu(s390))
	problemBox(_("Please insert a floppy disk in the first floppy drive, /dev/fd0"),_("Insert floppy"));
#endif
	/*
	strcpy(command,_("Insert the floppy disk in "));
	strcat(command,FLOPPY_DEVICE);
	strcat(command,_(" and then select its filesystem"));
	ret = menuBox(command,_("Filesystem Selection"),choices,nitems,1);
	if ( ret == -1 )
	{
		return;
	}
	if ( mount(FLOPPY_DEVICE,MOUNT_DIR,choices[ret].string,MS_RDONLY,NULL) )
   	{
		perrorBox(_("Unable to mount the floppy disk"));
		return;
	}
	*/
	pipe = popen("cat /proc/filesystems","r");
	
    if ( pipe == NULL )
    {
        perrorBox("Can't read /proc/filesystems: ");
        return -1;
    }
    while (fgets(buffer,sizeof(buffer),pipe) )
    {
        buffer[strlen(buffer)-1] = '\0';
        if ( *buffer == 'n' )
        {
            /* the entry begins by nodev, so we forget it */
            continue;
        }
        ptr = buffer;
        while ( *ptr == '\0' || *ptr == '\t' )
        {
            ++ptr;
		}
		if ( mount (FLOPPY_DEVICE,MOUNT_DIR,ptr,MS_RDONLY,NULL) )
		{
			continue;
		}
		pclose(pipe);
		pipe = NULL;
		break;
	}
	if ( pipe != NULL )
	{
		pclose(pipe);
#if !(#cpu(s390))
		problemBox(_("Unable to mount the floppy disk, can't continue"),_("Critical Error"));
#endif
		return -1;
	}

#if !(#cpu(s390))
	strcpy(dir,MOUNT_DIR);
	strcat(dir,"/lib/modules");
#else
        sprintf(dir, "%s%s/%s", MOUNT_DIR, "/lib/modules", kver);  
#endif
	if ( ! NAME_ISDIR(dir,&statbuf) )
	{
#if !(#cpu(s390))
		vaproblemBox(_("Error"),_("Your floppy disk does not contain the %s directory"),dir);
#else
		vaproblemBox(_("Error"),_("Your ramdisk does not contain the %s directory"),dir);
#endif
		umount(MOUNT_DIR);
		return -1;
	}
#if !(#cpu(s390))
	strcat(dir,"/");			
	for ( i = 0 ; sections[i][0] != '\0' ; ++i )
	{
		strcpy(tmp_dir,dir);
		strcat(tmp_dir,sections[i]);
		if ( ! NAME_ISDIR(tmp_dir,&statbuf) )
		{
			continue;
		}
		strcpy(command,"cp ");
		strcat(command,tmp_dir);
		strcat(command,"/*.o /target/lib/modules/");
		strcat(command,kver);
		strcat(command,"/");
		strcat(command,sections[i]);
		execlog(command,LOG_INFO);
	}
#else
	sprintf(command, "cp -a %s/* /target/lib/modules/%s/", dir, kver);
	execlog(command,LOG_INFO);
#endif
	umount(MOUNT_DIR);
	return 0;
}
	
#ifdef _TESTING_
int main(void)
{
	boxInit();
	load_modules_after_boot();
	boxFinished();
	return 0;
}
#endif
