# bug-triage -- bug triage and forward tool.
# Copyright (C) 2007  Gustavo R. Montesino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import pygtk
pygtk.require("2.0")
import gobject
import gtk

from bzutils.bug import Bug
from bzutils.bugzilla import Bugzilla
from msg_exception import errorhandler

class InvalidBugzillaError(Exception):
    pass

class bz_bug_store(gtk.ListStore):
    """Bugzilla upstream bugs TreeModel"""

    COLUMN_ID = 0
    COLUMN_PRODUCT = 1
    COLUMN_COMPONENT = 2
    COLUMN_STATUS = 3
    COLUMN_RESOLUTION = 4
    COLUMN_REPORTER = 5
    COLUMN_ASSIGNEE = 6
    COLUMN_SUMMARY = 7
    COLUMN_PRIORITY = 8
    COLUMN_SEVERITY = 9
    COLUMN_URL = 10

    @errorhandler
    def __init__(self, data=None, bugs=None):
        """Initializes the store with the related bugs.

        Ths store can be initialized passing one of data or bugs:

        data: dictionary with information about the upstream bugzilla
        bugs: list of bugs """

        gtk.ListStore.__init__(self,
            gobject.TYPE_STRING,
            gobject.TYPE_STRING,
            gobject.TYPE_STRING,
            gobject.TYPE_STRING,
            gobject.TYPE_STRING,
            gobject.TYPE_STRING,
            gobject.TYPE_STRING,
            gobject.TYPE_STRING,
            gobject.TYPE_STRING,
            gobject.TYPE_STRING,
            gobject.TYPE_STRING
            )

        if data != None:
            if not data.has_key("server"):
                raise InvalidBugzillaError("Bugzilla server URL nor specified.")

            server = Bugzilla(data["server"])
            chart = []

            if data.has_key("product"):
                chart.append((None, "product", "equals", data["product"]))
                if data.has_key("component"):
                    chart.append(("AND", "component", "equals", data["component"]))
            else:
                raise InvalidBugzillaError("Bugzilla product not specified.")

            bugs = server.query(charts=[chart])

        if bugs != None:
            for bug in bugs:
                self.append(bug)
        else:
            raise InvalidBugzillaError("Couldn't get the bugs from Bugzilla.")

        self.set_sort_column_id(self.COLUMN_COMPONENT, gtk.SORT_ASCENDING)

    @errorhandler
    def bug_to_list(self, bug):
        """Converts a Bug instance to a list useable with ListStore methods"""

        list = []
        list.append(bug.get_id())
        list.append(bug.get_product())
        list.append(bug.get_component())
        list.append(bug.get_status())
        list.append(bug.get_resolution())
        list.append(bug.get_reporter())
        list.append(bug.get_assignee())
        list.append(bug.get_summary())
        list.append(bug.get_priority())
        list.append(bug.get_severity())
        list.append(bug.get_url())

        return list

    @errorhandler
    def append(self, bug):
        gtk.ListStore.append(self, self.bug_to_list(bug))

    @errorhandler
    def get(self, iter):
        """Returns the bug pointed by the iter GtkTreeIter"""

        bug = Bug(id=gtk.ListStore.get(self, iter, self.COLUMN_ID)[0])
        bug.set_product(gtk.ListStore.get(self, iter, self.COLUMN_PRODUCT)[0])
        bug.set_component(gtk.ListStore.get(self, iter, self.COLUMN_COMPONENT)[0])
        bug.set_status(gtk.ListStore.get(self, iter, self.COLUMN_STATUS)[0])
        bug.set_resolution(gtk.ListStore.get(self, iter, self.COLUMN_RESOLUTION)[0])
        bug.set_reporter(gtk.ListStore.get(self, iter, self.COLUMN_REPORTER)[0])
        bug.set_assignee(gtk.ListStore.get(self, iter, self.COLUMN_ASSIGNEE)[0])
        bug.set_summary(gtk.ListStore.get(self, iter, self.COLUMN_SUMMARY)[0])
        bug.set_priority(gtk.ListStore.get(self, iter, self.COLUMN_PRIORITY)[0])
        bug.set_severity(gtk.ListStore.get(self, iter, self.COLUMN_SEVERITY)[0])
        bug.set_url(gtk.ListStore.get(self, iter, self.COLUMN_URL)[0])

        return bug

# vim: tabstop=4 expandtab shiftwidth=4
