# bug-triage -- bug triage and forward tool.
# Copyright (C) 2007  Gustavo R. Montesino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import pygtk
pygtk.require("2.0")
import gtk
import gtk.glade

import bt_exceptions
from bz_bug_store import bz_bug_store
from config import btstype
from msg_exception import errorhandler

class dlg_upstream:
    """Upstream forwarding dialog"""

    RESPONSE_CANCEL = 0
    RESPONSE_OK = 1
    RESPONSE_NEW = 2

    @errorhandler
    def __init__(self, glade_path, type, upstream_bugs):
        """Creates a new upstream dialog
        
        glade_path: Path to the glade xml files
        bug: debubgs bug which we are searching upstream
        type: upstream BTS type
        upstream_bugs: list of upstream bugs
        """

        self.glade_path = glade_path

        self.xml = gtk.glade.XML(glade_path + "dlg_upstream.glade")
        self.xml.signal_autoconnect(self)

        self.dlg = self.xml.get_widget("dlg_upstream")
        self.view = self.xml.get_widget("tv_upstream")

        if type == btstype.BUGZILLA:
            self.model = bz_bug_store(bugs=upstream_bugs)

            renderer = gtk.CellRendererText()
            col_id = gtk.TreeViewColumn("Id", renderer, 
                text = self.model.COLUMN_ID)
            col_id.set_sort_column_id(self.model.COLUMN_ID)
            self.view.append_column(col_id)

            col_comp = gtk.TreeViewColumn("Component", renderer,
                text = self.model.COLUMN_COMPONENT)
            col_comp.set_sort_column_id(self.model.COLUMN_COMPONENT)
            self.view.append_column(col_comp)

            col_sum = gtk.TreeViewColumn("Summary", renderer,
                text = self.model.COLUMN_SUMMARY)
            col_sum.set_sort_column_id(self.model.COLUMN_SUMMARY)
            self.view.append_column(col_sum)

            self.view.set_model(self.model)

        else:
            raise bt_exceptions.InvalidBTSError("Unknown bug tracking system: %s" % 
                package.get_type)

    @errorhandler
    def get_selection(self):
        """Returns a list with the selected bugs."""

        selection = self.view.get_selection()
        model, rows = selection.get_selected_rows()

        bugs = []
        for row in rows:
            bugs.append(model.get(model.get_iter(row)))

        return bugs

    @errorhandler
    def run(self):
        return self.dlg.run()

    @errorhandler
    def show(self):
        """Show the upstream dialog to the user"""
        self.dlg.show()

    @errorhandler
    def hide(self, object=None):
        self.dlg.hide()

# vim: tabstop=4 expandtab shiftwidth=4
