# bug-triage -- bug triage and forward tool.
# Copyright (C) 2007  Gustavo R. Montesino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import pygtk
pygtk.require("2.0")
import gtk
import gtk.glade

from btsutils.debbugs import debbugs

import actions
from config import packages
from config.config import Config

from bug_store import bug_store
from bug_view import bug_view
from dlg_config import dlg_config
from dlg_package import dlg_package
from dlg_qbuilder import dlg_qbuilder
from dlg_upstream import dlg_upstream
from msg_exception import errorhandler

class win_main:
    """Callback functions for the main window"""

    @errorhandler
    def __init__(self, glade_path):
        """Initializes the class

        ui_xml should be the path for the glade files"""

        self.glade_path = glade_path
        self.xml = gtk.glade.XML(glade_path + "win_main.glade")
        self.xml.signal_autoconnect(self)

        self.window = self.xml.get_widget("win_main")

        self.tv_bugs = bug_view(self.xml)
        self.xml.signal_autoconnect(self.tv_bugs)

        self.entry_query = self.xml.get_widget("entry_query")

        self.tb_show = self.xml.get_widget("tb_show")
        self.tb_show.set_sensitive(False)

        self.cfg = Config()
        self.bts = actions.bts_init() 

    @errorhandler
    def quit(self, object, event=None, data=None):
        self.window.hide()
        gtk.main_quit()
   
    @errorhandler
    def query(self, object=None):
        """Callback for query button click

        Runs the query on the query entry and show the result in
        the tree view"""

        bugs = []
        if self.cfg.get_bts_method() == "html":
            bugs = self.bts.html.query(self.entry_query.get_text())
        elif self.cfg.get_bts_method() == "soap":
            bugs = self.bts.soap.query(self.entry_query.get_text())
        else:
            bugs = self.bts.query(self.entry_query.get_text())

        model = bug_store()
        for i in bugs:
            model.append(i)

        self.tv_bugs.set_model(model)

    @errorhandler
    def query_new(self, object):

        current = self.entry_query.get_text()
        dialog = dlg_qbuilder(self.glade_path)
        response = dialog.run()

        if response == dialog.response_REPLACE:
            self.entry_query.set_text(dialog.get())
            self.query()

        elif response == dialog.response_PLUS:
            self.entry_query.set_text("%s + %s" % (current, dialog.get()))
            self.query()

        elif response == dialog.response_LESS:
            self.entry_query.set_text("%s - %s" % (current, dialog.get()))
            self.query()

        elif response == dialog.response_AND:
            self.entry_query.set_text("%s & %s" % (current, dialog.get()))
            self.query()

    @errorhandler
    def preferences(self, object):
        dialog = dlg_config(self.glade_path)
        dialog.show()

    @errorhandler
    def show(self, object):
        """Callback to show/goto button click"""

        bugs = self.tv_bugs.get_selection()
        for bug in bugs:
            actions.show(bug)

    @errorhandler
    def followup(self, object=None):
        """Callback to followup button click"""

        bugs = self.tv_bugs.get_selection()
        for bug in bugs:
            actions.followup(bug)

    @errorhandler
    def upstream(self, object=None):
        """Callback to upstream button click"""

        bugs = self.tv_bugs.get_selection()
        for bug in bugs:
            upstream = actions.upstream(bug)

            if upstream:
                type, upstream_bugs = upstream
                dlg = dlg_upstream(self.glade_path, type, upstream_bugs)
                response = dlg.run()

                if response == dlg.RESPONSE_NEW:
                    actions.upstream_new(bug)

                elif response == dlg.RESPONSE_OK:
                    self.bts.forward(bug.getBug(), dlg.get_selection()[0].get_url())

                dlg.hide()

            elif upstream == None:
                # The package's upstream BTS isn't configured
                dlg = dlg_package(self.glade_path)
                dlg.set_package(bug.getPackage())
                response = dlg.run()
                dlg.hide()
                if response == dlg.RESPONSE_OK:
                    packages.set(dlg.get_package(), dlg.get_type(), dlg.get_data())
                    self.upstream()

# vim: tabstop=4 expandtab shiftwidth=4
