/* bzflag
 * Copyright (c) 1993 - 2001 Tim Riker
 *
 * This package is free software;  you can redistribute it and/or
 * modify it under the terms of the license found in the file
 * named LICENSE that should have accompanied this file.
 *
 * THIS PACKAGE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/* OpenGLDisplayList:
 *	Encapsulates an OpenGL display list.
 */

#ifndef	BZF_OPENGL_DISPLAYLIST_H
#define	BZF_OPENGL_DISPLAYLIST_H

#include "bzfgl.h"
#include "common.h"

class OpenGLDisplayList {
  public:
			OpenGLDisplayList();
			OpenGLDisplayList(const OpenGLDisplayList&);
			~OpenGLDisplayList();
    OpenGLDisplayList&	operator=(const OpenGLDisplayList&);

    boolean		operator==(const OpenGLDisplayList&) const;
    boolean		operator!=(const OpenGLDisplayList&) const;
    boolean		operator<(const OpenGLDisplayList&) const;
    boolean		isValid() const;
    GLuint		getList() const;

    void		begin();
    void		end();
    void		execute();

  private:
    class Rep {
      public:
			Rep();
			~Rep();
      public:
	int		refCount;
	GLuint		list;
    };

    void		ref();
    boolean		unref();

  private:
    Rep*		rep;
};

#endif // BZF_OPENGL_DISPLAYLIST_H
