/**
 * @file em1541.c
 * Transfer routines for the Commodore serial bus to Amiga cable
 * designed for the Emul_1541 package
 * @author Marko Mkel (msmakela@nic.funet.fi)
 * @author Olaf Seibert (rhialto@mbfys.kun.nl)
 */

/*
 * Copyright  1994-1997 Marko Mkel and Olaf Seibert
 * Copyright  2001 Marko Mkel
 * Original Linux and Commodore 64/128/Vic-20 version by Marko Mkel
 * Ported to the PET and the Amiga series by Olaf Seibert
 * Restructured by Marko Mkel
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef COMM_AMIGA

/** This cable does not have inverters */
# define NO_INVERTERS
/** @name Rename the emul1541_ functions to em1541_ */
/**@{*/
# define emul1541_init em1541_init
# define emul1541_close em1541_close
# define emul1541_rs em1541_rs
# define emul1541_sr em1541_sr
# define emul1541_write em1541_write
# define emul1541_read em1541_read
/**@}*/

# include "emul1541.c"

#endif /* COMM_AMIGA */
