/**
 * @file qdisk.h
 * Extension for quick 1541 disk operations on the remote host
 * @author Marko Mkel (msmakela@nic.funet.fi)
 */

/*
 * Copyright  2002 Marko Mkel
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/** fast format a 1541 disk
 * @param comm		the communication primitives
 * @param file		output file for disk status message
 * @param name		disk name (16 characters, not NUL terminated)
 * @param id1		first ID byte
 * @param id2		second ID byte
 * @return		zero on success, nonzero on error
 */
int
qdisk_format (const struct comm* comm,
	      FILE* file,
	      const char* name,
	      char id1,
	      char id2);

/** install the code for copying 1541 tracks
 * @param comm		the communication primitives
 * @param hostinfo	information on the remote host
 * @return		zero on success, nonzero on error
 */
int
qdisk_install (const struct comm* comm,
	       const struct hostinfo* hostinfo);

/** remove the code for copying 1541 tracks
 * @param comm		the communication primitives
 * @return		zero on success, nonzero on error
 */
int
qdisk_remove (const struct comm* comm);

/** fast read a disk
 * @param comm		the communication primitives
 * @param file		output file for disk image
 * @param buf		work area
 * @return		zero on success, nonzero on error
 */
int
qdisk_read (const struct comm* comm,
	    FILE* file,
	    char* buf);

/** fast write a disk
 * @param comm		the communication primitives
 * @param file		input file for disk image
 * @param interleave	the interleave factor
 * @param buf		work area
 * @return		zero on success, nonzero on error
 */
int
qdisk_write (const struct comm* comm,
	     FILE* file,
	     unsigned interleave,
	     char* buf);
