/***************************************************************************
                          interface_widget_sample_import.cpp  -  description
                             -------------------
    begin                : Sun Apr 15 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface_widget_sample_import.h"

Sample_Import::Sample_Import(Loader *p_loader,Player_Realtime_Keyboard *p_keyboard,int p_source_sample_pos)
: Gtk::Window(GTK_WINDOW_TOPLEVEL), frame1("Samples:"), sample_viewer("Waveform:"), checkbutton_sample_import_create_instruments("Create Instrument(s)"), frame2("Options"), button_sample_import_ok("OK"), button_sample_import_cancel("Cancel"), clist_sample_import(3)
{

   int i;
   gchar *empty_strings[3]={"","",""};

   set_usize(500,400);
  set_position(GTK_WIN_POS_CENTER);
  set_modal(true);	
//  set_policy(false, false, false);

   clist_sample_import.set_name("clist_sample_import");
   clist_sample_import.set_column_title(0, "Name");
   clist_sample_import.set_column_justification(0, GTK_JUSTIFY_CENTER);
   clist_sample_import.set_column_width(0, 218);
   clist_sample_import.set_column_title(1, "Length");
   clist_sample_import.set_column_justification(1, GTK_JUSTIFY_CENTER);
   clist_sample_import.set_column_width(1, 46);
   clist_sample_import.set_column_title(2, "Quality");
   clist_sample_import.set_column_justification(2, GTK_JUSTIFY_CENTER);
   clist_sample_import.set_column_width(2, 46);
   clist_sample_import.column_titles_show();

   clist_sample_import.select_row.connect(slot(this,&Sample_Import::on_clist_sample_import_select_row));
//   connect_to_method(clist_sample_import.select_row, (Sample_Import*)this, &Sample_Import::on_clist_sample_import_select_row);
//   connect_to_method(clist_sample_import.key_press_event, (Sample_Import*)this, &Sample_Import::on_clist_sample_import_key_press_event);
//   connect_to_method(clist_sample_import.key_release_event, (Sample_Import*)this, &Sample_Import::on_clist_sample_import_key_release_event);
   scrolledwindow1.set_name("scrolledwindow1");
   scrolledwindow1.set_policy(GTK_POLICY_ALWAYS, GTK_POLICY_ALWAYS);
   scrolledwindow1.add(clist_sample_import);
   frame1.set_name("frame1");
   frame1.set_label_align(0, 0);
   frame1.set_shadow_type(GTK_SHADOW_ETCHED_IN);
   frame1.add(scrolledwindow1);
   sample_viewer.set_usize(-1, 80);
   sample_viewer.set_name("sample_viewer");
   sample_viewer.set_label_align(0, 0);
   sample_viewer.set_shadow_type(GTK_SHADOW_ETCHED_IN);
//   sample_viewer.add(sample_view);
   checkbutton_sample_import_create_instruments.set_name("checkbutton_sample_import_create_instruments");
   checkbutton_sample_import_create_instruments.set_border_width(4);
//   connect_to_method(checkbutton_sample_import_create_instruments.clicked, (Sample_Import*)this, &Sample_Import::on_checkbutton_sample_import_create_instruments_clicked);
   frame2.set_name("frame2");
   frame2.set_label_align(0, 0);
   frame2.set_shadow_type(GTK_SHADOW_ETCHED_IN);
   frame2.add(checkbutton_sample_import_create_instruments);
   button_sample_import_ok.set_usize(50, -1);
   button_sample_import_ok.set_name("button_sample_import_ok");
   button_sample_import_ok.clicked.connect(slot(this,&Sample_Import::button_ok_pressed));
   button_sample_import_cancel.clicked.connect(slot(this,&Sample_Import::button_cancel_pressed));

   hseparator1.set_name("hseparator1");
   button_sample_import_cancel.set_usize(50, -1);
   button_sample_import_cancel.set_name("button_sample_import_cancel");
//   connect_to_method(button_sample_import_cancel.clicked, (Sample_Import*)this, &Sample_Import::on_button_sample_import_cancel_clicked);
   hbox1.set_name("hbox1");
   hbox1.pack_start(button_sample_import_ok, false, false, 0);
   hbox1.pack_start(hseparator1);
   hbox1.pack_start(button_sample_import_cancel, false, false, 0);
   vbox1.set_name("vbox1");
   vbox1.pack_start(frame1, true, true, 4);
//   vbox1.pack_start(sample_viewer, false, false, 0);
   vbox1.pack_start(frame2, false, false, 4);
   vbox1.pack_start(hbox1, false, true, 5);
   set_name("Sample Import");
   set_title("Import samples from file");
   add(vbox1);
   clist_sample_import.show();
   scrolledwindow1.show();
   frame1.show();
//   sample_view.show();
   sample_viewer.show();
   checkbutton_sample_import_create_instruments.show();
   frame2.show();
   button_sample_import_ok.show();
   hseparator1.show();
   button_sample_import_cancel.show();
   hbox1.show();
   vbox1.show();
   show();
   key_press_event.connect(slot(this,&Sample_Import::key_press_event_callback));

	source_sample_pos=p_source_sample_pos;

   	add_events(GDK_KEY_RELEASE_MASK);
   	add_events(GDK_KEY_PRESS_MASK);

	loader=p_loader;
	keyboard=p_keyboard;

	for (i=0;i<loader->get_amount_of_samples();i++) {
		
		char tmp_name[40];
		char tmp_length[20];
		
                sprintf(tmp_name,"%i- %s ",i,loader->get_sample_name(i).c_str());
                sprintf(tmp_length,"%i ",loader->get_sample_data(i)->size);

		clist_sample_import.append(empty_strings);
		clist_sample_import.set_text(i,0,tmp_name);
		clist_sample_import.set_text(i,1,tmp_length);
		clist_sample_import.set_text(i,2,(loader->get_sample_data(i)->is_16bits?"16 bits":"8 bits"));

	}
	clist_sample_import.set_column_justification(0,GTK_JUSTIFY_LEFT);
	clist_sample_import.set_column_justification(1,GTK_JUSTIFY_LEFT);
	clist_sample_import.set_column_justification(2,GTK_JUSTIFY_LEFT);

	selected_row=-1;
	
}

void Sample_Import::button_cancel_pressed() {



	action=CANCEL;
}

void Sample_Import::button_ok_pressed() {

	if (selected_row>=0) action=OK;
}

void Sample_Import::on_clist_sample_import_select_row(gint row, gint column, GdkEvent *event) {


	keyboard->sample_set(loader->get_sample_data(row));
//	sample_view.set_redraw_all();
//	sample_view.set_sample(loader->get_sample_data(row));
	selected_row=row;
}


bool Sample_Import::do_main_loop(Gtk::Main &p_kit) {

	action=WAITING;

	do {

		while (p_kit.events_pending()) p_kit.iteration();
		usleep(10000);

	} while (action==WAITING);

	if (action==OK) loader->add_sample_to_song(selected_row,source_sample_pos,checkbutton_sample_import_create_instruments.get_active());

	return action==OK;
}


Sample_Import::~Sample_Import() {

	keyboard->sample_stop_all();
}
